/* Copyright (c) 2019, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */
#if !defined(_IPA_GCC_HWIO_H_)
#define _IPA_GCC_HWIO_H_

/* *****************************************************************************
 *
 * HWIO register definitions
 *
 * *****************************************************************************
 */
#define GCC_CLK_CTL_REG_REG_BASE (CLK_CTL_BASE + 0x00000000)
#define GCC_CLK_CTL_REG_REG_BASE_PHYS (CLK_CTL_BASE_PHYS + 0x00000000)
#define GCC_CLK_CTL_REG_REG_BASE_OFFS 0x00000000
#define HWIO_GCC_GPLL0_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00000000)
#define HWIO_GCC_GPLL0_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00000000)
#define HWIO_GCC_GPLL0_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00000000)
#define HWIO_GCC_GPLL0_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00000004)
#define HWIO_GCC_GPLL0_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00000004)
#define HWIO_GCC_GPLL0_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00000004)
#define HWIO_GCC_GPLL0_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00000008)
#define HWIO_GCC_GPLL0_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00000008)
#define HWIO_GCC_GPLL0_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00000008)
#define HWIO_GCC_GPLL0_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000000c)
#define HWIO_GCC_GPLL0_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000000c)
#define HWIO_GCC_GPLL0_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000000c)
#define HWIO_GCC_GPLL0_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00000010)
#define HWIO_GCC_GPLL0_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00000010)
#define HWIO_GCC_GPLL0_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00000010)
#define HWIO_GCC_GPLL0_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00000014)
#define HWIO_GCC_GPLL0_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00000014)
#define HWIO_GCC_GPLL0_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00000014)
#define HWIO_GCC_GPLL0_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00000018)
#define HWIO_GCC_GPLL0_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00000018)
#define HWIO_GCC_GPLL0_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00000018)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000001c)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000001c)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000001c)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00000020)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00000020)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00000020)
#define HWIO_GCC_GPLL0_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00000024)
#define HWIO_GCC_GPLL0_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00000024)
#define HWIO_GCC_GPLL0_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00000024)
#define HWIO_GCC_GPLL0_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00000028)
#define HWIO_GCC_GPLL0_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00000028)
#define HWIO_GCC_GPLL0_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00000028)
#define HWIO_GCC_GPLL0_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000002c)
#define HWIO_GCC_GPLL0_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000002c)
#define HWIO_GCC_GPLL0_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000002c)
#define HWIO_GCC_GPLL0_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00000030)
#define HWIO_GCC_GPLL0_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00000030)
#define HWIO_GCC_GPLL0_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00000030)
#define HWIO_GCC_GPLL0_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00000034)
#define HWIO_GCC_GPLL0_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00000034)
#define HWIO_GCC_GPLL0_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00000034)
#define HWIO_GCC_GPLL0_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00000038)
#define HWIO_GCC_GPLL0_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00000038)
#define HWIO_GCC_GPLL0_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00000038)
#define HWIO_GCC_GPLL0_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000003c)
#define HWIO_GCC_GPLL0_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0000003c)
#define HWIO_GCC_GPLL0_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0000003c)
#define HWIO_GCC_GPLL0_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00000040)
#define HWIO_GCC_GPLL0_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00000040)
#define HWIO_GCC_GPLL0_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00000040)
#define HWIO_GCC_GPLL0_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00000044)
#define HWIO_GCC_GPLL0_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00000044)
#define HWIO_GCC_GPLL0_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00000044)
#define HWIO_GCC_GPLL0_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00000048)
#define HWIO_GCC_GPLL0_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00000048)
#define HWIO_GCC_GPLL0_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00000048)
#define HWIO_GCC_GPLL0_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000004c)
#define HWIO_GCC_GPLL0_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000004c)
#define HWIO_GCC_GPLL0_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000004c)
#define HWIO_GCC_GPLL0_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00000050)
#define HWIO_GCC_GPLL0_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00000050)
#define HWIO_GCC_GPLL0_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00000050)
#define HWIO_GCC_GPLL1_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00001000)
#define HWIO_GCC_GPLL1_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00001000)
#define HWIO_GCC_GPLL1_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00001000)
#define HWIO_GCC_GPLL1_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00001004)
#define HWIO_GCC_GPLL1_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00001004)
#define HWIO_GCC_GPLL1_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00001004)
#define HWIO_GCC_GPLL1_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00001008)
#define HWIO_GCC_GPLL1_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00001008)
#define HWIO_GCC_GPLL1_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00001008)
#define HWIO_GCC_GPLL1_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000100c)
#define HWIO_GCC_GPLL1_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000100c)
#define HWIO_GCC_GPLL1_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000100c)
#define HWIO_GCC_GPLL1_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00001010)
#define HWIO_GCC_GPLL1_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00001010)
#define HWIO_GCC_GPLL1_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00001010)
#define HWIO_GCC_GPLL1_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00001014)
#define HWIO_GCC_GPLL1_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00001014)
#define HWIO_GCC_GPLL1_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00001014)
#define HWIO_GCC_GPLL1_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00001018)
#define HWIO_GCC_GPLL1_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00001018)
#define HWIO_GCC_GPLL1_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00001018)
#define HWIO_GCC_GPLL1_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000101c)
#define HWIO_GCC_GPLL1_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000101c)
#define HWIO_GCC_GPLL1_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000101c)
#define HWIO_GCC_GPLL1_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00001020)
#define HWIO_GCC_GPLL1_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00001020)
#define HWIO_GCC_GPLL1_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00001020)
#define HWIO_GCC_GPLL1_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00001024)
#define HWIO_GCC_GPLL1_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00001024)
#define HWIO_GCC_GPLL1_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00001024)
#define HWIO_GCC_GPLL1_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00001028)
#define HWIO_GCC_GPLL1_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00001028)
#define HWIO_GCC_GPLL1_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00001028)
#define HWIO_GCC_GPLL1_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000102c)
#define HWIO_GCC_GPLL1_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000102c)
#define HWIO_GCC_GPLL1_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000102c)
#define HWIO_GCC_GPLL1_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00001030)
#define HWIO_GCC_GPLL1_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00001030)
#define HWIO_GCC_GPLL1_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00001030)
#define HWIO_GCC_GPLL1_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00001034)
#define HWIO_GCC_GPLL1_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00001034)
#define HWIO_GCC_GPLL1_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00001034)
#define HWIO_GCC_GPLL1_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00001038)
#define HWIO_GCC_GPLL1_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00001038)
#define HWIO_GCC_GPLL1_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00001038)
#define HWIO_GCC_GPLL1_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000103c)
#define HWIO_GCC_GPLL1_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0000103c)
#define HWIO_GCC_GPLL1_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0000103c)
#define HWIO_GCC_GPLL1_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00001040)
#define HWIO_GCC_GPLL1_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00001040)
#define HWIO_GCC_GPLL1_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00001040)
#define HWIO_GCC_GPLL1_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00001044)
#define HWIO_GCC_GPLL1_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00001044)
#define HWIO_GCC_GPLL1_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00001044)
#define HWIO_GCC_GPLL1_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00001048)
#define HWIO_GCC_GPLL1_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00001048)
#define HWIO_GCC_GPLL1_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00001048)
#define HWIO_GCC_GPLL1_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000104c)
#define HWIO_GCC_GPLL1_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000104c)
#define HWIO_GCC_GPLL1_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000104c)
#define HWIO_GCC_GPLL1_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00001050)
#define HWIO_GCC_GPLL1_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00001050)
#define HWIO_GCC_GPLL1_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00001050)
#define HWIO_GCC_GPLL2_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00002000)
#define HWIO_GCC_GPLL2_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00002000)
#define HWIO_GCC_GPLL2_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00002000)
#define HWIO_GCC_GPLL2_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00002004)
#define HWIO_GCC_GPLL2_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00002004)
#define HWIO_GCC_GPLL2_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00002004)
#define HWIO_GCC_GPLL2_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00002008)
#define HWIO_GCC_GPLL2_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00002008)
#define HWIO_GCC_GPLL2_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00002008)
#define HWIO_GCC_GPLL2_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000200c)
#define HWIO_GCC_GPLL2_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000200c)
#define HWIO_GCC_GPLL2_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000200c)
#define HWIO_GCC_GPLL2_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00002010)
#define HWIO_GCC_GPLL2_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00002010)
#define HWIO_GCC_GPLL2_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00002010)
#define HWIO_GCC_GPLL2_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00002014)
#define HWIO_GCC_GPLL2_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00002014)
#define HWIO_GCC_GPLL2_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00002014)
#define HWIO_GCC_GPLL2_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00002018)
#define HWIO_GCC_GPLL2_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00002018)
#define HWIO_GCC_GPLL2_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00002018)
#define HWIO_GCC_GPLL2_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000201c)
#define HWIO_GCC_GPLL2_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000201c)
#define HWIO_GCC_GPLL2_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000201c)
#define HWIO_GCC_GPLL2_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00002020)
#define HWIO_GCC_GPLL2_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00002020)
#define HWIO_GCC_GPLL2_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00002020)
#define HWIO_GCC_GPLL2_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00002024)
#define HWIO_GCC_GPLL2_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00002024)
#define HWIO_GCC_GPLL2_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00002024)
#define HWIO_GCC_GPLL2_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00002028)
#define HWIO_GCC_GPLL2_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00002028)
#define HWIO_GCC_GPLL2_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00002028)
#define HWIO_GCC_GPLL2_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000202c)
#define HWIO_GCC_GPLL2_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000202c)
#define HWIO_GCC_GPLL2_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000202c)
#define HWIO_GCC_GPLL2_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00002030)
#define HWIO_GCC_GPLL2_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00002030)
#define HWIO_GCC_GPLL2_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00002030)
#define HWIO_GCC_GPLL2_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00002034)
#define HWIO_GCC_GPLL2_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00002034)
#define HWIO_GCC_GPLL2_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00002034)
#define HWIO_GCC_GPLL2_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00002038)
#define HWIO_GCC_GPLL2_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00002038)
#define HWIO_GCC_GPLL2_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00002038)
#define HWIO_GCC_GPLL2_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000203c)
#define HWIO_GCC_GPLL2_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0000203c)
#define HWIO_GCC_GPLL2_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0000203c)
#define HWIO_GCC_GPLL2_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00002040)
#define HWIO_GCC_GPLL2_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00002040)
#define HWIO_GCC_GPLL2_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00002040)
#define HWIO_GCC_GPLL2_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00002044)
#define HWIO_GCC_GPLL2_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00002044)
#define HWIO_GCC_GPLL2_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00002044)
#define HWIO_GCC_GPLL2_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00002048)
#define HWIO_GCC_GPLL2_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00002048)
#define HWIO_GCC_GPLL2_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00002048)
#define HWIO_GCC_GPLL2_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000204c)
#define HWIO_GCC_GPLL2_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000204c)
#define HWIO_GCC_GPLL2_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000204c)
#define HWIO_GCC_GPLL2_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00002050)
#define HWIO_GCC_GPLL2_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00002050)
#define HWIO_GCC_GPLL2_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00002050)
#define HWIO_GCC_GPLL3_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00003000)
#define HWIO_GCC_GPLL3_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00003000)
#define HWIO_GCC_GPLL3_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00003000)
#define HWIO_GCC_GPLL3_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00003004)
#define HWIO_GCC_GPLL3_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00003004)
#define HWIO_GCC_GPLL3_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00003004)
#define HWIO_GCC_GPLL3_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00003008)
#define HWIO_GCC_GPLL3_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00003008)
#define HWIO_GCC_GPLL3_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00003008)
#define HWIO_GCC_GPLL3_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000300c)
#define HWIO_GCC_GPLL3_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000300c)
#define HWIO_GCC_GPLL3_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000300c)
#define HWIO_GCC_GPLL3_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00003010)
#define HWIO_GCC_GPLL3_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00003010)
#define HWIO_GCC_GPLL3_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00003010)
#define HWIO_GCC_GPLL3_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00003014)
#define HWIO_GCC_GPLL3_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00003014)
#define HWIO_GCC_GPLL3_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00003014)
#define HWIO_GCC_GPLL3_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00003018)
#define HWIO_GCC_GPLL3_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00003018)
#define HWIO_GCC_GPLL3_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00003018)
#define HWIO_GCC_GPLL3_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000301c)
#define HWIO_GCC_GPLL3_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000301c)
#define HWIO_GCC_GPLL3_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000301c)
#define HWIO_GCC_GPLL3_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00003020)
#define HWIO_GCC_GPLL3_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00003020)
#define HWIO_GCC_GPLL3_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00003020)
#define HWIO_GCC_GPLL3_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00003024)
#define HWIO_GCC_GPLL3_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00003024)
#define HWIO_GCC_GPLL3_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00003024)
#define HWIO_GCC_GPLL3_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00003028)
#define HWIO_GCC_GPLL3_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00003028)
#define HWIO_GCC_GPLL3_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00003028)
#define HWIO_GCC_GPLL3_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000302c)
#define HWIO_GCC_GPLL3_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000302c)
#define HWIO_GCC_GPLL3_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000302c)
#define HWIO_GCC_GPLL3_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00003030)
#define HWIO_GCC_GPLL3_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00003030)
#define HWIO_GCC_GPLL3_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00003030)
#define HWIO_GCC_GPLL3_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00003034)
#define HWIO_GCC_GPLL3_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00003034)
#define HWIO_GCC_GPLL3_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00003034)
#define HWIO_GCC_GPLL3_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00003038)
#define HWIO_GCC_GPLL3_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00003038)
#define HWIO_GCC_GPLL3_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00003038)
#define HWIO_GCC_GPLL3_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000303c)
#define HWIO_GCC_GPLL3_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0000303c)
#define HWIO_GCC_GPLL3_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0000303c)
#define HWIO_GCC_GPLL3_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00003040)
#define HWIO_GCC_GPLL3_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00003040)
#define HWIO_GCC_GPLL3_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00003040)
#define HWIO_GCC_GPLL3_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00003044)
#define HWIO_GCC_GPLL3_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00003044)
#define HWIO_GCC_GPLL3_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00003044)
#define HWIO_GCC_GPLL3_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00003048)
#define HWIO_GCC_GPLL3_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00003048)
#define HWIO_GCC_GPLL3_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00003048)
#define HWIO_GCC_GPLL3_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000304c)
#define HWIO_GCC_GPLL3_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000304c)
#define HWIO_GCC_GPLL3_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000304c)
#define HWIO_GCC_GPLL3_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00003050)
#define HWIO_GCC_GPLL3_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00003050)
#define HWIO_GCC_GPLL3_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00003050)
#define HWIO_GCC_GPLL4_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00076000)
#define HWIO_GCC_GPLL4_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00076000)
#define HWIO_GCC_GPLL4_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00076000)
#define HWIO_GCC_GPLL4_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00076004)
#define HWIO_GCC_GPLL4_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00076004)
#define HWIO_GCC_GPLL4_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00076004)
#define HWIO_GCC_GPLL4_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00076008)
#define HWIO_GCC_GPLL4_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00076008)
#define HWIO_GCC_GPLL4_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00076008)
#define HWIO_GCC_GPLL4_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0007600c)
#define HWIO_GCC_GPLL4_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0007600c)
#define HWIO_GCC_GPLL4_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0007600c)
#define HWIO_GCC_GPLL4_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00076010)
#define HWIO_GCC_GPLL4_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00076010)
#define HWIO_GCC_GPLL4_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00076010)
#define HWIO_GCC_GPLL4_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00076014)
#define HWIO_GCC_GPLL4_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00076014)
#define HWIO_GCC_GPLL4_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00076014)
#define HWIO_GCC_GPLL4_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00076018)
#define HWIO_GCC_GPLL4_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00076018)
#define HWIO_GCC_GPLL4_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00076018)
#define HWIO_GCC_GPLL4_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0007601c)
#define HWIO_GCC_GPLL4_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0007601c)
#define HWIO_GCC_GPLL4_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0007601c)
#define HWIO_GCC_GPLL4_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00076020)
#define HWIO_GCC_GPLL4_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00076020)
#define HWIO_GCC_GPLL4_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00076020)
#define HWIO_GCC_GPLL4_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00076024)
#define HWIO_GCC_GPLL4_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00076024)
#define HWIO_GCC_GPLL4_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00076024)
#define HWIO_GCC_GPLL4_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00076028)
#define HWIO_GCC_GPLL4_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00076028)
#define HWIO_GCC_GPLL4_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00076028)
#define HWIO_GCC_GPLL4_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0007602c)
#define HWIO_GCC_GPLL4_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0007602c)
#define HWIO_GCC_GPLL4_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0007602c)
#define HWIO_GCC_GPLL4_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00076030)
#define HWIO_GCC_GPLL4_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00076030)
#define HWIO_GCC_GPLL4_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00076030)
#define HWIO_GCC_GPLL4_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00076034)
#define HWIO_GCC_GPLL4_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00076034)
#define HWIO_GCC_GPLL4_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00076034)
#define HWIO_GCC_GPLL4_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00076038)
#define HWIO_GCC_GPLL4_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00076038)
#define HWIO_GCC_GPLL4_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00076038)
#define HWIO_GCC_GPLL4_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007603c)
#define HWIO_GCC_GPLL4_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0007603c)
#define HWIO_GCC_GPLL4_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0007603c)
#define HWIO_GCC_GPLL4_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00076040)
#define HWIO_GCC_GPLL4_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00076040)
#define HWIO_GCC_GPLL4_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00076040)
#define HWIO_GCC_GPLL4_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00076044)
#define HWIO_GCC_GPLL4_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00076044)
#define HWIO_GCC_GPLL4_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00076044)
#define HWIO_GCC_GPLL4_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00076048)
#define HWIO_GCC_GPLL4_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00076048)
#define HWIO_GCC_GPLL4_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00076048)
#define HWIO_GCC_GPLL4_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0007604c)
#define HWIO_GCC_GPLL4_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0007604c)
#define HWIO_GCC_GPLL4_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0007604c)
#define HWIO_GCC_GPLL4_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00076050)
#define HWIO_GCC_GPLL4_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00076050)
#define HWIO_GCC_GPLL4_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00076050)
#define HWIO_GCC_GPLL5_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00074000)
#define HWIO_GCC_GPLL5_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00074000)
#define HWIO_GCC_GPLL5_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00074000)
#define HWIO_GCC_GPLL5_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00074004)
#define HWIO_GCC_GPLL5_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00074004)
#define HWIO_GCC_GPLL5_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00074004)
#define HWIO_GCC_GPLL5_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00074008)
#define HWIO_GCC_GPLL5_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00074008)
#define HWIO_GCC_GPLL5_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00074008)
#define HWIO_GCC_GPLL5_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0007400c)
#define HWIO_GCC_GPLL5_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0007400c)
#define HWIO_GCC_GPLL5_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0007400c)
#define HWIO_GCC_GPLL5_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00074010)
#define HWIO_GCC_GPLL5_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00074010)
#define HWIO_GCC_GPLL5_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00074010)
#define HWIO_GCC_GPLL5_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00074014)
#define HWIO_GCC_GPLL5_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00074014)
#define HWIO_GCC_GPLL5_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00074014)
#define HWIO_GCC_GPLL5_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00074018)
#define HWIO_GCC_GPLL5_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00074018)
#define HWIO_GCC_GPLL5_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00074018)
#define HWIO_GCC_GPLL5_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0007401c)
#define HWIO_GCC_GPLL5_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0007401c)
#define HWIO_GCC_GPLL5_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0007401c)
#define HWIO_GCC_GPLL5_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00074020)
#define HWIO_GCC_GPLL5_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00074020)
#define HWIO_GCC_GPLL5_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00074020)
#define HWIO_GCC_GPLL5_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00074024)
#define HWIO_GCC_GPLL5_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00074024)
#define HWIO_GCC_GPLL5_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00074024)
#define HWIO_GCC_GPLL5_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00074028)
#define HWIO_GCC_GPLL5_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00074028)
#define HWIO_GCC_GPLL5_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00074028)
#define HWIO_GCC_GPLL5_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0007402c)
#define HWIO_GCC_GPLL5_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0007402c)
#define HWIO_GCC_GPLL5_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0007402c)
#define HWIO_GCC_GPLL5_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00074030)
#define HWIO_GCC_GPLL5_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00074030)
#define HWIO_GCC_GPLL5_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00074030)
#define HWIO_GCC_GPLL5_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00074034)
#define HWIO_GCC_GPLL5_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00074034)
#define HWIO_GCC_GPLL5_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00074034)
#define HWIO_GCC_GPLL5_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00074038)
#define HWIO_GCC_GPLL5_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00074038)
#define HWIO_GCC_GPLL5_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00074038)
#define HWIO_GCC_GPLL5_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007403c)
#define HWIO_GCC_GPLL5_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0007403c)
#define HWIO_GCC_GPLL5_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0007403c)
#define HWIO_GCC_GPLL5_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00074040)
#define HWIO_GCC_GPLL5_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00074040)
#define HWIO_GCC_GPLL5_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00074040)
#define HWIO_GCC_GPLL5_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00074044)
#define HWIO_GCC_GPLL5_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00074044)
#define HWIO_GCC_GPLL5_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00074044)
#define HWIO_GCC_GPLL5_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00074048)
#define HWIO_GCC_GPLL5_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00074048)
#define HWIO_GCC_GPLL5_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00074048)
#define HWIO_GCC_GPLL5_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0007404c)
#define HWIO_GCC_GPLL5_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0007404c)
#define HWIO_GCC_GPLL5_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0007404c)
#define HWIO_GCC_GPLL5_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00074050)
#define HWIO_GCC_GPLL5_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00074050)
#define HWIO_GCC_GPLL5_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00074050)
#define HWIO_GCC_GPLL6_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00013000)
#define HWIO_GCC_GPLL6_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00013000)
#define HWIO_GCC_GPLL6_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00013000)
#define HWIO_GCC_GPLL6_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00013004)
#define HWIO_GCC_GPLL6_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00013004)
#define HWIO_GCC_GPLL6_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00013004)
#define HWIO_GCC_GPLL6_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00013008)
#define HWIO_GCC_GPLL6_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00013008)
#define HWIO_GCC_GPLL6_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00013008)
#define HWIO_GCC_GPLL6_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001300c)
#define HWIO_GCC_GPLL6_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001300c)
#define HWIO_GCC_GPLL6_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001300c)
#define HWIO_GCC_GPLL6_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00013010)
#define HWIO_GCC_GPLL6_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00013010)
#define HWIO_GCC_GPLL6_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00013010)
#define HWIO_GCC_GPLL6_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00013014)
#define HWIO_GCC_GPLL6_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00013014)
#define HWIO_GCC_GPLL6_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00013014)
#define HWIO_GCC_GPLL6_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00013018)
#define HWIO_GCC_GPLL6_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00013018)
#define HWIO_GCC_GPLL6_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00013018)
#define HWIO_GCC_GPLL6_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0001301c)
#define HWIO_GCC_GPLL6_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0001301c)
#define HWIO_GCC_GPLL6_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0001301c)
#define HWIO_GCC_GPLL6_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00013020)
#define HWIO_GCC_GPLL6_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00013020)
#define HWIO_GCC_GPLL6_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00013020)
#define HWIO_GCC_GPLL6_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00013024)
#define HWIO_GCC_GPLL6_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00013024)
#define HWIO_GCC_GPLL6_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00013024)
#define HWIO_GCC_GPLL6_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00013028)
#define HWIO_GCC_GPLL6_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00013028)
#define HWIO_GCC_GPLL6_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00013028)
#define HWIO_GCC_GPLL6_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001302c)
#define HWIO_GCC_GPLL6_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001302c)
#define HWIO_GCC_GPLL6_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001302c)
#define HWIO_GCC_GPLL6_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00013030)
#define HWIO_GCC_GPLL6_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00013030)
#define HWIO_GCC_GPLL6_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00013030)
#define HWIO_GCC_GPLL6_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00013034)
#define HWIO_GCC_GPLL6_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00013034)
#define HWIO_GCC_GPLL6_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00013034)
#define HWIO_GCC_GPLL6_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00013038)
#define HWIO_GCC_GPLL6_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00013038)
#define HWIO_GCC_GPLL6_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00013038)
#define HWIO_GCC_GPLL6_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001303c)
#define HWIO_GCC_GPLL6_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001303c)
#define HWIO_GCC_GPLL6_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001303c)
#define HWIO_GCC_GPLL6_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00013040)
#define HWIO_GCC_GPLL6_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00013040)
#define HWIO_GCC_GPLL6_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00013040)
#define HWIO_GCC_GPLL6_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00013044)
#define HWIO_GCC_GPLL6_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00013044)
#define HWIO_GCC_GPLL6_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00013044)
#define HWIO_GCC_GPLL6_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00013048)
#define HWIO_GCC_GPLL6_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00013048)
#define HWIO_GCC_GPLL6_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00013048)
#define HWIO_GCC_GPLL6_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001304c)
#define HWIO_GCC_GPLL6_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001304c)
#define HWIO_GCC_GPLL6_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001304c)
#define HWIO_GCC_GPLL6_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00013050)
#define HWIO_GCC_GPLL6_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00013050)
#define HWIO_GCC_GPLL6_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00013050)
#define HWIO_GCC_GPLL7_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001a000)
#define HWIO_GCC_GPLL7_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0001a000)
#define HWIO_GCC_GPLL7_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0001a000)
#define HWIO_GCC_GPLL7_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001a004)
#define HWIO_GCC_GPLL7_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001a004)
#define HWIO_GCC_GPLL7_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001a004)
#define HWIO_GCC_GPLL7_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001a008)
#define HWIO_GCC_GPLL7_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001a008)
#define HWIO_GCC_GPLL7_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001a008)
#define HWIO_GCC_GPLL7_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001a00c)
#define HWIO_GCC_GPLL7_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001a00c)
#define HWIO_GCC_GPLL7_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001a00c)
#define HWIO_GCC_GPLL7_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001a010)
#define HWIO_GCC_GPLL7_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001a010)
#define HWIO_GCC_GPLL7_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001a010)
#define HWIO_GCC_GPLL7_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001a014)
#define HWIO_GCC_GPLL7_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001a014)
#define HWIO_GCC_GPLL7_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001a014)
#define HWIO_GCC_GPLL7_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001a018)
#define HWIO_GCC_GPLL7_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001a018)
#define HWIO_GCC_GPLL7_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001a018)
#define HWIO_GCC_GPLL7_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0001a01c)
#define HWIO_GCC_GPLL7_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0001a01c)
#define HWIO_GCC_GPLL7_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0001a01c)
#define HWIO_GCC_GPLL7_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001a020)
#define HWIO_GCC_GPLL7_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001a020)
#define HWIO_GCC_GPLL7_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001a020)
#define HWIO_GCC_GPLL7_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001a024)
#define HWIO_GCC_GPLL7_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001a024)
#define HWIO_GCC_GPLL7_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001a024)
#define HWIO_GCC_GPLL7_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001a028)
#define HWIO_GCC_GPLL7_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001a028)
#define HWIO_GCC_GPLL7_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001a028)
#define HWIO_GCC_GPLL7_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001a02c)
#define HWIO_GCC_GPLL7_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001a02c)
#define HWIO_GCC_GPLL7_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001a02c)
#define HWIO_GCC_GPLL7_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001a030)
#define HWIO_GCC_GPLL7_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001a030)
#define HWIO_GCC_GPLL7_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001a030)
#define HWIO_GCC_GPLL7_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001a034)
#define HWIO_GCC_GPLL7_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001a034)
#define HWIO_GCC_GPLL7_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001a034)
#define HWIO_GCC_GPLL7_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001a038)
#define HWIO_GCC_GPLL7_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001a038)
#define HWIO_GCC_GPLL7_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001a038)
#define HWIO_GCC_GPLL7_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001a03c)
#define HWIO_GCC_GPLL7_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001a03c)
#define HWIO_GCC_GPLL7_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001a03c)
#define HWIO_GCC_GPLL7_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001a040)
#define HWIO_GCC_GPLL7_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001a040)
#define HWIO_GCC_GPLL7_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001a040)
#define HWIO_GCC_GPLL7_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001a044)
#define HWIO_GCC_GPLL7_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001a044)
#define HWIO_GCC_GPLL7_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001a044)
#define HWIO_GCC_GPLL7_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001a048)
#define HWIO_GCC_GPLL7_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001a048)
#define HWIO_GCC_GPLL7_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001a048)
#define HWIO_GCC_GPLL7_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001a04c)
#define HWIO_GCC_GPLL7_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001a04c)
#define HWIO_GCC_GPLL7_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001a04c)
#define HWIO_GCC_GPLL7_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001a050)
#define HWIO_GCC_GPLL7_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001a050)
#define HWIO_GCC_GPLL7_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001a050)
#define HWIO_GCC_GPLL8_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001b000)
#define HWIO_GCC_GPLL8_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0001b000)
#define HWIO_GCC_GPLL8_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0001b000)
#define HWIO_GCC_GPLL8_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001b004)
#define HWIO_GCC_GPLL8_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001b004)
#define HWIO_GCC_GPLL8_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001b004)
#define HWIO_GCC_GPLL8_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001b008)
#define HWIO_GCC_GPLL8_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001b008)
#define HWIO_GCC_GPLL8_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001b008)
#define HWIO_GCC_GPLL8_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001b00c)
#define HWIO_GCC_GPLL8_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001b00c)
#define HWIO_GCC_GPLL8_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001b00c)
#define HWIO_GCC_GPLL8_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001b010)
#define HWIO_GCC_GPLL8_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001b010)
#define HWIO_GCC_GPLL8_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001b010)
#define HWIO_GCC_GPLL8_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001b014)
#define HWIO_GCC_GPLL8_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001b014)
#define HWIO_GCC_GPLL8_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001b014)
#define HWIO_GCC_GPLL8_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001b018)
#define HWIO_GCC_GPLL8_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001b018)
#define HWIO_GCC_GPLL8_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001b018)
#define HWIO_GCC_GPLL8_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0001b01c)
#define HWIO_GCC_GPLL8_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0001b01c)
#define HWIO_GCC_GPLL8_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0001b01c)
#define HWIO_GCC_GPLL8_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001b020)
#define HWIO_GCC_GPLL8_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001b020)
#define HWIO_GCC_GPLL8_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001b020)
#define HWIO_GCC_GPLL8_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001b024)
#define HWIO_GCC_GPLL8_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001b024)
#define HWIO_GCC_GPLL8_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001b024)
#define HWIO_GCC_GPLL8_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001b028)
#define HWIO_GCC_GPLL8_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001b028)
#define HWIO_GCC_GPLL8_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001b028)
#define HWIO_GCC_GPLL8_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001b02c)
#define HWIO_GCC_GPLL8_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001b02c)
#define HWIO_GCC_GPLL8_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001b02c)
#define HWIO_GCC_GPLL8_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001b030)
#define HWIO_GCC_GPLL8_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001b030)
#define HWIO_GCC_GPLL8_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001b030)
#define HWIO_GCC_GPLL8_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001b034)
#define HWIO_GCC_GPLL8_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001b034)
#define HWIO_GCC_GPLL8_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001b034)
#define HWIO_GCC_GPLL8_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001b038)
#define HWIO_GCC_GPLL8_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001b038)
#define HWIO_GCC_GPLL8_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001b038)
#define HWIO_GCC_GPLL8_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001b03c)
#define HWIO_GCC_GPLL8_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001b03c)
#define HWIO_GCC_GPLL8_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001b03c)
#define HWIO_GCC_GPLL8_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001b040)
#define HWIO_GCC_GPLL8_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001b040)
#define HWIO_GCC_GPLL8_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001b040)
#define HWIO_GCC_GPLL8_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001b044)
#define HWIO_GCC_GPLL8_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001b044)
#define HWIO_GCC_GPLL8_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001b044)
#define HWIO_GCC_GPLL8_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001b048)
#define HWIO_GCC_GPLL8_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001b048)
#define HWIO_GCC_GPLL8_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001b048)
#define HWIO_GCC_GPLL8_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001b04c)
#define HWIO_GCC_GPLL8_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001b04c)
#define HWIO_GCC_GPLL8_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001b04c)
#define HWIO_GCC_GPLL8_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001b050)
#define HWIO_GCC_GPLL8_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001b050)
#define HWIO_GCC_GPLL8_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001b050)
#define HWIO_GCC_GPLL9_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001c000)
#define HWIO_GCC_GPLL9_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0001c000)
#define HWIO_GCC_GPLL9_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0001c000)
#define HWIO_GCC_GPLL9_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001c004)
#define HWIO_GCC_GPLL9_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001c004)
#define HWIO_GCC_GPLL9_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001c004)
#define HWIO_GCC_GPLL9_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001c008)
#define HWIO_GCC_GPLL9_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001c008)
#define HWIO_GCC_GPLL9_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001c008)
#define HWIO_GCC_GPLL9_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001c00c)
#define HWIO_GCC_GPLL9_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001c00c)
#define HWIO_GCC_GPLL9_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001c00c)
#define HWIO_GCC_GPLL9_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001c010)
#define HWIO_GCC_GPLL9_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001c010)
#define HWIO_GCC_GPLL9_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001c010)
#define HWIO_GCC_GPLL9_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001c014)
#define HWIO_GCC_GPLL9_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001c014)
#define HWIO_GCC_GPLL9_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001c014)
#define HWIO_GCC_GPLL9_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001c018)
#define HWIO_GCC_GPLL9_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001c018)
#define HWIO_GCC_GPLL9_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001c018)
#define HWIO_GCC_GPLL9_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0001c01c)
#define HWIO_GCC_GPLL9_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0001c01c)
#define HWIO_GCC_GPLL9_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0001c01c)
#define HWIO_GCC_GPLL9_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001c020)
#define HWIO_GCC_GPLL9_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001c020)
#define HWIO_GCC_GPLL9_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001c020)
#define HWIO_GCC_GPLL9_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001c024)
#define HWIO_GCC_GPLL9_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001c024)
#define HWIO_GCC_GPLL9_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001c024)
#define HWIO_GCC_GPLL9_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001c028)
#define HWIO_GCC_GPLL9_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001c028)
#define HWIO_GCC_GPLL9_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001c028)
#define HWIO_GCC_GPLL9_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001c02c)
#define HWIO_GCC_GPLL9_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001c02c)
#define HWIO_GCC_GPLL9_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001c02c)
#define HWIO_GCC_GPLL9_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001c030)
#define HWIO_GCC_GPLL9_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001c030)
#define HWIO_GCC_GPLL9_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001c030)
#define HWIO_GCC_GPLL9_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0001c034)
#define HWIO_GCC_GPLL9_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0001c034)
#define HWIO_GCC_GPLL9_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0001c034)
#define HWIO_GCC_GPLL9_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001c038)
#define HWIO_GCC_GPLL9_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001c038)
#define HWIO_GCC_GPLL9_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001c038)
#define HWIO_GCC_GPLL9_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001c03c)
#define HWIO_GCC_GPLL9_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001c03c)
#define HWIO_GCC_GPLL9_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001c03c)
#define HWIO_GCC_GPLL9_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001c040)
#define HWIO_GCC_GPLL9_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001c040)
#define HWIO_GCC_GPLL9_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001c040)
#define HWIO_GCC_GPLL9_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001c044)
#define HWIO_GCC_GPLL9_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001c044)
#define HWIO_GCC_GPLL9_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001c044)
#define HWIO_GCC_GPLL9_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001c048)
#define HWIO_GCC_GPLL9_SSC_DELTA_ALPHA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001c048)
#define HWIO_GCC_GPLL9_SSC_DELTA_ALPHA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001c048)
#define HWIO_GCC_GPLL9_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001c04c)
#define HWIO_GCC_GPLL9_SSC_UPDATE_RATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001c04c)
#define HWIO_GCC_GPLL9_SSC_UPDATE_RATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001c04c)
#define HWIO_GCC_GPLL9_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001c050)
#define HWIO_GCC_GPLL9_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001c050)
#define HWIO_GCC_GPLL9_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001c050)
#define HWIO_GCC_GPLL10_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001d000)
#define HWIO_GCC_GPLL10_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0001d000)
#define HWIO_GCC_GPLL10_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0001d000)
#define HWIO_GCC_GPLL10_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001d004)
#define HWIO_GCC_GPLL10_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001d004)
#define HWIO_GCC_GPLL10_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001d004)
#define HWIO_GCC_GPLL10_CAL_L_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001d008)
#define HWIO_GCC_GPLL10_CAL_L_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001d008)
#define HWIO_GCC_GPLL10_CAL_L_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001d008)
#define HWIO_GCC_GPLL10_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001d00c)
#define HWIO_GCC_GPLL10_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001d00c)
#define HWIO_GCC_GPLL10_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001d00c)
#define HWIO_GCC_GPLL10_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001d010)
#define HWIO_GCC_GPLL10_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001d010)
#define HWIO_GCC_GPLL10_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001d010)
#define HWIO_GCC_GPLL10_USER_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0001d014)
#define HWIO_GCC_GPLL10_USER_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0001d014)
#define HWIO_GCC_GPLL10_USER_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0001d014)
#define HWIO_GCC_GPLL10_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001d018)
#define HWIO_GCC_GPLL10_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001d018)
#define HWIO_GCC_GPLL10_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001d018)
#define HWIO_GCC_GPLL10_CONFIG_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001d01c)
#define HWIO_GCC_GPLL10_CONFIG_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001d01c)
#define HWIO_GCC_GPLL10_CONFIG_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001d01c)
#define HWIO_GCC_GPLL10_CONFIG_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0001d020)
#define HWIO_GCC_GPLL10_CONFIG_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0001d020)
#define HWIO_GCC_GPLL10_CONFIG_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0001d020)
#define HWIO_GCC_GPLL10_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001d024)
#define HWIO_GCC_GPLL10_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001d024)
#define HWIO_GCC_GPLL10_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001d024)
#define HWIO_GCC_GPLL10_TEST_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0001d028)
#define HWIO_GCC_GPLL10_TEST_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0001d028)
#define HWIO_GCC_GPLL10_TEST_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0001d028)
#define HWIO_GCC_GPLL10_TEST_CTL_U1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0001d02c)
#define HWIO_GCC_GPLL10_TEST_CTL_U1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0001d02c)
#define HWIO_GCC_GPLL10_TEST_CTL_U1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0001d02c)
#define HWIO_GCC_GPLL10_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001d030)
#define HWIO_GCC_GPLL10_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0001d030)
#define HWIO_GCC_GPLL10_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0001d030)
#define HWIO_GCC_GPLL10_FREQ_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0001d034)
#define HWIO_GCC_GPLL10_FREQ_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0001d034)
#define HWIO_GCC_GPLL10_FREQ_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0001d034)
#define HWIO_GCC_GPLL10_OPMODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001d038)
#define HWIO_GCC_GPLL10_OPMODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0001d038)
#define HWIO_GCC_GPLL10_OPMODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0001d038)
#define HWIO_GCC_GPLL10_STATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001d03c)
#define HWIO_GCC_GPLL10_STATE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001d03c)
#define HWIO_GCC_GPLL10_STATE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001d03c)
#define HWIO_GCC_GPLL10_ALPHA_VAL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001d040)
#define HWIO_GCC_GPLL10_ALPHA_VAL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001d040)
#define HWIO_GCC_GPLL10_ALPHA_VAL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001d040)
#define HWIO_GCC_GPLL10_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001d044)
#define HWIO_GCC_GPLL10_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001d044)
#define HWIO_GCC_GPLL10_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001d044)
#define HWIO_GCC_GPLL10_SSC_DELTA_ALPHA_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0001d048)
#define HWIO_GCC_GPLL10_SSC_DELTA_ALPHA_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001d048)
#define HWIO_GCC_GPLL10_SSC_DELTA_ALPHA_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001d048)
#define HWIO_GCC_GPLL10_SSC_UPDATE_RATE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0001d04c)
#define HWIO_GCC_GPLL10_SSC_UPDATE_RATE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001d04c)
#define HWIO_GCC_GPLL10_SSC_UPDATE_RATE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001d04c)
#define HWIO_GCC_GPLL10_SSC_NUM_STEPS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0001d050)
#define HWIO_GCC_GPLL10_SSC_NUM_STEPS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0001d050)
#define HWIO_GCC_GPLL10_SSC_NUM_STEPS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0001d050)
#define HWIO_GCC_SYSTEM_NOC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00004000)
#define HWIO_GCC_SYSTEM_NOC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00004000)
#define HWIO_GCC_SYSTEM_NOC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00004000)
#define HWIO_GCC_SYS_NOC_GC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00004004)
#define HWIO_GCC_SYS_NOC_GC_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00004004)
#define HWIO_GCC_SYS_NOC_GC_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00004004)
#define HWIO_GCC_RPMH_SYS_NOC_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000401c)
#define HWIO_GCC_RPMH_SYS_NOC_CMD_DFSR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000401c)
#define HWIO_GCC_RPMH_SYS_NOC_CMD_DFSR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000401c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004024)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004024)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004024)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004028)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004028)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004028)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000402c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000402c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000402c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004030)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004030)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004030)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004034)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004034)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004034)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004038)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004038)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004038)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000403c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000403c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000403c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004040)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004040)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004040)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004044)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004044)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004044)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004048)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004048)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004048)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF10_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000404c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF10_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000404c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF10_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000404c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF11_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004050)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF11_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004050)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF11_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004050)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF12_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004054)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF12_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004054)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF12_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004054)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF13_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004058)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF13_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004058)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF13_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004058)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF14_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000405c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF14_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000405c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF14_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000405c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF15_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004060)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF15_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004060)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_GC_AXI_PERF15_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004060)
#define HWIO_GCC_SYS_NOC_GC_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00004008)
#define HWIO_GCC_SYS_NOC_GC_AXI_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004008)
#define HWIO_GCC_SYS_NOC_GC_AXI_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004008)
#define HWIO_GCC_SYS_NOC_GC_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0000400c)
#define HWIO_GCC_SYS_NOC_GC_AXI_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000400c)
#define HWIO_GCC_SYS_NOC_GC_AXI_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000400c)
#define HWIO_GCC_SYS_NOC_GC_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00004134)
#define HWIO_GCC_SYS_NOC_GC_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004134)
#define HWIO_GCC_SYS_NOC_GC_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004134)
#define HWIO_GCC_SYS_NOC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00004138)
#define HWIO_GCC_SYS_NOC_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00004138)
#define HWIO_GCC_SYS_NOC_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00004138)
#define HWIO_GCC_SYS_NOC_SOUTH_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0000413c)
#define HWIO_GCC_SYS_NOC_SOUTH_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000413c)
#define HWIO_GCC_SYS_NOC_SOUTH_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000413c)
#define HWIO_GCC_SYS_NOC_NORTH_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00004140)
#define HWIO_GCC_SYS_NOC_NORTH_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004140)
#define HWIO_GCC_SYS_NOC_NORTH_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004140)
#define HWIO_GCC_SYS_NOC_WEST_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00004144)
#define HWIO_GCC_SYS_NOC_WEST_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00004144)
#define HWIO_GCC_SYS_NOC_WEST_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00004144)
#define HWIO_GCC_SYS_NOC_QDSS_STM_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00004148)
#define HWIO_GCC_SYS_NOC_QDSS_STM_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004148)
#define HWIO_GCC_SYS_NOC_QDSS_STM_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004148)
#define HWIO_GCC_SYS_NOC_CPUSS_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0004819c)
#define HWIO_GCC_SYS_NOC_CPUSS_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004819c)
#define HWIO_GCC_SYS_NOC_CPUSS_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004819c)
#define HWIO_GCC_SYS_NOC_AHB_CFG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0000414c)
#define HWIO_GCC_SYS_NOC_AHB_CFG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0000414c)
#define HWIO_GCC_SYS_NOC_AHB_CFG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0000414c)
#define HWIO_GCC_SYS_NOC_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00004150)
#define HWIO_GCC_SYS_NOC_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00004150)
#define HWIO_GCC_SYS_NOC_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00004150)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF0_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004170)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF0_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004170)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF0_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004170)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF1_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004174)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF1_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004174)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF1_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004174)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF2_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004178)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF2_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004178)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF2_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004178)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF3_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000417c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF3_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000417c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF3_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000417c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF4_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004180)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF4_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004180)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF4_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004180)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF5_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004184)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF5_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004184)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF5_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004184)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF6_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004188)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF6_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004188)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF6_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004188)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF7_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000418c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF7_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000418c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF7_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000418c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF8_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004190)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF8_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004190)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF8_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004190)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF9_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004194)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF9_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004194)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF9_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004194)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004198)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004198)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004198)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000419c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000419c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000419c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000041a0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000041a0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000041a0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000041a4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000041a4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000041a4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000041a8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000041a8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000041a8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000041ac)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000041ac)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000041ac)
#define HWIO_GCC_SYS_NOC_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00004154)
#define HWIO_GCC_SYS_NOC_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00004154)
#define HWIO_GCC_SYS_NOC_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00004154)
#define HWIO_GCC_SYS_NOC_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00004158)
#define HWIO_GCC_SYS_NOC_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00004158)
#define HWIO_GCC_SYS_NOC_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00004158)
#define HWIO_GCC_SYS_NOC_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00004280)
#define HWIO_GCC_SYS_NOC_DCD_CDIV_DCDR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00004280)
#define HWIO_GCC_SYS_NOC_DCD_CDIV_DCDR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00004280)
#define HWIO_GCC_SYS_NOC_MONAQ_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00004284)
#define HWIO_GCC_SYS_NOC_MONAQ_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00004284)
#define HWIO_GCC_SYS_NOC_MONAQ_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00004284)
#define HWIO_GCC_SYS_NOC_WEST_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00004288)
#define HWIO_GCC_SYS_NOC_WEST_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004288)
#define HWIO_GCC_SYS_NOC_WEST_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004288)
#define HWIO_GCC_SYS_NOC_SOUTH_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000428c)
#define HWIO_GCC_SYS_NOC_SOUTH_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000428c)
#define HWIO_GCC_SYS_NOC_SOUTH_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000428c)
#define HWIO_GCC_SYS_NOC_NORTH_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004290)
#define HWIO_GCC_SYS_NOC_NORTH_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004290)
#define HWIO_GCC_SYS_NOC_NORTH_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004290)
#define HWIO_GCC_SYS_NOC_MONAQ_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004294)
#define HWIO_GCC_SYS_NOC_MONAQ_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004294)
#define HWIO_GCC_SYS_NOC_MONAQ_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004294)
#define HWIO_GCC_SNOC_QOSGEN_EXTREF_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00004298)
#define HWIO_GCC_SNOC_QOSGEN_EXTREF_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004298)
#define HWIO_GCC_SNOC_QOSGEN_EXTREF_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004298)
#define HWIO_GCC_SYS_NOC_SF_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000429c)
#define HWIO_GCC_SYS_NOC_SF_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000429c)
#define HWIO_GCC_SYS_NOC_SF_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000429c)
#define HWIO_GCC_SYS_NOC_SF_WEST_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000042a0)
#define HWIO_GCC_SYS_NOC_SF_WEST_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042a0)
#define HWIO_GCC_SYS_NOC_SF_WEST_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042a0)
#define HWIO_GCC_SYS_NOC_SF_NORTH_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x000042a4)
#define HWIO_GCC_SYS_NOC_SF_NORTH_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042a4)
#define HWIO_GCC_SYS_NOC_SF_NORTH_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042a4)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x000042a8)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042a8)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042a8)
#define HWIO_GCC_SYS_NOC_MONAQ_SF_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x000042ac)
#define HWIO_GCC_SYS_NOC_MONAQ_SF_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042ac)
#define HWIO_GCC_SYS_NOC_MONAQ_SF_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042ac)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042cc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042cc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042cc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042d0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042d0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042d0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042d4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042d4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042d4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042d8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042d8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042d8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042dc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042dc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042dc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042e0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042e0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042e0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042e4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042e4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042e4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042e8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042e8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042e8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042ec)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042ec)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042ec)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000042f0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042f0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042f0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF10_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x000042f4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF10_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042f4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF10_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042f4)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF11_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x000042f8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF11_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042f8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF11_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042f8)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF12_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x000042fc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF12_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042fc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF12_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042fc)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF13_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004300)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF13_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004300)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF13_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004300)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF14_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004304)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF14_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004304)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF14_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004304)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF15_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004308)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF15_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004308)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_SF_AXI_PERF15_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004308)
#define HWIO_GCC_SYS_NOC_SF_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000042b0)
#define HWIO_GCC_SYS_NOC_SF_AXI_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042b0)
#define HWIO_GCC_SYS_NOC_SF_AXI_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042b0)
#define HWIO_GCC_SYS_NOC_SF_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000042b4)
#define HWIO_GCC_SYS_NOC_SF_AXI_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000042b4)
#define HWIO_GCC_SYS_NOC_SF_AXI_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000042b4)
#define HWIO_GCC_SYS_NOC_SF_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000043dc)
#define HWIO_GCC_SYS_NOC_SF_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000043dc)
#define HWIO_GCC_SYS_NOC_SF_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000043dc)
#define HWIO_GCC_SYS_NOC_MONAQ_SF_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000043e0)
#define HWIO_GCC_SYS_NOC_MONAQ_SF_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000043e0)
#define HWIO_GCC_SYS_NOC_MONAQ_SF_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000043e0)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004400)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004400)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004400)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004404)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004404)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004404)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004408)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004408)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004408)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000440c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000440c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000440c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004410)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004410)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004410)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004414)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004414)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004414)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004418)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004418)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004418)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000441c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000441c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000441c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004420)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004420)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004420)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004424)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004424)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004424)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004428)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004428)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004428)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000442c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000442c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000442c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004430)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004430)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004430)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004434)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004434)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004434)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00004438)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004438)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004438)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000443c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000443c)
#define HWIO_GCC_RPMH_SYS_NOC_SYS_NOC_MONAQ_AXI_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000443c)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x000043e4)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000043e4)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000043e4)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x000043e8)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000043e8)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000043e8)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_DCD_CDIV_DCDR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00004510)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_DCD_CDIV_DCDR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00004510)
#define HWIO_GCC_SYS_NOC_MONAQ_AXI_DCD_CDIV_DCDR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00004510)
#define HWIO_GCC_CONFIG_NOC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00005000)
#define HWIO_GCC_CONFIG_NOC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00005000)
#define HWIO_GCC_CONFIG_NOC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00005000)
#define HWIO_GCC_CNOC_PERIPH_SOUTH_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005004)
#define HWIO_GCC_CNOC_PERIPH_SOUTH_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005004)
#define HWIO_GCC_CNOC_PERIPH_SOUTH_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005004)
#define HWIO_GCC_CNOC_PERIPH_NORTH_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005008)
#define HWIO_GCC_CNOC_PERIPH_NORTH_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005008)
#define HWIO_GCC_CNOC_PERIPH_NORTH_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005008)
#define HWIO_GCC_CNOC_PERIPH_EAST_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000500c)
#define HWIO_GCC_CNOC_PERIPH_EAST_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000500c)
#define HWIO_GCC_CNOC_PERIPH_EAST_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000500c)
#define HWIO_GCC_CFG_NOC_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00005010)
#define HWIO_GCC_CFG_NOC_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00005010)
#define HWIO_GCC_CFG_NOC_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00005010)
#define HWIO_GCC_CFG_NOC_WEST_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00005014)
#define HWIO_GCC_CFG_NOC_WEST_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00005014)
#define HWIO_GCC_CFG_NOC_WEST_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00005014)
#define HWIO_GCC_CFG_NOC_NORTH_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005018)
#define HWIO_GCC_CFG_NOC_NORTH_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005018)
#define HWIO_GCC_CFG_NOC_NORTH_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005018)
#define HWIO_GCC_CFG_NOC_EAST_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000501c)
#define HWIO_GCC_CFG_NOC_EAST_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000501c)
#define HWIO_GCC_CFG_NOC_EAST_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000501c)
#define HWIO_GCC_CFG_NOC_SOUTH_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005020)
#define HWIO_GCC_CFG_NOC_SOUTH_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005020)
#define HWIO_GCC_CFG_NOC_SOUTH_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005020)
#define HWIO_GCC_CFG_NOC_MONAQ_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005024)
#define HWIO_GCC_CFG_NOC_MONAQ_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005024)
#define HWIO_GCC_CFG_NOC_MONAQ_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005024)
#define HWIO_GCC_CFG_NOC_MMNOC_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005028)
#define HWIO_GCC_CFG_NOC_MMNOC_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005028)
#define HWIO_GCC_CFG_NOC_MMNOC_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005028)
#define HWIO_GCC_CFG_NOC_COMPUTE_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0000502c)
#define HWIO_GCC_CFG_NOC_COMPUTE_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000502c)
#define HWIO_GCC_CFG_NOC_COMPUTE_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000502c)
#define HWIO_GCC_CFG_NOC_USB3_PRIM_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000f078)
#define HWIO_GCC_CFG_NOC_USB3_PRIM_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f078)
#define HWIO_GCC_CFG_NOC_USB3_PRIM_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f078)
#define HWIO_GCC_CFG_NOC_USB3_SEC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00010078)
#define HWIO_GCC_CFG_NOC_USB3_SEC_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010078)
#define HWIO_GCC_CFG_NOC_USB3_SEC_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010078)
#define HWIO_GCC_NOC_WEST_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00005030)
#define HWIO_GCC_NOC_WEST_DCD_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00005030)
#define HWIO_GCC_NOC_WEST_DCD_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00005030)
#define HWIO_GCC_NOC_NORTH_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00005034)
#define HWIO_GCC_NOC_NORTH_DCD_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00005034)
#define HWIO_GCC_NOC_NORTH_DCD_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00005034)
#define HWIO_GCC_NOC_SOUTH_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00005038)
#define HWIO_GCC_NOC_SOUTH_DCD_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00005038)
#define HWIO_GCC_NOC_SOUTH_DCD_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00005038)
#define HWIO_GCC_NOC_EAST_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0000503c)
#define HWIO_GCC_NOC_EAST_DCD_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0000503c)
#define HWIO_GCC_NOC_EAST_DCD_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0000503c)
#define HWIO_GCC_NOC_CENTER_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005040)
#define HWIO_GCC_NOC_CENTER_DCD_XO_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005040)
#define HWIO_GCC_NOC_CENTER_DCD_XO_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005040)
#define HWIO_GCC_NOC_MONAQ_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00005044)
#define HWIO_GCC_NOC_MONAQ_DCD_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00005044)
#define HWIO_GCC_NOC_MONAQ_DCD_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00005044)
#define HWIO_GCC_CFG_NOC_AH2PHY_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00005048)
#define HWIO_GCC_CFG_NOC_AH2PHY_XO_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005048)
#define HWIO_GCC_CFG_NOC_AH2PHY_XO_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005048)
#define HWIO_GCC_NOC_LPASS_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000504c)
#define HWIO_GCC_NOC_LPASS_DCD_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000504c)
#define HWIO_GCC_NOC_LPASS_DCD_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000504c)
#define HWIO_GCC_NOC_COMPUTE_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00005050)
#define HWIO_GCC_NOC_COMPUTE_DCD_XO_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005050)
#define HWIO_GCC_NOC_COMPUTE_DCD_XO_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005050)
#define HWIO_GCC_NOC_MMNOC_CNOC_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00005054)
#define HWIO_GCC_NOC_MMNOC_CNOC_DCD_XO_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005054)
#define HWIO_GCC_NOC_MMNOC_CNOC_DCD_XO_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005054)
#define HWIO_GCC_RPMH_CNOC_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000506c)
#define HWIO_GCC_RPMH_CNOC_CMD_DFSR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000506c)
#define HWIO_GCC_RPMH_CNOC_CMD_DFSR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000506c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF0_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005074)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF0_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005074)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF0_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005074)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF1_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005078)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF1_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005078)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF1_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005078)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF2_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000507c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF2_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000507c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF2_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000507c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF3_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005080)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF3_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005080)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF3_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005080)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF4_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005084)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF4_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005084)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF4_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005084)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF5_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005088)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF5_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005088)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF5_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005088)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF6_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000508c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF6_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000508c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF6_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000508c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF7_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005090)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF7_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005090)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF7_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005090)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF8_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005094)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF8_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005094)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF8_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005094)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF9_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00005098)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF9_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00005098)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF9_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00005098)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000509c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000509c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000509c)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000050a0)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000050a0)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000050a0)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000050a4)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000050a4)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000050a4)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000050a8)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000050a8)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000050a8)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000050ac)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000050ac)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000050ac)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000050b0)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000050b0)
#define HWIO_GCC_RPMH_CNOC_CONFIG_NOC_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000050b0)
#define HWIO_GCC_CONFIG_NOC_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00005058)
#define HWIO_GCC_CONFIG_NOC_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00005058)
#define HWIO_GCC_CONFIG_NOC_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00005058)
#define HWIO_GCC_CONFIG_NOC_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000505c)
#define HWIO_GCC_CONFIG_NOC_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000505c)
#define HWIO_GCC_CONFIG_NOC_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000505c)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051a0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051a0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051a0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051a4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051a4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051a4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051a8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051a8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051a8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051ac)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051ac)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051ac)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051b0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051b0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051b0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051b4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051b4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051b4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051b8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051b8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051b8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051bc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051bc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051bc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051c0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051c0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051c0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051c4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051c4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051c4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051c8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051c8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051c8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051cc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051cc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051cc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051d0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051d0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051d0)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051d4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051d4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051d4)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051d8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051d8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051d8)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000051dc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000051dc)
#define HWIO_GCC_RPMH_CNOC_CNOC_PERIPH_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000051dc)
#define HWIO_GCC_CNOC_PERIPH_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00005184)
#define HWIO_GCC_CNOC_PERIPH_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00005184)
#define HWIO_GCC_CNOC_PERIPH_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00005184)
#define HWIO_GCC_CNOC_PERIPH_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00005188)
#define HWIO_GCC_CNOC_PERIPH_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00005188)
#define HWIO_GCC_CNOC_PERIPH_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00005188)
#define HWIO_GCC_CONFIG_NOC_CENTER_DCD_CDIV_DCDR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x000052b0)
#define HWIO_GCC_CONFIG_NOC_CENTER_DCD_CDIV_DCDR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052b0)
#define HWIO_GCC_CONFIG_NOC_CENTER_DCD_CDIV_DCDR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052b0)
#define HWIO_GCC_CONFIG_NOC_WEST_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000052b4)
#define HWIO_GCC_CONFIG_NOC_WEST_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052b4)
#define HWIO_GCC_CONFIG_NOC_WEST_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052b4)
#define HWIO_GCC_CONFIG_NOC_EAST_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000052b8)
#define HWIO_GCC_CONFIG_NOC_EAST_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052b8)
#define HWIO_GCC_CONFIG_NOC_EAST_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052b8)
#define HWIO_GCC_CONFIG_NOC_NORTH_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000052bc)
#define HWIO_GCC_CONFIG_NOC_NORTH_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052bc)
#define HWIO_GCC_CONFIG_NOC_NORTH_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052bc)
#define HWIO_GCC_CONFIG_NOC_SOUTH_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000052c0)
#define HWIO_GCC_CONFIG_NOC_SOUTH_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052c0)
#define HWIO_GCC_CONFIG_NOC_SOUTH_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052c0)
#define HWIO_GCC_CONFIG_NOC_MONAQ_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000052c4)
#define HWIO_GCC_CONFIG_NOC_MONAQ_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052c4)
#define HWIO_GCC_CONFIG_NOC_MONAQ_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052c4)
#define HWIO_GCC_CONFIG_NOC_MMNOC_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000052c8)
#define HWIO_GCC_CONFIG_NOC_MMNOC_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052c8)
#define HWIO_GCC_CONFIG_NOC_MMNOC_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052c8)
#define HWIO_GCC_CONFIG_NOC_COMPUTE_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000052cc)
#define HWIO_GCC_CONFIG_NOC_COMPUTE_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000052cc)
#define HWIO_GCC_CONFIG_NOC_COMPUTE_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000052cc)
#define HWIO_GCC_TIC_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0000e000)
#define HWIO_GCC_TIC_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0000e000)
#define HWIO_GCC_TIC_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0000e000)
#define HWIO_GCC_IMEM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00008000)
#define HWIO_GCC_IMEM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00008000)
#define HWIO_GCC_IMEM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00008000)
#define HWIO_GCC_IMEM_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00008004)
#define HWIO_GCC_IMEM_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00008004)
#define HWIO_GCC_IMEM_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00008004)
#define HWIO_GCC_IMEM_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00008008)
#define HWIO_GCC_IMEM_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00008008)
#define HWIO_GCC_IMEM_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00008008)
#define HWIO_GCC_MMU_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00083000)
#define HWIO_GCC_MMU_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083000)
#define HWIO_GCC_MMU_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083000)
#define HWIO_GCC_SYS_NOC_SF_TCU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00083004)
#define HWIO_GCC_SYS_NOC_SF_TCU_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00083004)
#define HWIO_GCC_SYS_NOC_SF_TCU_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00083004)
#define HWIO_GCC_MMU_TCU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00083008)
#define HWIO_GCC_MMU_TCU_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00083008)
#define HWIO_GCC_MMU_TCU_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00083008)
#define HWIO_GCC_MMU_TCU_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008300c)
#define HWIO_GCC_MMU_TCU_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0008300c)
#define HWIO_GCC_MMU_TCU_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0008300c)
#define HWIO_GCC_RPMH_SHUB_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00083024)
#define HWIO_GCC_RPMH_SHUB_CMD_DFSR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00083024)
#define HWIO_GCC_RPMH_SHUB_CMD_DFSR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00083024)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008302c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008302c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008302c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083030)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083030)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083030)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083034)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083034)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083034)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083038)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083038)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083038)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008303c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008303c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008303c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083040)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083040)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083040)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083044)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083044)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083044)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083048)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083048)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083048)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008304c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008304c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008304c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083050)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083050)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083050)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083054)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083054)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083054)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083058)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083058)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083058)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008305c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008305c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008305c)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083060)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083060)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083060)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083064)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083064)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083064)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00083068)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00083068)
#define HWIO_GCC_RPMH_SHUB_MMU_TCU_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00083068)
#define HWIO_GCC_MMU_TCU_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00083010)
#define HWIO_GCC_MMU_TCU_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00083010)
#define HWIO_GCC_MMU_TCU_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00083010)
#define HWIO_GCC_MMU_TCU_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00083014)
#define HWIO_GCC_MMU_TCU_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00083014)
#define HWIO_GCC_MMU_TCU_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00083014)
#define HWIO_GCC_MMU_TCU_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0008313c)
#define HWIO_GCC_MMU_TCU_DCD_CDIV_DCDR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0008313c)
#define HWIO_GCC_MMU_TCU_DCD_CDIV_DCDR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0008313c)
#define HWIO_GCC_ANOC_TBU_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00090000)
#define HWIO_GCC_ANOC_TBU_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00090000)
#define HWIO_GCC_ANOC_TBU_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00090000)
#define HWIO_GCC_ANOC_TBU_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00090004)
#define HWIO_GCC_ANOC_TBU_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00090004)
#define HWIO_GCC_ANOC_TBU_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00090004)
#define HWIO_GCC_ANOC_TBU_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00090008)
#define HWIO_GCC_ANOC_TBU_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00090008)
#define HWIO_GCC_ANOC_TBU_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00090008)
#define HWIO_GCC_ANOC_TBU_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0009000c)
#define HWIO_GCC_ANOC_TBU_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0009000c)
#define HWIO_GCC_ANOC_TBU_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0009000c)
#define HWIO_GCC_AGGRE_NOC_AUDIO_TBU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00090010)
#define HWIO_GCC_AGGRE_NOC_AUDIO_TBU_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00090010)
#define HWIO_GCC_AGGRE_NOC_AUDIO_TBU_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00090010)
#define HWIO_GCC_AGGRE_NOC_AUDIO_TBU_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00090014)
#define HWIO_GCC_AGGRE_NOC_AUDIO_TBU_SREGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00090014)
#define HWIO_GCC_AGGRE_NOC_AUDIO_TBU_SREGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00090014)
#define HWIO_GCC_AGGRE_NOC_PCIE_TBU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00090018)
#define HWIO_GCC_AGGRE_NOC_PCIE_TBU_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00090018)
#define HWIO_GCC_AGGRE_NOC_PCIE_TBU_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00090018)
#define HWIO_GCC_AGGRE_NOC_PCIE_TBU_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009001c)
#define HWIO_GCC_AGGRE_NOC_PCIE_TBU_SREGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009001c)
#define HWIO_GCC_AGGRE_NOC_PCIE_TBU_SREGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009001c)
#define HWIO_GCC_AGGRE_NOC_TBU1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00090020)
#define HWIO_GCC_AGGRE_NOC_TBU1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00090020)
#define HWIO_GCC_AGGRE_NOC_TBU1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00090020)
#define HWIO_GCC_AGGRE_NOC_TBU1_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00090024)
#define HWIO_GCC_AGGRE_NOC_TBU1_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00090024)
#define HWIO_GCC_AGGRE_NOC_TBU1_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00090024)
#define HWIO_GCC_AGGRE_NOC_TBU2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00090028)
#define HWIO_GCC_AGGRE_NOC_TBU2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00090028)
#define HWIO_GCC_AGGRE_NOC_TBU2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00090028)
#define HWIO_GCC_AGGRE_NOC_TBU2_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0009002c)
#define HWIO_GCC_AGGRE_NOC_TBU2_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0009002c)
#define HWIO_GCC_AGGRE_NOC_TBU2_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0009002c)
#define HWIO_GCC_MMNOC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00009000)
#define HWIO_GCC_MMNOC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00009000)
#define HWIO_GCC_MMNOC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00009000)
#define HWIO_GCC_MMNOC_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00009004)
#define HWIO_GCC_MMNOC_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00009004)
#define HWIO_GCC_MMNOC_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00009004)
#define HWIO_GCC_MMNOC_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00009008)
#define HWIO_GCC_MMNOC_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00009008)
#define HWIO_GCC_MMNOC_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00009008)
#define HWIO_GCC_MMNOC_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0000900c)
#define HWIO_GCC_MMNOC_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0000900c)
#define HWIO_GCC_MMNOC_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0000900c)
#define HWIO_GCC_MMNOC_TBU_SF_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00009010)
#define HWIO_GCC_MMNOC_TBU_SF_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00009010)
#define HWIO_GCC_MMNOC_TBU_SF_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00009010)
#define HWIO_GCC_MMNOC_TBU_SF_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00009014)
#define HWIO_GCC_MMNOC_TBU_SF_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00009014)
#define HWIO_GCC_MMNOC_TBU_SF_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00009014)
#define HWIO_GCC_MMNOC_TBU_HF0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00009018)
#define HWIO_GCC_MMNOC_TBU_HF0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00009018)
#define HWIO_GCC_MMNOC_TBU_HF0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00009018)
#define HWIO_GCC_MMNOC_TBU_HF0_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000901c)
#define HWIO_GCC_MMNOC_TBU_HF0_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000901c)
#define HWIO_GCC_MMNOC_TBU_HF0_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000901c)
#define HWIO_GCC_MMNOC_TBU_HF1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00009020)
#define HWIO_GCC_MMNOC_TBU_HF1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00009020)
#define HWIO_GCC_MMNOC_TBU_HF1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00009020)
#define HWIO_GCC_MMNOC_TBU_HF1_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00009024)
#define HWIO_GCC_MMNOC_TBU_HF1_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00009024)
#define HWIO_GCC_MMNOC_TBU_HF1_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00009024)
#define HWIO_GCC_MMNOC_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00009028)
#define HWIO_GCC_MMNOC_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00009028)
#define HWIO_GCC_MMNOC_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00009028)
#define HWIO_GCC_MMNOC_AHB_CFG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000902c)
#define HWIO_GCC_MMNOC_AHB_CFG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000902c)
#define HWIO_GCC_MMNOC_AHB_CFG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000902c)
#define HWIO_GCC_NOC_MMNOC_DCD_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00009030)
#define HWIO_GCC_NOC_MMNOC_DCD_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00009030)
#define HWIO_GCC_NOC_MMNOC_DCD_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00009030)
#define HWIO_GCC_MMNOC_HF_QX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00009034)
#define HWIO_GCC_MMNOC_HF_QX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00009034)
#define HWIO_GCC_MMNOC_HF_QX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00009034)
#define HWIO_GCC_RPMH_MMNOC_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000904c)
#define HWIO_GCC_RPMH_MMNOC_CMD_DFSR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000904c)
#define HWIO_GCC_RPMH_MMNOC_CMD_DFSR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000904c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009054)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009054)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009054)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009058)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009058)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009058)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000905c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000905c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000905c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009060)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009060)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009060)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009064)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009064)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009064)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009068)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009068)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009068)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000906c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000906c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000906c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009070)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009070)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009070)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009074)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009074)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009074)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009078)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009078)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009078)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000907c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000907c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000907c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009080)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009080)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009080)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009084)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009084)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009084)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009088)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009088)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009088)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000908c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000908c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000908c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009090)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009090)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_HF_QX_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009090)
#define HWIO_GCC_MMNOC_HF_QX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00009038)
#define HWIO_GCC_MMNOC_HF_QX_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00009038)
#define HWIO_GCC_MMNOC_HF_QX_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00009038)
#define HWIO_GCC_MMNOC_HF_QX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0000903c)
#define HWIO_GCC_MMNOC_HF_QX_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0000903c)
#define HWIO_GCC_MMNOC_HF_QX_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0000903c)
#define HWIO_GCC_MMNOC_HF_QX_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00009164)
#define HWIO_GCC_MMNOC_HF_QX_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009164)
#define HWIO_GCC_MMNOC_HF_QX_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009164)
#define HWIO_GCC_MMNOC_SF_QX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00009168)
#define HWIO_GCC_MMNOC_SF_QX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00009168)
#define HWIO_GCC_MMNOC_SF_QX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00009168)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009188)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009188)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009188)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000918c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000918c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000918c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009190)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009190)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009190)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009194)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009194)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009194)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009198)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009198)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009198)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000919c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000919c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000919c)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091a0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091a0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091a0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091a4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091a4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091a4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091a8)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091a8)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091a8)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091ac)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091ac)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091ac)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091b0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091b0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091b0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091b4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091b4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091b4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091b8)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091b8)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091b8)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091bc)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091bc)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091bc)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091c0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091c0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091c0)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000091c4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000091c4)
#define HWIO_GCC_RPMH_MMNOC_MMNOC_SF_QX_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000091c4)
#define HWIO_GCC_MMNOC_SF_QX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0000916c)
#define HWIO_GCC_MMNOC_SF_QX_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0000916c)
#define HWIO_GCC_MMNOC_SF_QX_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0000916c)
#define HWIO_GCC_MMNOC_SF_QX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00009170)
#define HWIO_GCC_MMNOC_SF_QX_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00009170)
#define HWIO_GCC_MMNOC_SF_QX_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00009170)
#define HWIO_GCC_MMNOC_SF_QX_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00009298)
#define HWIO_GCC_MMNOC_SF_QX_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009298)
#define HWIO_GCC_MMNOC_SF_QX_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009298)
#define HWIO_GCC_MMNOC_QOSGEN_EXTREF_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0000929c)
#define HWIO_GCC_MMNOC_QOSGEN_EXTREF_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000929c)
#define HWIO_GCC_MMNOC_QOSGEN_EXTREF_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000929c)
#define HWIO_GCC_MMSS_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000b000)
#define HWIO_GCC_MMSS_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000b000)
#define HWIO_GCC_MMSS_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000b000)
#define HWIO_GCC_VIDEO_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000b004)
#define HWIO_GCC_VIDEO_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000b004)
#define HWIO_GCC_VIDEO_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000b004)
#define HWIO_GCC_CAMERA_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0000b008)
#define HWIO_GCC_CAMERA_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0000b008)
#define HWIO_GCC_CAMERA_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0000b008)
#define HWIO_GCC_DISP_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000b00c)
#define HWIO_GCC_DISP_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0000b00c)
#define HWIO_GCC_DISP_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0000b00c)
#define HWIO_GCC_QMIP_VIDEO_CVP_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0000b010)
#define HWIO_GCC_QMIP_VIDEO_CVP_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000b010)
#define HWIO_GCC_QMIP_VIDEO_CVP_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000b010)
#define HWIO_GCC_QMIP_VIDEO_VCODEC_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000b014)
#define HWIO_GCC_QMIP_VIDEO_VCODEC_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000b014)
#define HWIO_GCC_QMIP_VIDEO_VCODEC_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000b014)
#define HWIO_GCC_QMIP_CAMERA_NRT_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0000b018)
#define HWIO_GCC_QMIP_CAMERA_NRT_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000b018)
#define HWIO_GCC_QMIP_CAMERA_NRT_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000b018)
#define HWIO_GCC_QMIP_CAMERA_RT_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0000b01c)
#define HWIO_GCC_QMIP_CAMERA_RT_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000b01c)
#define HWIO_GCC_QMIP_CAMERA_RT_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000b01c)
#define HWIO_GCC_QMIP_DISP_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000b020)
#define HWIO_GCC_QMIP_DISP_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000b020)
#define HWIO_GCC_QMIP_DISP_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000b020)
#define HWIO_GCC_VIDEO_AXI0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0000b024)
#define HWIO_GCC_VIDEO_AXI0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0000b024)
#define HWIO_GCC_VIDEO_AXI0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0000b024)
#define HWIO_GCC_VIDEO_AXI1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0000b028)
#define HWIO_GCC_VIDEO_AXI1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0000b028)
#define HWIO_GCC_VIDEO_AXI1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0000b028)
#define HWIO_GCC_VIDEO_AXIC_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0000b02c)
#define HWIO_GCC_VIDEO_AXIC_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0000b02c)
#define HWIO_GCC_VIDEO_AXIC_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0000b02c)
#define HWIO_GCC_CAMERA_HF_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000b030)
#define HWIO_GCC_CAMERA_HF_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000b030)
#define HWIO_GCC_CAMERA_HF_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000b030)
#define HWIO_GCC_CAMERA_SF_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000b034)
#define HWIO_GCC_CAMERA_SF_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000b034)
#define HWIO_GCC_CAMERA_SF_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000b034)
#define HWIO_GCC_DISP_HF_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0000b038)
#define HWIO_GCC_DISP_HF_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0000b038)
#define HWIO_GCC_DISP_HF_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0000b038)
#define HWIO_GCC_DISP_SF_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0000b03c)
#define HWIO_GCC_DISP_SF_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0000b03c)
#define HWIO_GCC_DISP_SF_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0000b03c)
#define HWIO_GCC_VIDEO_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000b040)
#define HWIO_GCC_VIDEO_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0000b040)
#define HWIO_GCC_VIDEO_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0000b040)
#define HWIO_GCC_CAMERA_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000b044)
#define HWIO_GCC_CAMERA_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000b044)
#define HWIO_GCC_CAMERA_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000b044)
#define HWIO_GCC_DISP_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000b048)
#define HWIO_GCC_DISP_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0000b048)
#define HWIO_GCC_DISP_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0000b048)
#define HWIO_GCC_MMSS_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000b04c)
#define HWIO_GCC_MMSS_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0000b04c)
#define HWIO_GCC_MMSS_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0000b04c)
#define HWIO_GCC_MMSS_QM_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000b050)
#define HWIO_GCC_MMSS_QM_CORE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000b050)
#define HWIO_GCC_MMSS_QM_CORE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000b050)
#define HWIO_GCC_MMSS_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000b054)
#define HWIO_GCC_MMSS_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000b054)
#define HWIO_GCC_MMSS_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000b054)
#define HWIO_GCC_MMSS_QM_CORE_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000b058)
#define HWIO_GCC_MMSS_QM_CORE_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000b058)
#define HWIO_GCC_MMSS_QM_CORE_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000b058)
#define HWIO_GCC_MMSS_QM_CORE_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000b05c)
#define HWIO_GCC_MMSS_QM_CORE_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000b05c)
#define HWIO_GCC_MMSS_QM_CORE_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000b05c)
#define HWIO_GCC_MMSS_QM_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0000b070)
#define HWIO_GCC_MMSS_QM_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0000b070)
#define HWIO_GCC_MMSS_QM_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0000b070)
#define HWIO_GCC_PIMEM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000a000)
#define HWIO_GCC_PIMEM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x0000a000)
#define HWIO_GCC_PIMEM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x0000a000)
#define HWIO_GCC_PIMEM_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000a004)
#define HWIO_GCC_PIMEM_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000a004)
#define HWIO_GCC_PIMEM_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000a004)
#define HWIO_GCC_PIMEM_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000a008)
#define HWIO_GCC_PIMEM_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000a008)
#define HWIO_GCC_PIMEM_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000a008)
#define HWIO_GCC_QDSS_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c000)
#define HWIO_GCC_QDSS_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c000)
#define HWIO_GCC_QDSS_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c000)
#define HWIO_GCC_QDSS_DAP_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000c004)
#define HWIO_GCC_QDSS_DAP_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000c004)
#define HWIO_GCC_QDSS_DAP_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000c004)
#define HWIO_GCC_QDSS_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000c008)
#define HWIO_GCC_QDSS_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000c008)
#define HWIO_GCC_QDSS_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000c008)
#define HWIO_GCC_QDSS_CENTER_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000c00c)
#define HWIO_GCC_QDSS_CENTER_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000c00c)
#define HWIO_GCC_QDSS_CENTER_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000c00c)
#define HWIO_GCC_SOUTH_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c010)
#define HWIO_GCC_SOUTH_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0000c010)
#define HWIO_GCC_SOUTH_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0000c010)
#define HWIO_GCC_EAST_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c014)
#define HWIO_GCC_EAST_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0000c014)
#define HWIO_GCC_EAST_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0000c014)
#define HWIO_GCC_NORTH_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c018)
#define HWIO_GCC_NORTH_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0000c018)
#define HWIO_GCC_NORTH_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0000c018)
#define HWIO_GCC_QDSS_ETR_USB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000c01c)
#define HWIO_GCC_QDSS_ETR_USB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000c01c)
#define HWIO_GCC_QDSS_ETR_USB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000c01c)
#define HWIO_GCC_QDSS_STM_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c020)
#define HWIO_GCC_QDSS_STM_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0000c020)
#define HWIO_GCC_QDSS_STM_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0000c020)
#define HWIO_GCC_QDSS_TRACECLKIN_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0000c024)
#define HWIO_GCC_QDSS_TRACECLKIN_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0000c024)
#define HWIO_GCC_QDSS_TRACECLKIN_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0000c024)
#define HWIO_GCC_QDSS_TSCTR_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0000c028)
#define HWIO_GCC_QDSS_TSCTR_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0000c028)
#define HWIO_GCC_QDSS_TSCTR_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0000c028)
#define HWIO_GCC_QDSS_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000c02c)
#define HWIO_GCC_QDSS_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000c02c)
#define HWIO_GCC_QDSS_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000c02c)
#define HWIO_GCC_QDSS_DAP_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c030)
#define HWIO_GCC_QDSS_DAP_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0000c030)
#define HWIO_GCC_QDSS_DAP_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0000c030)
#define HWIO_GCC_APB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c034)
#define HWIO_GCC_APB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c034)
#define HWIO_GCC_APB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c034)
#define HWIO_GCC_QDSS_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000c038)
#define HWIO_GCC_QDSS_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0000c038)
#define HWIO_GCC_QDSS_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0000c038)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF0_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c058)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF0_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c058)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF0_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c058)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF1_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c05c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF1_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c05c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF1_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c05c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF2_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c060)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF2_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c060)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF2_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c060)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF3_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c064)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF3_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c064)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF3_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c064)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF4_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c068)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF4_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c068)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF4_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c068)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF5_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c06c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF5_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c06c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF5_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c06c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF6_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c070)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF6_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c070)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF6_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c070)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF7_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c074)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF7_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c074)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF7_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c074)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF8_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c078)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF8_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c078)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF8_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c078)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF9_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c07c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF9_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c07c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF9_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c07c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c080)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c080)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c080)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c084)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c084)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c084)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c088)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c088)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c088)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c08c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c08c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c08c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c090)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c090)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c090)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c094)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c094)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_A_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c094)
#define HWIO_GCC_QDSS_ATB_A_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000c03c)
#define HWIO_GCC_QDSS_ATB_A_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000c03c)
#define HWIO_GCC_QDSS_ATB_A_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000c03c)
#define HWIO_GCC_QDSS_ATB_A_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000c040)
#define HWIO_GCC_QDSS_ATB_A_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000c040)
#define HWIO_GCC_QDSS_ATB_A_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000c040)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF0_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c184)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF0_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c184)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF0_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c184)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF1_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c188)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF1_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c188)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF1_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c188)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF2_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c18c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF2_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c18c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF2_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c18c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF3_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c190)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF3_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c190)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF3_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c190)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF4_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c194)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF4_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c194)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF4_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c194)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF5_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c198)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF5_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c198)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF5_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c198)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF6_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c19c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF6_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c19c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF6_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c19c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF7_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1a0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF7_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1a0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF7_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1a0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF8_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1a4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF8_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1a4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF8_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1a4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF9_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1a8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF9_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1a8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF9_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1a8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1ac)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1ac)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1ac)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1b0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1b0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1b0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1b4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1b4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1b4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1b8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1b8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1b8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1bc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1bc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1bc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c1c0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c1c0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_B_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c1c0)
#define HWIO_GCC_QDSS_ATB_B_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000c168)
#define HWIO_GCC_QDSS_ATB_B_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000c168)
#define HWIO_GCC_QDSS_ATB_B_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000c168)
#define HWIO_GCC_QDSS_ATB_B_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000c16c)
#define HWIO_GCC_QDSS_ATB_B_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000c16c)
#define HWIO_GCC_QDSS_ATB_B_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000c16c)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF0_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2b0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF0_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2b0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF0_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2b0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF1_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2b4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF1_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2b4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF1_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2b4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF2_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2b8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF2_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2b8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF2_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2b8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF3_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2bc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF3_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2bc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF3_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2bc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF4_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2c0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF4_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2c0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF4_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2c0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF5_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2c4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF5_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2c4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF5_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2c4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF6_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2c8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF6_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2c8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF6_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2c8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF7_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2cc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF7_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2cc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF7_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2cc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF8_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2d0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF8_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2d0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF8_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2d0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF9_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2d4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF9_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2d4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF9_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2d4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2d8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2d8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2d8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2dc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2dc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2dc)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2e0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2e0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2e0)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2e4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2e4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2e4)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2e8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2e8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2e8)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c2ec)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c2ec)
#define HWIO_GCC_RPMH_SHUB_QDSS_ATB_C_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c2ec)
#define HWIO_GCC_QDSS_ATB_C_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000c294)
#define HWIO_GCC_QDSS_ATB_C_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000c294)
#define HWIO_GCC_QDSS_ATB_C_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000c294)
#define HWIO_GCC_QDSS_ATB_C_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000c298)
#define HWIO_GCC_QDSS_ATB_C_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000c298)
#define HWIO_GCC_QDSS_ATB_C_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000c298)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3dc)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3dc)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3dc)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3e0)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3e0)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3e0)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3e4)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3e4)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3e4)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3e8)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3e8)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3e8)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3ec)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3ec)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3ec)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3f0)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3f0)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3f0)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3f4)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3f4)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3f4)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3f8)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3f8)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3f8)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c3fc)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c3fc)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c3fc)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c400)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c400)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c400)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c404)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c404)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c404)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c408)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c408)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c408)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c40c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c40c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c40c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c410)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c410)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c410)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c414)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c414)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c414)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c418)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c418)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_STM_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c418)
#define HWIO_GCC_QDSS_STM_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000c3c0)
#define HWIO_GCC_QDSS_STM_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000c3c0)
#define HWIO_GCC_QDSS_STM_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000c3c0)
#define HWIO_GCC_QDSS_STM_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000c3c4)
#define HWIO_GCC_QDSS_STM_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000c3c4)
#define HWIO_GCC_QDSS_STM_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000c3c4)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c508)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c508)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c508)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c50c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c50c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c50c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c510)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c510)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c510)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c514)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c514)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c514)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c518)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c518)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c518)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c51c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c51c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c51c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c520)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c520)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c520)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c524)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c524)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c524)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c528)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c528)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c528)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c52c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c52c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c52c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c530)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c530)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c530)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c534)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c534)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c534)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c538)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c538)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c538)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c53c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c53c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c53c)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c540)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c540)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c540)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c544)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c544)
#define HWIO_GCC_RPMH_SHUB_QDSS_TRACECLKIN_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c544)
#define HWIO_GCC_QDSS_TRACECLKIN_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0000c4ec)
#define HWIO_GCC_QDSS_TRACECLKIN_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c4ec)
#define HWIO_GCC_QDSS_TRACECLKIN_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c4ec)
#define HWIO_GCC_QDSS_TRACECLKIN_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0000c4f0)
#define HWIO_GCC_QDSS_TRACECLKIN_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c4f0)
#define HWIO_GCC_QDSS_TRACECLKIN_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c4f0)
#define HWIO_GCC_QDSS_APB_TSCTR_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0000c618)
#define HWIO_GCC_QDSS_APB_TSCTR_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c618)
#define HWIO_GCC_QDSS_APB_TSCTR_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c618)
#define HWIO_GCC_QDSS_APB_TSCTR_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0000c61c)
#define HWIO_GCC_QDSS_APB_TSCTR_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c61c)
#define HWIO_GCC_QDSS_APB_TSCTR_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c61c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c64c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c64c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c64c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c650)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c650)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c650)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c654)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c654)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c654)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c658)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c658)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c658)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c65c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c65c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c65c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c660)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c660)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c660)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c664)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c664)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c664)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c668)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c668)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c668)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c66c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c66c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c66c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c670)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c670)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c670)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c674)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c674)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c674)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c678)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c678)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c678)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c67c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c67c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c67c)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c680)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c680)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c680)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c684)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c684)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c684)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000c688)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000c688)
#define HWIO_GCC_RPMH_SYS_NOC_QDSS_TRIG_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000c688)
#define HWIO_GCC_QDSS_TRIG_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000c630)
#define HWIO_GCC_QDSS_TRIG_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000c630)
#define HWIO_GCC_QDSS_TRIG_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000c630)
#define HWIO_GCC_QDSS_TRIG_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0000c634)
#define HWIO_GCC_QDSS_TRIG_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0000c634)
#define HWIO_GCC_QDSS_TRIG_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0000c634)
#define HWIO_GCC_USB30_PRIM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000f000)
#define HWIO_GCC_USB30_PRIM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000f000)
#define HWIO_GCC_USB30_PRIM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000f000)
#define HWIO_GCC_USB30_PRIM_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0000f004)
#define HWIO_GCC_USB30_PRIM_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0000f004)
#define HWIO_GCC_USB30_PRIM_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0000f004)
#define HWIO_GCC_USB30_PRIM_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0000f008)
#define HWIO_GCC_USB30_PRIM_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0000f008)
#define HWIO_GCC_USB30_PRIM_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0000f008)
#define HWIO_GCC_USB30_PRIM_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000f00c)
#define HWIO_GCC_USB30_PRIM_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000f00c)
#define HWIO_GCC_USB30_PRIM_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000f00c)
#define HWIO_GCC_USB30_PRIM_MASTER_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0000f010)
#define HWIO_GCC_USB30_PRIM_MASTER_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f010)
#define HWIO_GCC_USB30_PRIM_MASTER_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f010)
#define HWIO_GCC_USB30_PRIM_SLEEP_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0000f014)
#define HWIO_GCC_USB30_PRIM_SLEEP_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0000f014)
#define HWIO_GCC_USB30_PRIM_SLEEP_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0000f014)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0000f018)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f018)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f018)
#define HWIO_GCC_USB30_PRIM_MASTER_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000f01c)
#define HWIO_GCC_USB30_PRIM_MASTER_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f01c)
#define HWIO_GCC_USB30_PRIM_MASTER_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f01c)
#define HWIO_GCC_USB30_PRIM_MASTER_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000f020)
#define HWIO_GCC_USB30_PRIM_MASTER_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f020)
#define HWIO_GCC_USB30_PRIM_MASTER_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f020)
#define HWIO_GCC_USB30_PRIM_MASTER_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000f024)
#define HWIO_GCC_USB30_PRIM_MASTER_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000f024)
#define HWIO_GCC_USB30_PRIM_MASTER_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000f024)
#define HWIO_GCC_USB30_PRIM_MASTER_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000f028)
#define HWIO_GCC_USB30_PRIM_MASTER_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000f028)
#define HWIO_GCC_USB30_PRIM_MASTER_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000f028)
#define HWIO_GCC_USB30_PRIM_MASTER_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000f02c)
#define HWIO_GCC_USB30_PRIM_MASTER_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000f02c)
#define HWIO_GCC_USB30_PRIM_MASTER_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000f02c)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000f034)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f034)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f034)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000f038)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f038)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f038)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_POSTDIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0000f04c)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_POSTDIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f04c)
#define HWIO_GCC_USB30_PRIM_MOCK_UTMI_POSTDIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f04c)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0000f050)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f050)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f050)
#define HWIO_GCC_USB3_PRIM_PHY_COM_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000f054)
#define HWIO_GCC_USB3_PRIM_PHY_COM_AUX_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f054)
#define HWIO_GCC_USB3_PRIM_PHY_COM_AUX_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f054)
#define HWIO_GCC_USB3_PRIM_PHY_PIPE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0000f058)
#define HWIO_GCC_USB3_PRIM_PHY_PIPE_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f058)
#define HWIO_GCC_USB3_PRIM_PHY_PIPE_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f058)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000f060)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f060)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f060)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000f064)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f064)
#define HWIO_GCC_USB3_PRIM_PHY_AUX_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f064)
#define HWIO_GCC_USB30_SEC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00010000)
#define HWIO_GCC_USB30_SEC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00010000)
#define HWIO_GCC_USB30_SEC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00010000)
#define HWIO_GCC_USB30_SEC_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00010004)
#define HWIO_GCC_USB30_SEC_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00010004)
#define HWIO_GCC_USB30_SEC_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00010004)
#define HWIO_GCC_USB30_SEC_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00010008)
#define HWIO_GCC_USB30_SEC_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00010008)
#define HWIO_GCC_USB30_SEC_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00010008)
#define HWIO_GCC_USB30_SEC_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0001000c)
#define HWIO_GCC_USB30_SEC_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0001000c)
#define HWIO_GCC_USB30_SEC_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0001000c)
#define HWIO_GCC_USB30_SEC_MASTER_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00010010)
#define HWIO_GCC_USB30_SEC_MASTER_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00010010)
#define HWIO_GCC_USB30_SEC_MASTER_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00010010)
#define HWIO_GCC_USB30_SEC_SLEEP_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00010014)
#define HWIO_GCC_USB30_SEC_SLEEP_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00010014)
#define HWIO_GCC_USB30_SEC_SLEEP_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00010014)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00010018)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010018)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010018)
#define HWIO_GCC_USB30_SEC_MASTER_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0001001c)
#define HWIO_GCC_USB30_SEC_MASTER_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001001c)
#define HWIO_GCC_USB30_SEC_MASTER_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001001c)
#define HWIO_GCC_USB30_SEC_MASTER_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00010020)
#define HWIO_GCC_USB30_SEC_MASTER_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010020)
#define HWIO_GCC_USB30_SEC_MASTER_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010020)
#define HWIO_GCC_USB30_SEC_MASTER_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00010024)
#define HWIO_GCC_USB30_SEC_MASTER_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00010024)
#define HWIO_GCC_USB30_SEC_MASTER_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00010024)
#define HWIO_GCC_USB30_SEC_MASTER_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00010028)
#define HWIO_GCC_USB30_SEC_MASTER_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00010028)
#define HWIO_GCC_USB30_SEC_MASTER_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00010028)
#define HWIO_GCC_USB30_SEC_MASTER_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0001002c)
#define HWIO_GCC_USB30_SEC_MASTER_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0001002c)
#define HWIO_GCC_USB30_SEC_MASTER_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0001002c)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00010034)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010034)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010034)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00010038)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010038)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010038)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_POSTDIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001004c)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_POSTDIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001004c)
#define HWIO_GCC_USB30_SEC_MOCK_UTMI_POSTDIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001004c)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00010050)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00010050)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00010050)
#define HWIO_GCC_USB3_SEC_PHY_COM_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00010054)
#define HWIO_GCC_USB3_SEC_PHY_COM_AUX_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010054)
#define HWIO_GCC_USB3_SEC_PHY_COM_AUX_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010054)
#define HWIO_GCC_USB3_SEC_PHY_PIPE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00010058)
#define HWIO_GCC_USB3_SEC_PHY_PIPE_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010058)
#define HWIO_GCC_USB3_SEC_PHY_PIPE_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010058)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00010060)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010060)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010060)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00010064)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00010064)
#define HWIO_GCC_USB3_SEC_PHY_AUX_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00010064)
#define HWIO_GCC_USB3_PHY_PRIM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00050000)
#define HWIO_GCC_USB3_PHY_PRIM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00050000)
#define HWIO_GCC_USB3_PHY_PRIM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00050000)
#define HWIO_GCC_USB3PHY_PHY_PRIM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00050004)
#define HWIO_GCC_USB3PHY_PHY_PRIM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00050004)
#define HWIO_GCC_USB3PHY_PHY_PRIM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00050004)
#define HWIO_GCC_USB3_DP_PHY_PRIM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00050008)
#define HWIO_GCC_USB3_DP_PHY_PRIM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00050008)
#define HWIO_GCC_USB3_DP_PHY_PRIM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00050008)
#define HWIO_GCC_USB3_PHY_SEC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0005000c)
#define HWIO_GCC_USB3_PHY_SEC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0005000c)
#define HWIO_GCC_USB3_PHY_SEC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0005000c)
#define HWIO_GCC_USB3PHY_PHY_SEC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00050010)
#define HWIO_GCC_USB3PHY_PHY_SEC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00050010)
#define HWIO_GCC_USB3PHY_PHY_SEC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00050010)
#define HWIO_GCC_USB3_DP_PHY_SEC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00050014)
#define HWIO_GCC_USB3_DP_PHY_SEC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00050014)
#define HWIO_GCC_USB3_DP_PHY_SEC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00050014)
#define HWIO_GCC_QUSB2PHY_PRIM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00012000)
#define HWIO_GCC_QUSB2PHY_PRIM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00012000)
#define HWIO_GCC_QUSB2PHY_PRIM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00012000)
#define HWIO_GCC_QUSB2PHY_SEC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00012004)
#define HWIO_GCC_QUSB2PHY_SEC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00012004)
#define HWIO_GCC_QUSB2PHY_SEC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00012004)
#define HWIO_GCC_USB_PHY_CFG_AHB2PHY_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0006a000)
#define HWIO_GCC_USB_PHY_CFG_AHB2PHY_BCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006a000)
#define HWIO_GCC_USB_PHY_CFG_AHB2PHY_BCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006a000)
#define HWIO_GCC_AHB2PHY_SOUTH_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0006a004)
#define HWIO_GCC_AHB2PHY_SOUTH_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0006a004)
#define HWIO_GCC_AHB2PHY_SOUTH_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0006a004)
#define HWIO_GCC_SDCC2_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00014000)
#define HWIO_GCC_SDCC2_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00014000)
#define HWIO_GCC_SDCC2_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00014000)
#define HWIO_GCC_SDCC2_APPS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00014004)
#define HWIO_GCC_SDCC2_APPS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00014004)
#define HWIO_GCC_SDCC2_APPS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00014004)
#define HWIO_GCC_SDCC2_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00014008)
#define HWIO_GCC_SDCC2_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00014008)
#define HWIO_GCC_SDCC2_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00014008)
#define HWIO_GCC_SDCC2_APPS_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001400c)
#define HWIO_GCC_SDCC2_APPS_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001400c)
#define HWIO_GCC_SDCC2_APPS_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001400c)
#define HWIO_GCC_SDCC2_APPS_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00014010)
#define HWIO_GCC_SDCC2_APPS_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00014010)
#define HWIO_GCC_SDCC2_APPS_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00014010)
#define HWIO_GCC_SDCC2_APPS_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00014014)
#define HWIO_GCC_SDCC2_APPS_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00014014)
#define HWIO_GCC_SDCC2_APPS_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00014014)
#define HWIO_GCC_SDCC2_APPS_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00014018)
#define HWIO_GCC_SDCC2_APPS_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00014018)
#define HWIO_GCC_SDCC2_APPS_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00014018)
#define HWIO_GCC_SDCC2_APPS_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001401c)
#define HWIO_GCC_SDCC2_APPS_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001401c)
#define HWIO_GCC_SDCC2_APPS_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001401c)
#define HWIO_GCC_SDCC4_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00016000)
#define HWIO_GCC_SDCC4_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00016000)
#define HWIO_GCC_SDCC4_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00016000)
#define HWIO_GCC_SDCC4_APPS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00016004)
#define HWIO_GCC_SDCC4_APPS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00016004)
#define HWIO_GCC_SDCC4_APPS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00016004)
#define HWIO_GCC_SDCC4_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00016008)
#define HWIO_GCC_SDCC4_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00016008)
#define HWIO_GCC_SDCC4_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00016008)
#define HWIO_GCC_SDCC4_APPS_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001600c)
#define HWIO_GCC_SDCC4_APPS_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001600c)
#define HWIO_GCC_SDCC4_APPS_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001600c)
#define HWIO_GCC_SDCC4_APPS_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00016010)
#define HWIO_GCC_SDCC4_APPS_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00016010)
#define HWIO_GCC_SDCC4_APPS_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00016010)
#define HWIO_GCC_SDCC4_APPS_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00016014)
#define HWIO_GCC_SDCC4_APPS_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00016014)
#define HWIO_GCC_SDCC4_APPS_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00016014)
#define HWIO_GCC_SDCC4_APPS_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00016018)
#define HWIO_GCC_SDCC4_APPS_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00016018)
#define HWIO_GCC_SDCC4_APPS_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00016018)
#define HWIO_GCC_SDCC4_APPS_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0001601c)
#define HWIO_GCC_SDCC4_APPS_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0001601c)
#define HWIO_GCC_SDCC4_APPS_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0001601c)
#define HWIO_GCC_QUPV3_WRAPPER_0_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00017000)
#define HWIO_GCC_QUPV3_WRAPPER_0_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00017000)
#define HWIO_GCC_QUPV3_WRAPPER_0_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00017000)
#define HWIO_GCC_QUPV3_WRAP_0_M_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017004)
#define HWIO_GCC_QUPV3_WRAP_0_M_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017004)
#define HWIO_GCC_QUPV3_WRAP_0_M_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017004)
#define HWIO_GCC_QUPV3_WRAP_0_S_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017008)
#define HWIO_GCC_QUPV3_WRAP_0_S_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017008)
#define HWIO_GCC_QUPV3_WRAP_0_S_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017008)
#define HWIO_GCC_QUPV3_WRAP0_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001700c)
#define HWIO_GCC_QUPV3_WRAP0_CORE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001700c)
#define HWIO_GCC_QUPV3_WRAP0_CORE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001700c)
#define HWIO_GCC_QUPV3_WRAP0_CORE_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00017010)
#define HWIO_GCC_QUPV3_WRAP0_CORE_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017010)
#define HWIO_GCC_QUPV3_WRAP0_CORE_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017010)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00017014)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017014)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017014)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_CMD_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001702c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001702c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001702c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001703c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001703c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001703c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001704c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001704c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001704c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001705c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001705c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001705c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001706c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001706c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001706c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017070)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017070)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP0_CORE_2X_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017070)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017018)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017018)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017018)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001701c)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001701c)
#define HWIO_GCC_QUPV3_WRAP0_CORE_2X_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001701c)
#define HWIO_GCC_QUPV3_WRAP0_S0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00017144)
#define HWIO_GCC_QUPV3_WRAP0_S0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00017144)
#define HWIO_GCC_QUPV3_WRAP0_S0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00017144)
#define HWIO_GCC_QUPV3_WRAP0_SE0_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001715c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001715c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001715c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017164)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017164)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017164)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017168)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017168)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017168)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001716c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001716c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001716c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017170)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017170)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017170)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017174)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017174)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017174)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017178)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017178)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017178)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001717c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001717c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001717c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017180)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017180)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017180)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171a4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171a4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171a4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171a8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171a8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171a8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171ac)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171ac)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171ac)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171b0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171b0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171b0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171b4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171b4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171b4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171b8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171b8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171b8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171bc)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171bc)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171bc)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171c0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171c0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171c0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171e4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171e4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171e4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171e8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171e8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171e8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171ec)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171ec)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171ec)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171f0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171f0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171f0)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171f4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171f4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171f4)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171f8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171f8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171f8)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000171fc)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000171fc)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000171fc)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017200)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017200)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017200)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017224)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017224)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017224)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017228)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017228)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017228)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001722c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001722c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001722c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017230)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017230)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017230)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017234)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017234)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017234)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017238)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017238)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017238)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001723c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001723c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001723c)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017240)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017240)
#define HWIO_GCC_QUPV3_WRAP0_SE0_QUPV3_WRAP0_S0_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017240)
#define HWIO_GCC_QUPV3_WRAP0_S0_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017148)
#define HWIO_GCC_QUPV3_WRAP0_S0_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017148)
#define HWIO_GCC_QUPV3_WRAP0_S0_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017148)
#define HWIO_GCC_QUPV3_WRAP0_S0_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001714c)
#define HWIO_GCC_QUPV3_WRAP0_S0_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001714c)
#define HWIO_GCC_QUPV3_WRAP0_S0_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001714c)
#define HWIO_GCC_QUPV3_WRAP0_S0_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017150)
#define HWIO_GCC_QUPV3_WRAP0_S0_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017150)
#define HWIO_GCC_QUPV3_WRAP0_S0_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017150)
#define HWIO_GCC_QUPV3_WRAP0_S0_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017154)
#define HWIO_GCC_QUPV3_WRAP0_S0_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017154)
#define HWIO_GCC_QUPV3_WRAP0_S0_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017154)
#define HWIO_GCC_QUPV3_WRAP0_S0_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017158)
#define HWIO_GCC_QUPV3_WRAP0_S0_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017158)
#define HWIO_GCC_QUPV3_WRAP0_S0_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017158)
#define HWIO_GCC_QUPV3_WRAP0_S1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00017274)
#define HWIO_GCC_QUPV3_WRAP0_S1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00017274)
#define HWIO_GCC_QUPV3_WRAP0_S1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00017274)
#define HWIO_GCC_QUPV3_WRAP0_SE1_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001728c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001728c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001728c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017294)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017294)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017294)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017298)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017298)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017298)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001729c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001729c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001729c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172a0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172a0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172a0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172a4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172a4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172a4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172a8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172a8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172a8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172ac)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172ac)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172ac)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172b0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172b0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172b0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172d4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172d4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172d4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172d8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172d8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172d8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172dc)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172dc)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172dc)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172e0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172e0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172e0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172e4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172e4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172e4)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172e8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172e8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172e8)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172ec)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172ec)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172ec)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000172f0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000172f0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000172f0)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017314)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017314)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017314)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017318)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017318)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017318)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001731c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001731c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001731c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017320)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017320)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017320)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017324)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017324)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017324)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017328)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017328)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017328)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001732c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001732c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001732c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017330)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017330)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017330)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017354)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017354)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017354)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017358)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017358)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017358)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001735c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001735c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001735c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017360)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017360)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017360)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017364)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017364)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017364)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017368)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017368)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017368)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001736c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001736c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001736c)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017370)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017370)
#define HWIO_GCC_QUPV3_WRAP0_SE1_QUPV3_WRAP0_S1_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017370)
#define HWIO_GCC_QUPV3_WRAP0_S1_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017278)
#define HWIO_GCC_QUPV3_WRAP0_S1_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017278)
#define HWIO_GCC_QUPV3_WRAP0_S1_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017278)
#define HWIO_GCC_QUPV3_WRAP0_S1_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001727c)
#define HWIO_GCC_QUPV3_WRAP0_S1_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001727c)
#define HWIO_GCC_QUPV3_WRAP0_S1_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001727c)
#define HWIO_GCC_QUPV3_WRAP0_S1_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017280)
#define HWIO_GCC_QUPV3_WRAP0_S1_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017280)
#define HWIO_GCC_QUPV3_WRAP0_S1_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017280)
#define HWIO_GCC_QUPV3_WRAP0_S1_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017284)
#define HWIO_GCC_QUPV3_WRAP0_S1_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017284)
#define HWIO_GCC_QUPV3_WRAP0_S1_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017284)
#define HWIO_GCC_QUPV3_WRAP0_S1_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017288)
#define HWIO_GCC_QUPV3_WRAP0_S1_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017288)
#define HWIO_GCC_QUPV3_WRAP0_S1_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017288)
#define HWIO_GCC_QUPV3_WRAP0_S2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x000173a4)
#define HWIO_GCC_QUPV3_WRAP0_S2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x000173a4)
#define HWIO_GCC_QUPV3_WRAP0_S2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x000173a4)
#define HWIO_GCC_QUPV3_WRAP0_SE2_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000173bc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173bc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173bc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173c4)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173c4)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173c4)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173c8)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173c8)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173c8)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173cc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173cc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173cc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173d0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173d0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173d0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173d4)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173d4)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173d4)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173d8)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173d8)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173d8)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173dc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173dc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173dc)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000173e0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173e0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173e0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017404)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017404)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017404)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017408)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017408)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017408)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001740c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001740c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001740c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017410)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017410)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017410)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017414)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017414)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017414)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017418)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017418)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017418)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001741c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001741c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001741c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017420)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017420)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017420)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017444)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017444)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017444)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017448)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017448)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017448)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001744c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001744c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001744c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017450)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017450)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017450)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017454)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017454)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017454)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017458)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017458)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017458)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001745c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001745c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001745c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017460)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017460)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017460)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017484)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017484)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017484)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017488)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017488)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017488)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001748c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001748c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001748c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017490)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017490)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017490)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017494)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017494)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017494)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017498)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017498)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017498)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001749c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001749c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001749c)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000174a0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000174a0)
#define HWIO_GCC_QUPV3_WRAP0_SE2_QUPV3_WRAP0_S2_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000174a0)
#define HWIO_GCC_QUPV3_WRAP0_S2_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000173a8)
#define HWIO_GCC_QUPV3_WRAP0_S2_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173a8)
#define HWIO_GCC_QUPV3_WRAP0_S2_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173a8)
#define HWIO_GCC_QUPV3_WRAP0_S2_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000173ac)
#define HWIO_GCC_QUPV3_WRAP0_S2_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000173ac)
#define HWIO_GCC_QUPV3_WRAP0_S2_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000173ac)
#define HWIO_GCC_QUPV3_WRAP0_S2_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000173b0)
#define HWIO_GCC_QUPV3_WRAP0_S2_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000173b0)
#define HWIO_GCC_QUPV3_WRAP0_S2_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000173b0)
#define HWIO_GCC_QUPV3_WRAP0_S2_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000173b4)
#define HWIO_GCC_QUPV3_WRAP0_S2_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000173b4)
#define HWIO_GCC_QUPV3_WRAP0_S2_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000173b4)
#define HWIO_GCC_QUPV3_WRAP0_S2_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000173b8)
#define HWIO_GCC_QUPV3_WRAP0_S2_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000173b8)
#define HWIO_GCC_QUPV3_WRAP0_S2_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000173b8)
#define HWIO_GCC_QUPV3_WRAP0_S3_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x000174d4)
#define HWIO_GCC_QUPV3_WRAP0_S3_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x000174d4)
#define HWIO_GCC_QUPV3_WRAP0_S3_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x000174d4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000174ec)
#define HWIO_GCC_QUPV3_WRAP0_SE3_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000174ec)
#define HWIO_GCC_QUPV3_WRAP0_SE3_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000174ec)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000174f4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000174f4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000174f4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000174f8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000174f8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000174f8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000174fc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000174fc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000174fc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017500)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017500)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017500)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017504)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017504)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017504)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017508)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017508)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017508)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001750c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001750c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001750c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017510)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017510)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017510)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017534)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017534)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017534)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017538)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017538)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017538)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001753c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001753c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001753c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017540)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017540)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017540)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017544)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017544)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017544)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017548)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017548)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017548)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001754c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001754c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001754c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017550)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017550)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017550)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017574)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017574)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017574)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017578)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017578)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017578)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001757c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001757c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001757c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017580)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017580)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017580)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017584)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017584)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017584)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017588)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017588)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017588)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001758c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001758c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001758c)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017590)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017590)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017590)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175b4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175b4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175b4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175b8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175b8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175b8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175bc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175bc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175bc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175c0)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175c0)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175c0)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175c4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175c4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175c4)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175c8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175c8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175c8)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175cc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175cc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175cc)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000175d0)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000175d0)
#define HWIO_GCC_QUPV3_WRAP0_SE3_QUPV3_WRAP0_S3_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000175d0)
#define HWIO_GCC_QUPV3_WRAP0_S3_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000174d8)
#define HWIO_GCC_QUPV3_WRAP0_S3_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000174d8)
#define HWIO_GCC_QUPV3_WRAP0_S3_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000174d8)
#define HWIO_GCC_QUPV3_WRAP0_S3_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000174dc)
#define HWIO_GCC_QUPV3_WRAP0_S3_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000174dc)
#define HWIO_GCC_QUPV3_WRAP0_S3_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000174dc)
#define HWIO_GCC_QUPV3_WRAP0_S3_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000174e0)
#define HWIO_GCC_QUPV3_WRAP0_S3_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000174e0)
#define HWIO_GCC_QUPV3_WRAP0_S3_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000174e0)
#define HWIO_GCC_QUPV3_WRAP0_S3_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000174e4)
#define HWIO_GCC_QUPV3_WRAP0_S3_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000174e4)
#define HWIO_GCC_QUPV3_WRAP0_S3_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000174e4)
#define HWIO_GCC_QUPV3_WRAP0_S3_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000174e8)
#define HWIO_GCC_QUPV3_WRAP0_S3_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000174e8)
#define HWIO_GCC_QUPV3_WRAP0_S3_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000174e8)
#define HWIO_GCC_QUPV3_WRAP0_S4_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00017604)
#define HWIO_GCC_QUPV3_WRAP0_S4_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00017604)
#define HWIO_GCC_QUPV3_WRAP0_S4_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00017604)
#define HWIO_GCC_QUPV3_WRAP0_SE4_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001761c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001761c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001761c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017624)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017624)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017624)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017628)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017628)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017628)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001762c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001762c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001762c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017630)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017630)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017630)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017634)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017634)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017634)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017638)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017638)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017638)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001763c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001763c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001763c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017640)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017640)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017640)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017664)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017664)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017664)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017668)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017668)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017668)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001766c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001766c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001766c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017670)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017670)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017670)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017674)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017674)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017674)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017678)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017678)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017678)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001767c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001767c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001767c)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017680)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017680)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017680)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176a4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176a4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176a4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176a8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176a8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176a8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176ac)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176ac)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176ac)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176b0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176b0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176b0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176b4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176b4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176b4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176b8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176b8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176b8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176bc)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176bc)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176bc)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176c0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176c0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176c0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176e4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176e4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176e4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176e8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176e8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176e8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176ec)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176ec)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176ec)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176f0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176f0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176f0)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176f4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176f4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176f4)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176f8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176f8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176f8)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000176fc)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000176fc)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000176fc)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017700)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017700)
#define HWIO_GCC_QUPV3_WRAP0_SE4_QUPV3_WRAP0_S4_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017700)
#define HWIO_GCC_QUPV3_WRAP0_S4_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017608)
#define HWIO_GCC_QUPV3_WRAP0_S4_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017608)
#define HWIO_GCC_QUPV3_WRAP0_S4_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017608)
#define HWIO_GCC_QUPV3_WRAP0_S4_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001760c)
#define HWIO_GCC_QUPV3_WRAP0_S4_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001760c)
#define HWIO_GCC_QUPV3_WRAP0_S4_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001760c)
#define HWIO_GCC_QUPV3_WRAP0_S4_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017610)
#define HWIO_GCC_QUPV3_WRAP0_S4_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017610)
#define HWIO_GCC_QUPV3_WRAP0_S4_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017610)
#define HWIO_GCC_QUPV3_WRAP0_S4_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017614)
#define HWIO_GCC_QUPV3_WRAP0_S4_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017614)
#define HWIO_GCC_QUPV3_WRAP0_S4_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017614)
#define HWIO_GCC_QUPV3_WRAP0_S4_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017618)
#define HWIO_GCC_QUPV3_WRAP0_S4_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017618)
#define HWIO_GCC_QUPV3_WRAP0_S4_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017618)
#define HWIO_GCC_QUPV3_WRAP0_S5_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00017734)
#define HWIO_GCC_QUPV3_WRAP0_S5_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00017734)
#define HWIO_GCC_QUPV3_WRAP0_S5_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00017734)
#define HWIO_GCC_QUPV3_WRAP0_SE5_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001774c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001774c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001774c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017754)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017754)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017754)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017758)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017758)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017758)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001775c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001775c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001775c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017760)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017760)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017760)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017764)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017764)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017764)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017768)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017768)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017768)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001776c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001776c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001776c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017770)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017770)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017770)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017794)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017794)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017794)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017798)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017798)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017798)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001779c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001779c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001779c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177a0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177a0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177a0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177a4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177a4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177a4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177a8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177a8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177a8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177ac)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177ac)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177ac)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177b0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177b0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177b0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177d4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177d4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177d4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177d8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177d8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177d8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177dc)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177dc)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177dc)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177e0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177e0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177e0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177e4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177e4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177e4)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177e8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177e8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177e8)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177ec)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177ec)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177ec)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000177f0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000177f0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000177f0)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017814)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017814)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017814)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017818)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017818)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017818)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001781c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001781c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001781c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017820)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017820)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017820)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017824)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017824)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017824)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017828)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017828)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017828)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001782c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001782c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001782c)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017830)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017830)
#define HWIO_GCC_QUPV3_WRAP0_SE5_QUPV3_WRAP0_S5_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017830)
#define HWIO_GCC_QUPV3_WRAP0_S5_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017738)
#define HWIO_GCC_QUPV3_WRAP0_S5_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017738)
#define HWIO_GCC_QUPV3_WRAP0_S5_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017738)
#define HWIO_GCC_QUPV3_WRAP0_S5_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001773c)
#define HWIO_GCC_QUPV3_WRAP0_S5_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001773c)
#define HWIO_GCC_QUPV3_WRAP0_S5_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001773c)
#define HWIO_GCC_QUPV3_WRAP0_S5_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017740)
#define HWIO_GCC_QUPV3_WRAP0_S5_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017740)
#define HWIO_GCC_QUPV3_WRAP0_S5_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017740)
#define HWIO_GCC_QUPV3_WRAP0_S5_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017744)
#define HWIO_GCC_QUPV3_WRAP0_S5_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017744)
#define HWIO_GCC_QUPV3_WRAP0_S5_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017744)
#define HWIO_GCC_QUPV3_WRAP0_S5_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017748)
#define HWIO_GCC_QUPV3_WRAP0_S5_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017748)
#define HWIO_GCC_QUPV3_WRAP0_S5_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017748)
#define HWIO_GCC_QUPV3_WRAP0_S6_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00017864)
#define HWIO_GCC_QUPV3_WRAP0_S6_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00017864)
#define HWIO_GCC_QUPV3_WRAP0_S6_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00017864)
#define HWIO_GCC_QUPV3_WRAP0_SE6_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001787c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001787c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001787c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017884)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017884)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017884)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017888)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017888)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017888)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001788c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001788c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001788c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017890)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017890)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017890)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017894)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017894)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017894)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017898)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017898)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017898)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001789c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001789c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001789c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178a0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178a0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178a0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178c4)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178c4)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178c4)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178c8)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178c8)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178c8)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178cc)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178cc)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178cc)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178d0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178d0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178d0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178d4)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178d4)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178d4)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178d8)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178d8)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178d8)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178dc)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178dc)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178dc)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000178e0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000178e0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000178e0)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017904)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017904)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017904)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017908)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017908)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017908)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001790c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001790c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001790c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017910)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017910)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017910)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017914)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017914)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017914)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017918)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017918)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017918)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001791c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001791c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001791c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017920)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017920)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017920)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017944)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017944)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017944)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017948)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017948)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017948)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001794c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001794c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001794c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017950)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017950)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017950)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017954)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017954)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017954)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017958)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017958)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017958)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001795c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001795c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001795c)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017960)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017960)
#define HWIO_GCC_QUPV3_WRAP0_SE6_QUPV3_WRAP0_S6_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017960)
#define HWIO_GCC_QUPV3_WRAP0_S6_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017868)
#define HWIO_GCC_QUPV3_WRAP0_S6_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017868)
#define HWIO_GCC_QUPV3_WRAP0_S6_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017868)
#define HWIO_GCC_QUPV3_WRAP0_S6_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001786c)
#define HWIO_GCC_QUPV3_WRAP0_S6_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001786c)
#define HWIO_GCC_QUPV3_WRAP0_S6_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001786c)
#define HWIO_GCC_QUPV3_WRAP0_S6_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017870)
#define HWIO_GCC_QUPV3_WRAP0_S6_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017870)
#define HWIO_GCC_QUPV3_WRAP0_S6_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017870)
#define HWIO_GCC_QUPV3_WRAP0_S6_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017874)
#define HWIO_GCC_QUPV3_WRAP0_S6_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017874)
#define HWIO_GCC_QUPV3_WRAP0_S6_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017874)
#define HWIO_GCC_QUPV3_WRAP0_S6_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00017878)
#define HWIO_GCC_QUPV3_WRAP0_S6_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00017878)
#define HWIO_GCC_QUPV3_WRAP0_S6_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00017878)
#define HWIO_GCC_QUPV3_WRAP0_S7_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00017994)
#define HWIO_GCC_QUPV3_WRAP0_S7_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00017994)
#define HWIO_GCC_QUPV3_WRAP0_S7_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00017994)
#define HWIO_GCC_QUPV3_WRAP0_SE7_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000179ac)
#define HWIO_GCC_QUPV3_WRAP0_SE7_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179ac)
#define HWIO_GCC_QUPV3_WRAP0_SE7_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179ac)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179b4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179b4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179b4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179b8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179b8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179b8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179bc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179bc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179bc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179c0)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179c0)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179c0)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179c4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179c4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179c4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179c8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179c8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179c8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179cc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179cc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179cc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179d0)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179d0)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179d0)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179f4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179f4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179f4)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179f8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179f8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179f8)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000179fc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000179fc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000179fc)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a00)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a00)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a00)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a04)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a04)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a04)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a08)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a08)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a08)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a0c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a0c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a0c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a10)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a10)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a10)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a34)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a34)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a34)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a38)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a38)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a38)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a3c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a3c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a3c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a40)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a40)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a40)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a44)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a44)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a44)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a48)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a48)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a48)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a4c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a4c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a4c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a50)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a50)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a50)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a74)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a74)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a74)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a78)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a78)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a78)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a7c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a7c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a7c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a80)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a80)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a80)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a84)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a84)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a84)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a88)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a88)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a88)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a8c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a8c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a8c)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00017a90)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017a90)
#define HWIO_GCC_QUPV3_WRAP0_SE7_QUPV3_WRAP0_S7_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017a90)
#define HWIO_GCC_QUPV3_WRAP0_S7_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00017998)
#define HWIO_GCC_QUPV3_WRAP0_S7_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00017998)
#define HWIO_GCC_QUPV3_WRAP0_S7_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00017998)
#define HWIO_GCC_QUPV3_WRAP0_S7_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001799c)
#define HWIO_GCC_QUPV3_WRAP0_S7_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001799c)
#define HWIO_GCC_QUPV3_WRAP0_S7_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001799c)
#define HWIO_GCC_QUPV3_WRAP0_S7_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000179a0)
#define HWIO_GCC_QUPV3_WRAP0_S7_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000179a0)
#define HWIO_GCC_QUPV3_WRAP0_S7_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000179a0)
#define HWIO_GCC_QUPV3_WRAP0_S7_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000179a4)
#define HWIO_GCC_QUPV3_WRAP0_S7_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000179a4)
#define HWIO_GCC_QUPV3_WRAP0_S7_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000179a4)
#define HWIO_GCC_QUPV3_WRAP0_S7_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000179a8)
#define HWIO_GCC_QUPV3_WRAP0_S7_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000179a8)
#define HWIO_GCC_QUPV3_WRAP0_S7_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000179a8)
#define HWIO_GCC_QUPV3_WRAPPER_1_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00018000)
#define HWIO_GCC_QUPV3_WRAPPER_1_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00018000)
#define HWIO_GCC_QUPV3_WRAPPER_1_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00018000)
#define HWIO_GCC_QUPV3_WRAP_1_M_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00018004)
#define HWIO_GCC_QUPV3_WRAP_1_M_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018004)
#define HWIO_GCC_QUPV3_WRAP_1_M_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018004)
#define HWIO_GCC_QUPV3_WRAP_1_S_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00018008)
#define HWIO_GCC_QUPV3_WRAP_1_S_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018008)
#define HWIO_GCC_QUPV3_WRAP_1_S_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018008)
#define HWIO_GCC_QUPV3_WRAP1_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001800c)
#define HWIO_GCC_QUPV3_WRAP1_CORE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001800c)
#define HWIO_GCC_QUPV3_WRAP1_CORE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001800c)
#define HWIO_GCC_QUPV3_WRAP1_CORE_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00018010)
#define HWIO_GCC_QUPV3_WRAP1_CORE_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018010)
#define HWIO_GCC_QUPV3_WRAP1_CORE_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018010)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00018014)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018014)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018014)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001803c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001803c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001803c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001804c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001804c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001804c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001805c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001805c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001805c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001806c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001806c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001806c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018070)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018070)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP1_CORE_2X_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018070)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018018)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018018)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018018)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001801c)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001801c)
#define HWIO_GCC_QUPV3_WRAP1_CORE_2X_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001801c)
#define HWIO_GCC_QUPV3_WRAP1_S0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00018144)
#define HWIO_GCC_QUPV3_WRAP1_S0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00018144)
#define HWIO_GCC_QUPV3_WRAP1_S0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00018144)
#define HWIO_GCC_QUPV3_WRAP1_SE0_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001815c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001815c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001815c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018164)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018164)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018164)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018168)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018168)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018168)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001816c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001816c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001816c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018170)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018170)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018170)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018174)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018174)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018174)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018178)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018178)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018178)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001817c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001817c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001817c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018180)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018180)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018180)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181a4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181a4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181a4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181a8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181a8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181a8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181ac)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181ac)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181ac)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181b0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181b0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181b0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181b4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181b4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181b4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181b8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181b8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181b8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181bc)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181bc)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181bc)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181c0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181c0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181c0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181e4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181e4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181e4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181e8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181e8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181e8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181ec)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181ec)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181ec)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181f0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181f0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181f0)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181f4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181f4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181f4)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181f8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181f8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181f8)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000181fc)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000181fc)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000181fc)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018200)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018200)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018200)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018224)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018224)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018224)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018228)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018228)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018228)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001822c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001822c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001822c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018230)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018230)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018230)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018234)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018234)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018234)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018238)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018238)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018238)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001823c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001823c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001823c)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018240)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018240)
#define HWIO_GCC_QUPV3_WRAP1_SE0_QUPV3_WRAP1_S0_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018240)
#define HWIO_GCC_QUPV3_WRAP1_S0_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00018148)
#define HWIO_GCC_QUPV3_WRAP1_S0_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018148)
#define HWIO_GCC_QUPV3_WRAP1_S0_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018148)
#define HWIO_GCC_QUPV3_WRAP1_S0_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001814c)
#define HWIO_GCC_QUPV3_WRAP1_S0_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001814c)
#define HWIO_GCC_QUPV3_WRAP1_S0_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001814c)
#define HWIO_GCC_QUPV3_WRAP1_S0_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018150)
#define HWIO_GCC_QUPV3_WRAP1_S0_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018150)
#define HWIO_GCC_QUPV3_WRAP1_S0_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018150)
#define HWIO_GCC_QUPV3_WRAP1_S0_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018154)
#define HWIO_GCC_QUPV3_WRAP1_S0_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018154)
#define HWIO_GCC_QUPV3_WRAP1_S0_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018154)
#define HWIO_GCC_QUPV3_WRAP1_S0_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018158)
#define HWIO_GCC_QUPV3_WRAP1_S0_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018158)
#define HWIO_GCC_QUPV3_WRAP1_S0_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018158)
#define HWIO_GCC_QUPV3_WRAP1_S1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00018274)
#define HWIO_GCC_QUPV3_WRAP1_S1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00018274)
#define HWIO_GCC_QUPV3_WRAP1_S1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00018274)
#define HWIO_GCC_QUPV3_WRAP1_SE1_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001828c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001828c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001828c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018294)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018294)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018294)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018298)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018298)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018298)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001829c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001829c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001829c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182a0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182a0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182a0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182a4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182a4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182a4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182a8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182a8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182a8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182ac)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182ac)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182ac)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182b0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182b0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182b0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182d4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182d4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182d4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182d8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182d8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182d8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182dc)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182dc)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182dc)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182e0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182e0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182e0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182e4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182e4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182e4)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182e8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182e8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182e8)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182ec)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182ec)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182ec)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000182f0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000182f0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000182f0)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018314)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018314)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018314)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018318)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018318)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018318)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001831c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001831c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001831c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018320)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018320)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018320)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018324)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018324)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018324)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018328)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018328)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018328)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001832c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001832c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001832c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018330)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018330)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018330)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018354)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018354)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018354)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018358)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018358)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018358)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001835c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001835c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001835c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018360)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018360)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018360)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018364)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018364)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018364)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018368)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018368)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018368)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001836c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001836c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001836c)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018370)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018370)
#define HWIO_GCC_QUPV3_WRAP1_SE1_QUPV3_WRAP1_S1_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018370)
#define HWIO_GCC_QUPV3_WRAP1_S1_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00018278)
#define HWIO_GCC_QUPV3_WRAP1_S1_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018278)
#define HWIO_GCC_QUPV3_WRAP1_S1_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018278)
#define HWIO_GCC_QUPV3_WRAP1_S1_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001827c)
#define HWIO_GCC_QUPV3_WRAP1_S1_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001827c)
#define HWIO_GCC_QUPV3_WRAP1_S1_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001827c)
#define HWIO_GCC_QUPV3_WRAP1_S1_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018280)
#define HWIO_GCC_QUPV3_WRAP1_S1_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018280)
#define HWIO_GCC_QUPV3_WRAP1_S1_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018280)
#define HWIO_GCC_QUPV3_WRAP1_S1_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018284)
#define HWIO_GCC_QUPV3_WRAP1_S1_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018284)
#define HWIO_GCC_QUPV3_WRAP1_S1_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018284)
#define HWIO_GCC_QUPV3_WRAP1_S1_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018288)
#define HWIO_GCC_QUPV3_WRAP1_S1_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018288)
#define HWIO_GCC_QUPV3_WRAP1_S1_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018288)
#define HWIO_GCC_QUPV3_WRAP1_S2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x000183a4)
#define HWIO_GCC_QUPV3_WRAP1_S2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x000183a4)
#define HWIO_GCC_QUPV3_WRAP1_S2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x000183a4)
#define HWIO_GCC_QUPV3_WRAP1_SE2_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000183bc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183bc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183bc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183c4)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183c4)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183c4)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183c8)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183c8)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183c8)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183cc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183cc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183cc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183d0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183d0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183d0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183d4)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183d4)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183d4)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183d8)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183d8)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183d8)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183dc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183dc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183dc)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000183e0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183e0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183e0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018404)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018404)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018404)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018408)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018408)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018408)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001840c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001840c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001840c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018410)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018410)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018410)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018414)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018414)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018414)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018418)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018418)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018418)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001841c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001841c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001841c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018420)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018420)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018420)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018444)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018444)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018444)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018448)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018448)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018448)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001844c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001844c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001844c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018450)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018450)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018450)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018454)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018454)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018454)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018458)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018458)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018458)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001845c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001845c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001845c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018460)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018460)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018460)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018484)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018484)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018484)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018488)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018488)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018488)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001848c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001848c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001848c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018490)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018490)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018490)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018494)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018494)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018494)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018498)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018498)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018498)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001849c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001849c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001849c)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000184a0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000184a0)
#define HWIO_GCC_QUPV3_WRAP1_SE2_QUPV3_WRAP1_S2_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000184a0)
#define HWIO_GCC_QUPV3_WRAP1_S2_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000183a8)
#define HWIO_GCC_QUPV3_WRAP1_S2_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183a8)
#define HWIO_GCC_QUPV3_WRAP1_S2_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183a8)
#define HWIO_GCC_QUPV3_WRAP1_S2_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000183ac)
#define HWIO_GCC_QUPV3_WRAP1_S2_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000183ac)
#define HWIO_GCC_QUPV3_WRAP1_S2_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000183ac)
#define HWIO_GCC_QUPV3_WRAP1_S2_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000183b0)
#define HWIO_GCC_QUPV3_WRAP1_S2_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000183b0)
#define HWIO_GCC_QUPV3_WRAP1_S2_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000183b0)
#define HWIO_GCC_QUPV3_WRAP1_S2_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000183b4)
#define HWIO_GCC_QUPV3_WRAP1_S2_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000183b4)
#define HWIO_GCC_QUPV3_WRAP1_S2_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000183b4)
#define HWIO_GCC_QUPV3_WRAP1_S2_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000183b8)
#define HWIO_GCC_QUPV3_WRAP1_S2_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000183b8)
#define HWIO_GCC_QUPV3_WRAP1_S2_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000183b8)
#define HWIO_GCC_QUPV3_WRAP1_S3_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x000184d4)
#define HWIO_GCC_QUPV3_WRAP1_S3_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x000184d4)
#define HWIO_GCC_QUPV3_WRAP1_S3_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x000184d4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000184ec)
#define HWIO_GCC_QUPV3_WRAP1_SE3_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000184ec)
#define HWIO_GCC_QUPV3_WRAP1_SE3_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000184ec)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000184f4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000184f4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000184f4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000184f8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000184f8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000184f8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000184fc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000184fc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000184fc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018500)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018500)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018500)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018504)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018504)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018504)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018508)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018508)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018508)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001850c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001850c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001850c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018510)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018510)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018510)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018534)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018534)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018534)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018538)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018538)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018538)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001853c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001853c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001853c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018540)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018540)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018540)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018544)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018544)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018544)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018548)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018548)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018548)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001854c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001854c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001854c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018550)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018550)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018550)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018574)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018574)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018574)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018578)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018578)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018578)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001857c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001857c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001857c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018580)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018580)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018580)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018584)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018584)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018584)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018588)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018588)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018588)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001858c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001858c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001858c)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018590)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018590)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018590)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185b4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185b4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185b4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185b8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185b8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185b8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185bc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185bc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185bc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185c0)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185c0)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185c0)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185c4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185c4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185c4)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185c8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185c8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185c8)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185cc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185cc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185cc)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000185d0)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000185d0)
#define HWIO_GCC_QUPV3_WRAP1_SE3_QUPV3_WRAP1_S3_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000185d0)
#define HWIO_GCC_QUPV3_WRAP1_S3_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000184d8)
#define HWIO_GCC_QUPV3_WRAP1_S3_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000184d8)
#define HWIO_GCC_QUPV3_WRAP1_S3_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000184d8)
#define HWIO_GCC_QUPV3_WRAP1_S3_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000184dc)
#define HWIO_GCC_QUPV3_WRAP1_S3_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000184dc)
#define HWIO_GCC_QUPV3_WRAP1_S3_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000184dc)
#define HWIO_GCC_QUPV3_WRAP1_S3_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000184e0)
#define HWIO_GCC_QUPV3_WRAP1_S3_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000184e0)
#define HWIO_GCC_QUPV3_WRAP1_S3_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000184e0)
#define HWIO_GCC_QUPV3_WRAP1_S3_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000184e4)
#define HWIO_GCC_QUPV3_WRAP1_S3_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000184e4)
#define HWIO_GCC_QUPV3_WRAP1_S3_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000184e4)
#define HWIO_GCC_QUPV3_WRAP1_S3_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x000184e8)
#define HWIO_GCC_QUPV3_WRAP1_S3_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x000184e8)
#define HWIO_GCC_QUPV3_WRAP1_S3_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x000184e8)
#define HWIO_GCC_QUPV3_WRAP1_S4_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00018604)
#define HWIO_GCC_QUPV3_WRAP1_S4_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00018604)
#define HWIO_GCC_QUPV3_WRAP1_S4_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00018604)
#define HWIO_GCC_QUPV3_WRAP1_SE4_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001861c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001861c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001861c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018624)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018624)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018624)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018628)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018628)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018628)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001862c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001862c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001862c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018630)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018630)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018630)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018634)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018634)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018634)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018638)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018638)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018638)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001863c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001863c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001863c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018640)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018640)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018640)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018664)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018664)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018664)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018668)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018668)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018668)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001866c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001866c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001866c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018670)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018670)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018670)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018674)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018674)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018674)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018678)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018678)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018678)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001867c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001867c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001867c)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018680)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018680)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018680)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186a4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186a4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186a4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186a8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186a8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186a8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186ac)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186ac)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186ac)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186b0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186b0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186b0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186b4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186b4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186b4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186b8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186b8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186b8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186bc)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186bc)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186bc)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186c0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186c0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186c0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186e4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186e4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186e4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186e8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186e8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186e8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186ec)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186ec)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186ec)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186f0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186f0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186f0)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186f4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186f4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186f4)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186f8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186f8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186f8)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000186fc)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000186fc)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000186fc)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018700)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018700)
#define HWIO_GCC_QUPV3_WRAP1_SE4_QUPV3_WRAP1_S4_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018700)
#define HWIO_GCC_QUPV3_WRAP1_S4_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00018608)
#define HWIO_GCC_QUPV3_WRAP1_S4_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018608)
#define HWIO_GCC_QUPV3_WRAP1_S4_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018608)
#define HWIO_GCC_QUPV3_WRAP1_S4_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001860c)
#define HWIO_GCC_QUPV3_WRAP1_S4_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001860c)
#define HWIO_GCC_QUPV3_WRAP1_S4_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001860c)
#define HWIO_GCC_QUPV3_WRAP1_S4_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018610)
#define HWIO_GCC_QUPV3_WRAP1_S4_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018610)
#define HWIO_GCC_QUPV3_WRAP1_S4_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018610)
#define HWIO_GCC_QUPV3_WRAP1_S4_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018614)
#define HWIO_GCC_QUPV3_WRAP1_S4_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018614)
#define HWIO_GCC_QUPV3_WRAP1_S4_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018614)
#define HWIO_GCC_QUPV3_WRAP1_S4_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018618)
#define HWIO_GCC_QUPV3_WRAP1_S4_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018618)
#define HWIO_GCC_QUPV3_WRAP1_S4_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018618)
#define HWIO_GCC_QUPV3_WRAP1_S5_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00018734)
#define HWIO_GCC_QUPV3_WRAP1_S5_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00018734)
#define HWIO_GCC_QUPV3_WRAP1_S5_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00018734)
#define HWIO_GCC_QUPV3_WRAP1_SE5_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001874c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001874c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001874c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018754)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018754)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018754)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018758)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018758)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018758)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001875c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001875c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001875c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018760)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018760)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018760)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018764)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018764)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018764)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018768)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018768)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018768)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001876c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001876c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001876c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018770)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018770)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018770)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018794)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018794)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018794)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018798)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018798)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018798)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001879c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001879c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001879c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187a0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187a0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187a0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187a4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187a4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187a4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187a8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187a8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187a8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187ac)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187ac)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187ac)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187b0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187b0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187b0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187d4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187d4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187d4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187d8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187d8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187d8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187dc)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187dc)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187dc)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187e0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187e0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187e0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187e4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187e4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187e4)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187e8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187e8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187e8)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187ec)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187ec)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187ec)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000187f0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000187f0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000187f0)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018814)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018814)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018814)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018818)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018818)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018818)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001881c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001881c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001881c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018820)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018820)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018820)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018824)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018824)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018824)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018828)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018828)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018828)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001882c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001882c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001882c)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00018830)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018830)
#define HWIO_GCC_QUPV3_WRAP1_SE5_QUPV3_WRAP1_S5_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018830)
#define HWIO_GCC_QUPV3_WRAP1_S5_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00018738)
#define HWIO_GCC_QUPV3_WRAP1_S5_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00018738)
#define HWIO_GCC_QUPV3_WRAP1_S5_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00018738)
#define HWIO_GCC_QUPV3_WRAP1_S5_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001873c)
#define HWIO_GCC_QUPV3_WRAP1_S5_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001873c)
#define HWIO_GCC_QUPV3_WRAP1_S5_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001873c)
#define HWIO_GCC_QUPV3_WRAP1_S5_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018740)
#define HWIO_GCC_QUPV3_WRAP1_S5_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018740)
#define HWIO_GCC_QUPV3_WRAP1_S5_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018740)
#define HWIO_GCC_QUPV3_WRAP1_S5_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018744)
#define HWIO_GCC_QUPV3_WRAP1_S5_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018744)
#define HWIO_GCC_QUPV3_WRAP1_S5_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018744)
#define HWIO_GCC_QUPV3_WRAP1_S5_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00018748)
#define HWIO_GCC_QUPV3_WRAP1_S5_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00018748)
#define HWIO_GCC_QUPV3_WRAP1_S5_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00018748)
#define HWIO_GCC_PDM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00033000)
#define HWIO_GCC_PDM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00033000)
#define HWIO_GCC_PDM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00033000)
#define HWIO_GCC_PDM_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00033004)
#define HWIO_GCC_PDM_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00033004)
#define HWIO_GCC_PDM_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00033004)
#define HWIO_GCC_PDM_XO4_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00033008)
#define HWIO_GCC_PDM_XO4_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00033008)
#define HWIO_GCC_PDM_XO4_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00033008)
#define HWIO_GCC_PDM2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003300c)
#define HWIO_GCC_PDM2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x0003300c)
#define HWIO_GCC_PDM2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x0003300c)
#define HWIO_GCC_PDM2_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00033010)
#define HWIO_GCC_PDM2_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00033010)
#define HWIO_GCC_PDM2_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00033010)
#define HWIO_GCC_PDM2_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00033014)
#define HWIO_GCC_PDM2_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00033014)
#define HWIO_GCC_PDM2_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00033014)
#define HWIO_GCC_PDM_XO4_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00033028)
#define HWIO_GCC_PDM_XO4_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00033028)
#define HWIO_GCC_PDM_XO4_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00033028)
#define HWIO_GCC_PRNG_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00034000)
#define HWIO_GCC_PRNG_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00034000)
#define HWIO_GCC_PRNG_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00034000)
#define HWIO_GCC_PRNG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00034004)
#define HWIO_GCC_PRNG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00034004)
#define HWIO_GCC_PRNG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00034004)
#define HWIO_GCC_TSIF_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00036000)
#define HWIO_GCC_TSIF_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00036000)
#define HWIO_GCC_TSIF_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00036000)
#define HWIO_GCC_TSIF_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00036004)
#define HWIO_GCC_TSIF_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00036004)
#define HWIO_GCC_TSIF_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00036004)
#define HWIO_GCC_TSIF_REF_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00036008)
#define HWIO_GCC_TSIF_REF_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00036008)
#define HWIO_GCC_TSIF_REF_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00036008)
#define HWIO_GCC_TSIF_INACTIVITY_TIMERS_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0003600c)
#define HWIO_GCC_TSIF_INACTIVITY_TIMERS_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0003600c)
#define HWIO_GCC_TSIF_INACTIVITY_TIMERS_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0003600c)
#define HWIO_GCC_TSIF_REF_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00036010)
#define HWIO_GCC_TSIF_REF_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00036010)
#define HWIO_GCC_TSIF_REF_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00036010)
#define HWIO_GCC_TSIF_REF_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00036014)
#define HWIO_GCC_TSIF_REF_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00036014)
#define HWIO_GCC_TSIF_REF_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00036014)
#define HWIO_GCC_TSIF_REF_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00036018)
#define HWIO_GCC_TSIF_REF_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00036018)
#define HWIO_GCC_TSIF_REF_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00036018)
#define HWIO_GCC_TSIF_REF_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003601c)
#define HWIO_GCC_TSIF_REF_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0003601c)
#define HWIO_GCC_TSIF_REF_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0003601c)
#define HWIO_GCC_TSIF_REF_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00036020)
#define HWIO_GCC_TSIF_REF_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00036020)
#define HWIO_GCC_TSIF_REF_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00036020)
#define HWIO_GCC_TCSR_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00037000)
#define HWIO_GCC_TCSR_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00037000)
#define HWIO_GCC_TCSR_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00037000)
#define HWIO_GCC_TCSR_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00037004)
#define HWIO_GCC_TCSR_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00037004)
#define HWIO_GCC_TCSR_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00037004)
#define HWIO_GCC_BOOT_ROM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00038000)
#define HWIO_GCC_BOOT_ROM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00038000)
#define HWIO_GCC_BOOT_ROM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00038000)
#define HWIO_GCC_BOOT_ROM_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00038004)
#define HWIO_GCC_BOOT_ROM_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00038004)
#define HWIO_GCC_BOOT_ROM_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00038004)
#define HWIO_GCC_TLMM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003a000)
#define HWIO_GCC_TLMM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0003a000)
#define HWIO_GCC_TLMM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0003a000)
#define HWIO_GCC_TLMM_NORTH_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0003a004)
#define HWIO_GCC_TLMM_NORTH_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0003a004)
#define HWIO_GCC_TLMM_NORTH_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0003a004)
#define HWIO_GCC_TLMM_SOUTH_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0003a008)
#define HWIO_GCC_TLMM_SOUTH_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0003a008)
#define HWIO_GCC_TLMM_SOUTH_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0003a008)
#define HWIO_GCC_TLMM_EAST_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003a00c)
#define HWIO_GCC_TLMM_EAST_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003a00c)
#define HWIO_GCC_TLMM_EAST_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003a00c)
#define HWIO_GCC_TLMM_WEST_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003a010)
#define HWIO_GCC_TLMM_WEST_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003a010)
#define HWIO_GCC_TLMM_WEST_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003a010)
#define HWIO_GCC_TLMM_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003a014)
#define HWIO_GCC_TLMM_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x0003a014)
#define HWIO_GCC_TLMM_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x0003a014)
#define HWIO_GCC_AOSS_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003c000)
#define HWIO_GCC_AOSS_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0003c000)
#define HWIO_GCC_AOSS_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0003c000)
#define HWIO_GCC_AOSS_CNOC_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003c004)
#define HWIO_GCC_AOSS_CNOC_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003c004)
#define HWIO_GCC_AOSS_CNOC_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003c004)
#define HWIO_GCC_AOSS_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003c008)
#define HWIO_GCC_AOSS_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0003c008)
#define HWIO_GCC_AOSS_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0003c008)
#define HWIO_GCC_SEC_CTRL_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003d000)
#define HWIO_GCC_SEC_CTRL_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0003d000)
#define HWIO_GCC_SEC_CTRL_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0003d000)
#define HWIO_GCC_SEC_CTRL_ACC_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003d004)
#define HWIO_GCC_SEC_CTRL_ACC_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003d004)
#define HWIO_GCC_SEC_CTRL_ACC_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003d004)
#define HWIO_GCC_SEC_CTRL_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003d008)
#define HWIO_GCC_SEC_CTRL_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003d008)
#define HWIO_GCC_SEC_CTRL_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003d008)
#define HWIO_GCC_SEC_CTRL_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003d00c)
#define HWIO_GCC_SEC_CTRL_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0003d00c)
#define HWIO_GCC_SEC_CTRL_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0003d00c)
#define HWIO_GCC_SEC_CTRL_SENSE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0003d010)
#define HWIO_GCC_SEC_CTRL_SENSE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0003d010)
#define HWIO_GCC_SEC_CTRL_SENSE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0003d010)
#define HWIO_GCC_SEC_CTRL_BOOT_ROM_PATCH_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0003d014)
#define HWIO_GCC_SEC_CTRL_BOOT_ROM_PATCH_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0003d014)
#define HWIO_GCC_SEC_CTRL_BOOT_ROM_PATCH_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0003d014)
#define HWIO_GCC_ACC_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003d018)
#define HWIO_GCC_ACC_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0003d018)
#define HWIO_GCC_ACC_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0003d018)
#define HWIO_GCC_ACC_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003d01c)
#define HWIO_GCC_ACC_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0003d01c)
#define HWIO_GCC_ACC_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0003d01c)
#define HWIO_GCC_SEC_CTRL_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003d030)
#define HWIO_GCC_SEC_CTRL_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003d030)
#define HWIO_GCC_SEC_CTRL_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003d030)
#define HWIO_GCC_SEC_CTRL_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003d034)
#define HWIO_GCC_SEC_CTRL_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003d034)
#define HWIO_GCC_SEC_CTRL_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003d034)
#define HWIO_GCC_SPDM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00040000)
#define HWIO_GCC_SPDM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00040000)
#define HWIO_GCC_SPDM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00040000)
#define HWIO_GCC_SPDM_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00040004)
#define HWIO_GCC_SPDM_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00040004)
#define HWIO_GCC_SPDM_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00040004)
#define HWIO_GCC_SPDM_MSTR_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00040008)
#define HWIO_GCC_SPDM_MSTR_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00040008)
#define HWIO_GCC_SPDM_MSTR_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00040008)
#define HWIO_GCC_SPDM_FF_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004000c)
#define HWIO_GCC_SPDM_FF_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0004000c)
#define HWIO_GCC_SPDM_FF_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0004000c)
#define HWIO_GCC_SPDM_MEMNOC_CY_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00040010)
#define HWIO_GCC_SPDM_MEMNOC_CY_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00040010)
#define HWIO_GCC_SPDM_MEMNOC_CY_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00040010)
#define HWIO_GCC_SPDM_SNOC_CY_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00040014)
#define HWIO_GCC_SPDM_SNOC_CY_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00040014)
#define HWIO_GCC_SPDM_SNOC_CY_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00040014)
#define HWIO_GCC_SPDM_DEBUG_CY_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00040018)
#define HWIO_GCC_SPDM_DEBUG_CY_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00040018)
#define HWIO_GCC_SPDM_DEBUG_CY_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00040018)
#define HWIO_GCC_SPDM_PNOC_CY_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004001c)
#define HWIO_GCC_SPDM_PNOC_CY_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004001c)
#define HWIO_GCC_SPDM_PNOC_CY_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004001c)
#define HWIO_GCC_SPDM_MEMNOC_CY_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00040020)
#define HWIO_GCC_SPDM_MEMNOC_CY_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00040020)
#define HWIO_GCC_SPDM_MEMNOC_CY_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00040020)
#define HWIO_GCC_SPDM_SNOC_CY_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00040024)
#define HWIO_GCC_SPDM_SNOC_CY_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00040024)
#define HWIO_GCC_SPDM_SNOC_CY_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00040024)
#define HWIO_GCC_SPDM_DEBUG_CY_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00040028)
#define HWIO_GCC_SPDM_DEBUG_CY_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00040028)
#define HWIO_GCC_SPDM_DEBUG_CY_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00040028)
#define HWIO_GCC_CE1_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00041000)
#define HWIO_GCC_CE1_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041000)
#define HWIO_GCC_CE1_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041000)
#define HWIO_GCC_CE1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00041004)
#define HWIO_GCC_CE1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041004)
#define HWIO_GCC_CE1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041004)
#define HWIO_GCC_CE1_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00041008)
#define HWIO_GCC_CE1_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00041008)
#define HWIO_GCC_CE1_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00041008)
#define HWIO_GCC_CE1_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004100c)
#define HWIO_GCC_CE1_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0004100c)
#define HWIO_GCC_CE1_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0004100c)
#define HWIO_GCC_RPMH_CE_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00041024)
#define HWIO_GCC_RPMH_CE_CMD_DFSR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00041024)
#define HWIO_GCC_RPMH_CE_CMD_DFSR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00041024)
#define HWIO_GCC_RPMH_CE_CE1_PERF0_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0004102c)
#define HWIO_GCC_RPMH_CE_CE1_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004102c)
#define HWIO_GCC_RPMH_CE_CE1_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004102c)
#define HWIO_GCC_RPMH_CE_CE1_PERF1_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00041030)
#define HWIO_GCC_RPMH_CE_CE1_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041030)
#define HWIO_GCC_RPMH_CE_CE1_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041030)
#define HWIO_GCC_RPMH_CE_CE1_PERF2_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00041034)
#define HWIO_GCC_RPMH_CE_CE1_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041034)
#define HWIO_GCC_RPMH_CE_CE1_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041034)
#define HWIO_GCC_RPMH_CE_CE1_PERF3_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00041038)
#define HWIO_GCC_RPMH_CE_CE1_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041038)
#define HWIO_GCC_RPMH_CE_CE1_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041038)
#define HWIO_GCC_RPMH_CE_CE1_PERF4_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0004103c)
#define HWIO_GCC_RPMH_CE_CE1_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004103c)
#define HWIO_GCC_RPMH_CE_CE1_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004103c)
#define HWIO_GCC_RPMH_CE_CE1_PERF5_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00041040)
#define HWIO_GCC_RPMH_CE_CE1_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041040)
#define HWIO_GCC_RPMH_CE_CE1_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041040)
#define HWIO_GCC_RPMH_CE_CE1_PERF6_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00041044)
#define HWIO_GCC_RPMH_CE_CE1_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041044)
#define HWIO_GCC_RPMH_CE_CE1_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041044)
#define HWIO_GCC_RPMH_CE_CE1_PERF7_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00041048)
#define HWIO_GCC_RPMH_CE_CE1_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041048)
#define HWIO_GCC_RPMH_CE_CE1_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041048)
#define HWIO_GCC_RPMH_CE_CE1_PERF8_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0004104c)
#define HWIO_GCC_RPMH_CE_CE1_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004104c)
#define HWIO_GCC_RPMH_CE_CE1_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004104c)
#define HWIO_GCC_RPMH_CE_CE1_PERF9_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00041050)
#define HWIO_GCC_RPMH_CE_CE1_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041050)
#define HWIO_GCC_RPMH_CE_CE1_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041050)
#define HWIO_GCC_RPMH_CE_CE1_PERF10_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00041054)
#define HWIO_GCC_RPMH_CE_CE1_PERF10_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041054)
#define HWIO_GCC_RPMH_CE_CE1_PERF10_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041054)
#define HWIO_GCC_RPMH_CE_CE1_PERF11_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00041058)
#define HWIO_GCC_RPMH_CE_CE1_PERF11_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041058)
#define HWIO_GCC_RPMH_CE_CE1_PERF11_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041058)
#define HWIO_GCC_RPMH_CE_CE1_PERF12_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0004105c)
#define HWIO_GCC_RPMH_CE_CE1_PERF12_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004105c)
#define HWIO_GCC_RPMH_CE_CE1_PERF12_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004105c)
#define HWIO_GCC_RPMH_CE_CE1_PERF13_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00041060)
#define HWIO_GCC_RPMH_CE_CE1_PERF13_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041060)
#define HWIO_GCC_RPMH_CE_CE1_PERF13_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041060)
#define HWIO_GCC_RPMH_CE_CE1_PERF14_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00041064)
#define HWIO_GCC_RPMH_CE_CE1_PERF14_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041064)
#define HWIO_GCC_RPMH_CE_CE1_PERF14_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041064)
#define HWIO_GCC_RPMH_CE_CE1_PERF15_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00041068)
#define HWIO_GCC_RPMH_CE_CE1_PERF15_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00041068)
#define HWIO_GCC_RPMH_CE_CE1_PERF15_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00041068)
#define HWIO_GCC_CE1_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00041010)
#define HWIO_GCC_CE1_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00041010)
#define HWIO_GCC_CE1_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00041010)
#define HWIO_GCC_CE1_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00041014)
#define HWIO_GCC_CE1_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00041014)
#define HWIO_GCC_CE1_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00041014)
#define HWIO_GCC_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00043000)
#define HWIO_GCC_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00043000)
#define HWIO_GCC_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00043000)
#define HWIO_GCC_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00043004)
#define HWIO_GCC_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00043004)
#define HWIO_GCC_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00043004)
#define HWIO_GCC_XO_DIV4_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00043008)
#define HWIO_GCC_XO_DIV4_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00043008)
#define HWIO_GCC_XO_DIV4_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00043008)
#define HWIO_GCC_SLEEP_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004300c)
#define HWIO_GCC_SLEEP_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0004300c)
#define HWIO_GCC_SLEEP_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0004300c)
#define HWIO_GCC_XO_DIV4_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00043010)
#define HWIO_GCC_XO_DIV4_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00043010)
#define HWIO_GCC_XO_DIV4_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00043010)
#define HWIO_GCC_SLEEP_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00043014)
#define HWIO_GCC_SLEEP_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00043014)
#define HWIO_GCC_SLEEP_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00043014)
#define HWIO_GCC_SLEEP_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00043018)
#define HWIO_GCC_SLEEP_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00043018)
#define HWIO_GCC_SLEEP_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00043018)
#define HWIO_GCC_XO_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004302c)
#define HWIO_GCC_XO_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0004302c)
#define HWIO_GCC_XO_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0004302c)
#define HWIO_GCC_XO_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00043030)
#define HWIO_GCC_XO_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00043030)
#define HWIO_GCC_XO_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00043030)
#define HWIO_GCC_DDRSS_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00044000)
#define HWIO_GCC_DDRSS_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00044000)
#define HWIO_GCC_DDRSS_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00044000)
#define HWIO_GCC_DDRSS_MMNOC_SF_QX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x000092a0)
#define HWIO_GCC_DDRSS_MMNOC_SF_QX_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000092a0)
#define HWIO_GCC_DDRSS_MMNOC_SF_QX_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000092a0)
#define HWIO_GCC_DDRSS_MMNOC_HF_QX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x000092a4)
#define HWIO_GCC_DDRSS_MMNOC_HF_QX_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000092a4)
#define HWIO_GCC_DDRSS_MMNOC_HF_QX_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000092a4)
#define HWIO_GCC_DDRSS_TCU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00083140)
#define HWIO_GCC_DDRSS_TCU_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00083140)
#define HWIO_GCC_DDRSS_TCU_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00083140)
#define HWIO_GCC_DDRSS_TURING_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00045158)
#define HWIO_GCC_DDRSS_TURING_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00045158)
#define HWIO_GCC_DDRSS_TURING_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00045158)
#define HWIO_GCC_DDRSS_MSS_Q6_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0008a154)
#define HWIO_GCC_DDRSS_MSS_Q6_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0008a154)
#define HWIO_GCC_DDRSS_MSS_Q6_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0008a154)
#define HWIO_GCC_DDRSS_GPU_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00071154)
#define HWIO_GCC_DDRSS_GPU_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00071154)
#define HWIO_GCC_DDRSS_GPU_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00071154)
#define HWIO_GCC_DDRSS_PCIE_SF_TBU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0008d04c)
#define HWIO_GCC_DDRSS_PCIE_SF_TBU_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008d04c)
#define HWIO_GCC_DDRSS_PCIE_SF_TBU_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008d04c)
#define HWIO_GCC_DDRSS_SYS_NOC_GC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044004)
#define HWIO_GCC_DDRSS_SYS_NOC_GC_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044004)
#define HWIO_GCC_DDRSS_SYS_NOC_GC_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044004)
#define HWIO_GCC_DDRSS_SYS_NOC_SF_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044008)
#define HWIO_GCC_DDRSS_SYS_NOC_SF_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044008)
#define HWIO_GCC_DDRSS_SYS_NOC_SF_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044008)
#define HWIO_GCC_DDRSS_SYS_NOC_SLAVE_AXI_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004400c)
#define HWIO_GCC_DDRSS_SYS_NOC_SLAVE_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004400c)
#define HWIO_GCC_DDRSS_SYS_NOC_SLAVE_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004400c)
#define HWIO_GCC_DDRSS_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00044010)
#define HWIO_GCC_DDRSS_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00044010)
#define HWIO_GCC_DDRSS_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00044010)
#define HWIO_GCC_DDRSS_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00044014)
#define HWIO_GCC_DDRSS_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00044014)
#define HWIO_GCC_DDRSS_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00044014)
#define HWIO_GCC_DDRSS_SLEEP_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00044018)
#define HWIO_GCC_DDRSS_SLEEP_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00044018)
#define HWIO_GCC_DDRSS_SLEEP_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00044018)
#define HWIO_GCC_MEMNOC_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004401c)
#define HWIO_GCC_MEMNOC_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0004401c)
#define HWIO_GCC_MEMNOC_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0004401c)
#define HWIO_GCC_DDRSS_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00044020)
#define HWIO_GCC_DDRSS_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00044020)
#define HWIO_GCC_DDRSS_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00044020)
#define HWIO_GCC_DDRSS_DRE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00044024)
#define HWIO_GCC_DDRSS_DRE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00044024)
#define HWIO_GCC_DDRSS_DRE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00044024)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044044)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044044)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044044)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044048)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044048)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044048)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004404c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004404c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004404c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044050)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044050)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044050)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044054)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044054)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044054)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044058)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044058)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044058)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004405c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004405c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004405c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044060)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044060)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044060)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044064)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044064)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044064)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044068)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044068)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044068)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004406c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004406c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004406c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044070)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044070)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044070)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044074)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044074)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044074)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044078)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044078)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044078)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004407c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004407c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004407c)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044080)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044080)
#define HWIO_GCC_RPMH_SHUB_MEMNOC_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044080)
#define HWIO_GCC_MEMNOC_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00044028)
#define HWIO_GCC_MEMNOC_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00044028)
#define HWIO_GCC_MEMNOC_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00044028)
#define HWIO_GCC_MEMNOC_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0004402c)
#define HWIO_GCC_MEMNOC_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0004402c)
#define HWIO_GCC_MEMNOC_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0004402c)
#define HWIO_GCC_RPMH_SHRM_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00044168)
#define HWIO_GCC_RPMH_SHRM_CMD_DFSR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00044168)
#define HWIO_GCC_RPMH_SHRM_CMD_DFSR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00044168)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF0_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044170)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044170)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044170)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF1_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044174)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044174)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044174)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF2_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044178)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044178)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044178)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF3_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0004417c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004417c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004417c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF4_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044180)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044180)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044180)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF5_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044184)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044184)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044184)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF6_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044188)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044188)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044188)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF7_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0004418c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004418c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004418c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF8_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044190)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044190)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044190)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF9_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00044194)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044194)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044194)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF10_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00044198)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044198)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044198)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF11_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0004419c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004419c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004419c)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF12_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x000441a0)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000441a0)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000441a0)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF13_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x000441a4)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000441a4)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000441a4)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF14_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x000441a8)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000441a8)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000441a8)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF15_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x000441ac)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000441ac)
#define HWIO_GCC_RPMH_SHRM_SHRM_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000441ac)
#define HWIO_GCC_SHRM_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00044154)
#define HWIO_GCC_SHRM_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00044154)
#define HWIO_GCC_SHRM_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00044154)
#define HWIO_GCC_SHRM_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00044158)
#define HWIO_GCC_SHRM_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00044158)
#define HWIO_GCC_SHRM_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00044158)
#define HWIO_GCC_SHRM_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00044280)
#define HWIO_GCC_SHRM_DCD_CDIV_DCDR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00044280)
#define HWIO_GCC_SHRM_DCD_CDIV_DCDR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00044280)
#define HWIO_GCC_DCNOC_CFG_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00044284)
#define HWIO_GCC_DCNOC_CFG_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00044284)
#define HWIO_GCC_DCNOC_CFG_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00044284)
#define HWIO_GCC_MEMNOC_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00044288)
#define HWIO_GCC_MEMNOC_DCD_CDIV_DCDR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00044288)
#define HWIO_GCC_MEMNOC_DCD_CDIV_DCDR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00044288)
#define HWIO_GCC_MEMNOC_CDIV_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004428c)
#define HWIO_GCC_MEMNOC_CDIV_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004428c)
#define HWIO_GCC_MEMNOC_CDIV_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004428c)
#define HWIO_GCC_SHRM_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00044290)
#define HWIO_GCC_SHRM_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00044290)
#define HWIO_GCC_SHRM_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00044290)
#define HWIO_GCC_DNOC_CFG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00044294)
#define HWIO_GCC_DNOC_CFG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00044294)
#define HWIO_GCC_DNOC_CFG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00044294)
#define HWIO_GCC_DDR_I_HCLK_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00044298)
#define HWIO_GCC_DDR_I_HCLK_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00044298)
#define HWIO_GCC_DDR_I_HCLK_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00044298)
#define HWIO_GCC_DDRMC_CH0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0004429c)
#define HWIO_GCC_DDRMC_CH0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0004429c)
#define HWIO_GCC_DDRMC_CH0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0004429c)
#define HWIO_GCC_DDRMC_CH1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x000442a0)
#define HWIO_GCC_DDRMC_CH1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x000442a0)
#define HWIO_GCC_DDRMC_CH1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x000442a0)
#define HWIO_GCC_RPMH_DDRMC_CH0_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000442b8)
#define HWIO_GCC_RPMH_DDRMC_CH0_CMD_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442b8)
#define HWIO_GCC_RPMH_DDRMC_CH0_CMD_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442b8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442c0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442c0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442c0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442c4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442c4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442c4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442c8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442c8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442c8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442cc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442cc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442cc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442d0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442d0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442d0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442d4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442d4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442d4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442d8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442d8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442d8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442dc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442dc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442dc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442e0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442e0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442e0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442e4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442e4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442e4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442e8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442e8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442e8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442ec)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442ec)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442ec)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442f0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442f0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442f0)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442f4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442f4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442f4)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442f8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442f8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442f8)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000442fc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442fc)
#define HWIO_GCC_RPMH_DDRMC_CH0_DDRMC_CH0_ROOT_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442fc)
#define HWIO_GCC_DDRMC_CH0_ROOT_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000442a4)
#define HWIO_GCC_DDRMC_CH0_ROOT_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442a4)
#define HWIO_GCC_DDRMC_CH0_ROOT_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442a4)
#define HWIO_GCC_DDRMC_CH0_ROOT_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000442a8)
#define HWIO_GCC_DDRMC_CH0_ROOT_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000442a8)
#define HWIO_GCC_DDRMC_CH0_ROOT_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000442a8)
#define HWIO_GCC_DDRMC_CH0_ROOT_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000443d0)
#define HWIO_GCC_DDRMC_CH0_ROOT_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443d0)
#define HWIO_GCC_DDRMC_CH0_ROOT_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443d0)
#define HWIO_GCC_RPMH_DDRMC_CH1_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000443e8)
#define HWIO_GCC_RPMH_DDRMC_CH1_CMD_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443e8)
#define HWIO_GCC_RPMH_DDRMC_CH1_CMD_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443e8)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000443f0)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443f0)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443f0)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000443f4)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443f4)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443f4)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000443f8)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443f8)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443f8)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000443fc)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443fc)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443fc)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044400)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044400)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044400)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044404)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044404)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044404)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044408)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044408)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044408)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004440c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004440c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004440c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044410)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044410)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044410)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044414)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044414)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044414)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044418)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044418)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044418)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004441c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004441c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004441c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044420)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044420)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044420)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044424)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044424)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044424)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044428)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044428)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044428)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004442c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004442c)
#define HWIO_GCC_RPMH_DDRMC_CH1_DDRMC_CH1_ROOT_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004442c)
#define HWIO_GCC_DDRMC_CH1_ROOT_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000443d4)
#define HWIO_GCC_DDRMC_CH1_ROOT_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443d4)
#define HWIO_GCC_DDRMC_CH1_ROOT_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443d4)
#define HWIO_GCC_DDRMC_CH1_ROOT_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000443d8)
#define HWIO_GCC_DDRMC_CH1_ROOT_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000443d8)
#define HWIO_GCC_DDRMC_CH1_ROOT_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000443d8)
#define HWIO_GCC_DDRMC_CH1_ROOT_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044500)
#define HWIO_GCC_DDRMC_CH1_ROOT_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044500)
#define HWIO_GCC_DDRMC_CH1_ROOT_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044500)
#define HWIO_GCC_LPASS_Q6_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00047000)
#define HWIO_GCC_LPASS_Q6_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00047000)
#define HWIO_GCC_LPASS_Q6_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00047000)
#define HWIO_GCC_LPASS_CORE_AXIM_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00047004)
#define HWIO_GCC_LPASS_CORE_AXIM_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00047004)
#define HWIO_GCC_LPASS_CORE_AXIM_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00047004)
#define HWIO_GCC_LPASS_HW_AF_NOC_ANOC_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00047008)
#define HWIO_GCC_LPASS_HW_AF_NOC_ANOC_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00047008)
#define HWIO_GCC_LPASS_HW_AF_NOC_ANOC_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00047008)
#define HWIO_GCC_LPASS_SWAY_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0004700c)
#define HWIO_GCC_LPASS_SWAY_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0004700c)
#define HWIO_GCC_LPASS_SWAY_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0004700c)
#define HWIO_GCC_LPASS_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00047010)
#define HWIO_GCC_LPASS_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00047010)
#define HWIO_GCC_LPASS_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00047010)
#define HWIO_GCC_LPASS_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00047014)
#define HWIO_GCC_LPASS_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00047014)
#define HWIO_GCC_LPASS_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00047014)
#define HWIO_GCC_TURING_TBU0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00045000)
#define HWIO_GCC_TURING_TBU0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00045000)
#define HWIO_GCC_TURING_TBU0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00045000)
#define HWIO_GCC_TURING_TBU0_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00045004)
#define HWIO_GCC_TURING_TBU0_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00045004)
#define HWIO_GCC_TURING_TBU0_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00045004)
#define HWIO_GCC_TURING_TBU1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00045008)
#define HWIO_GCC_TURING_TBU1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00045008)
#define HWIO_GCC_TURING_TBU1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00045008)
#define HWIO_GCC_TURING_TBU1_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004500c)
#define HWIO_GCC_TURING_TBU1_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004500c)
#define HWIO_GCC_TURING_TBU1_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004500c)
#define HWIO_GCC_TURING_Q6_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00045010)
#define HWIO_GCC_TURING_Q6_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00045010)
#define HWIO_GCC_TURING_Q6_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00045010)
#define HWIO_GCC_TURING_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00045014)
#define HWIO_GCC_TURING_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00045014)
#define HWIO_GCC_TURING_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00045014)
#define HWIO_GCC_TURING_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00045018)
#define HWIO_GCC_TURING_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00045018)
#define HWIO_GCC_TURING_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00045018)
#define HWIO_GCC_TURING_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0004501c)
#define HWIO_GCC_TURING_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0004501c)
#define HWIO_GCC_TURING_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0004501c)
#define HWIO_GCC_TURING_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00045020)
#define HWIO_GCC_TURING_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00045020)
#define HWIO_GCC_TURING_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00045020)
#define HWIO_GCC_RPMH_CDSP_NOC_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00045038)
#define HWIO_GCC_RPMH_CDSP_NOC_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045038)
#define HWIO_GCC_RPMH_CDSP_NOC_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045038)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045040)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045040)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045040)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045044)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045044)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045044)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045048)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045048)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045048)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004504c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004504c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004504c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045050)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045050)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045050)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045054)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045054)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045054)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045058)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045058)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045058)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004505c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004505c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004505c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045060)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045060)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045060)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045064)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045064)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045064)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045068)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045068)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045068)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004506c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004506c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004506c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045070)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045070)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045070)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045074)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045074)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045074)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045078)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045078)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045078)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004507c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004507c)
#define HWIO_GCC_RPMH_CDSP_NOC_TURING_AXI_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004507c)
#define HWIO_GCC_TURING_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00045024)
#define HWIO_GCC_TURING_AXI_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00045024)
#define HWIO_GCC_TURING_AXI_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00045024)
#define HWIO_GCC_TURING_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00045028)
#define HWIO_GCC_TURING_AXI_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00045028)
#define HWIO_GCC_TURING_AXI_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00045028)
#define HWIO_GCC_TURING_AXI_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00045150)
#define HWIO_GCC_TURING_AXI_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045150)
#define HWIO_GCC_TURING_AXI_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045150)
#define HWIO_GCC_TURING_AXI_CDIV_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00045154)
#define HWIO_GCC_TURING_AXI_CDIV_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00045154)
#define HWIO_GCC_TURING_AXI_CDIV_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00045154)
#define HWIO_GCC_CPUSS_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00048000)
#define HWIO_GCC_CPUSS_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00048000)
#define HWIO_GCC_CPUSS_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00048000)
#define HWIO_GCC_CPUSS_GNOC_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00048004)
#define HWIO_GCC_CPUSS_GNOC_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00048004)
#define HWIO_GCC_CPUSS_GNOC_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00048004)
#define HWIO_GCC_CPUSS_RBCPR_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00048008)
#define HWIO_GCC_CPUSS_RBCPR_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00048008)
#define HWIO_GCC_CPUSS_RBCPR_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00048008)
#define HWIO_GCC_CPUSS_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0004800c)
#define HWIO_GCC_CPUSS_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0004800c)
#define HWIO_GCC_CPUSS_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0004800c)
#define HWIO_GCC_CPUSS_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00048010)
#define HWIO_GCC_CPUSS_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00048010)
#define HWIO_GCC_CPUSS_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00048010)
#define HWIO_GCC_CPUSS_AHB_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00048014)
#define HWIO_GCC_CPUSS_AHB_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00048014)
#define HWIO_GCC_CPUSS_AHB_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00048014)
#define HWIO_GCC_CPUSS_AHB_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00048018)
#define HWIO_GCC_CPUSS_AHB_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00048018)
#define HWIO_GCC_CPUSS_AHB_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00048018)
#define HWIO_GCC_CPUSS_AHB_POSTDIV_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0004802c)
#define HWIO_GCC_CPUSS_AHB_POSTDIV_CDIVR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004802c)
#define HWIO_GCC_CPUSS_AHB_POSTDIV_CDIVR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004802c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004804c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004804c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004804c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00048050)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048050)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048050)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00048054)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048054)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048054)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00048058)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048058)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048058)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004805c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004805c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004805c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00048060)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048060)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048060)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00048064)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048064)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048064)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00048068)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048068)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048068)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004806c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004806c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004806c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00048070)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048070)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048070)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF10_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00048074)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF10_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048074)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF10_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048074)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF11_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00048078)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF11_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048078)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF11_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048078)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF12_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0004807c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF12_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004807c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF12_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004807c)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF13_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00048080)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF13_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048080)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF13_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048080)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF14_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00048084)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF14_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048084)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF14_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048084)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF15_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00048088)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF15_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00048088)
#define HWIO_GCC_RPMH_SHUB_CPUSS_AXI_PERF15_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00048088)
#define HWIO_GCC_CPUSS_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00048030)
#define HWIO_GCC_CPUSS_AXI_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00048030)
#define HWIO_GCC_CPUSS_AXI_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00048030)
#define HWIO_GCC_CPUSS_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00048034)
#define HWIO_GCC_CPUSS_AXI_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00048034)
#define HWIO_GCC_CPUSS_AXI_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00048034)
#define HWIO_GCC_CPUSS_RBCPR_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0004815c)
#define HWIO_GCC_CPUSS_RBCPR_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0004815c)
#define HWIO_GCC_CPUSS_RBCPR_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0004815c)
#define HWIO_GCC_CPUSS_RBCPR_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00048160)
#define HWIO_GCC_CPUSS_RBCPR_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00048160)
#define HWIO_GCC_CPUSS_RBCPR_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00048160)
#define HWIO_GCC_CPUSS_GPLL0_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00048174)
#define HWIO_GCC_CPUSS_GPLL0_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00048174)
#define HWIO_GCC_CPUSS_GPLL0_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00048174)
#define HWIO_GCC_CPUSS_GPLL0_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00048178)
#define HWIO_GCC_CPUSS_GPLL0_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00048178)
#define HWIO_GCC_CPUSS_GPLL0_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00048178)
#define HWIO_GCC_CPUSS_AXI_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0004818c)
#define HWIO_GCC_CPUSS_AXI_DCD_CDIV_DCDR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004818c)
#define HWIO_GCC_CPUSS_AXI_DCD_CDIV_DCDR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004818c)
#define HWIO_GCC_CPUSS_DVM_BUS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00048190)
#define HWIO_GCC_CPUSS_DVM_BUS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00048190)
#define HWIO_GCC_CPUSS_DVM_BUS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00048190)
#define HWIO_GCC_APSS_QDSS_TSCTR_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00048194)
#define HWIO_GCC_APSS_QDSS_TSCTR_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00048194)
#define HWIO_GCC_APSS_QDSS_TSCTR_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00048194)
#define HWIO_GCC_APSS_QDSS_APB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00048198)
#define HWIO_GCC_APSS_QDSS_APB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00048198)
#define HWIO_GCC_APSS_QDSS_APB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00048198)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00049000)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_BCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00049000)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_BCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00049000)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00049004)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00049004)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00049004)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00049008)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00049008)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00049008)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_DIV512_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004900c)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_DIV512_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004900c)
#define HWIO_GCC_NOC_BUS_TIMEOUT_EXTREF_DIV512_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004900c)
#define HWIO_GCC_APB2JTAG_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004c000)
#define HWIO_GCC_APB2JTAG_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0004c000)
#define HWIO_GCC_APB2JTAG_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0004c000)
#define HWIO_GCC_RBCPR_CX_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004e000)
#define HWIO_GCC_RBCPR_CX_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0004e000)
#define HWIO_GCC_RBCPR_CX_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0004e000)
#define HWIO_GCC_RBCPR_CX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004e004)
#define HWIO_GCC_RBCPR_CX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0004e004)
#define HWIO_GCC_RBCPR_CX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0004e004)
#define HWIO_GCC_RBCPR_CX_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004e008)
#define HWIO_GCC_RBCPR_CX_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004e008)
#define HWIO_GCC_RBCPR_CX_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004e008)
#define HWIO_GCC_RBCPR_CX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004e00c)
#define HWIO_GCC_RBCPR_CX_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004e00c)
#define HWIO_GCC_RBCPR_CX_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004e00c)
#define HWIO_GCC_RBCPR_CX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004e010)
#define HWIO_GCC_RBCPR_CX_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004e010)
#define HWIO_GCC_RBCPR_CX_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004e010)
#define HWIO_GCC_RBCPR_MX_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004f000)
#define HWIO_GCC_RBCPR_MX_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0004f000)
#define HWIO_GCC_RBCPR_MX_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0004f000)
#define HWIO_GCC_RBCPR_MX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004f004)
#define HWIO_GCC_RBCPR_MX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0004f004)
#define HWIO_GCC_RBCPR_MX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0004f004)
#define HWIO_GCC_RBCPR_MX_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004f008)
#define HWIO_GCC_RBCPR_MX_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004f008)
#define HWIO_GCC_RBCPR_MX_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004f008)
#define HWIO_GCC_RBCPR_MX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004f00c)
#define HWIO_GCC_RBCPR_MX_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004f00c)
#define HWIO_GCC_RBCPR_MX_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004f00c)
#define HWIO_GCC_RBCPR_MX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0004f010)
#define HWIO_GCC_RBCPR_MX_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0004f010)
#define HWIO_GCC_RBCPR_MX_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0004f010)
#define HWIO_GCC_DEBUG_DIV_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00062004)
#define HWIO_GCC_DEBUG_DIV_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00062004)
#define HWIO_GCC_DEBUG_DIV_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00062004)
#define HWIO_GCC_DEBUG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00062008)
#define HWIO_GCC_DEBUG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00062008)
#define HWIO_GCC_DEBUG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00062008)
#define HWIO_GCC_GP1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00064000)
#define HWIO_GCC_GP1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00064000)
#define HWIO_GCC_GP1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00064000)
#define HWIO_GCC_GP1_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00064004)
#define HWIO_GCC_GP1_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00064004)
#define HWIO_GCC_GP1_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00064004)
#define HWIO_GCC_GP1_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00064008)
#define HWIO_GCC_GP1_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00064008)
#define HWIO_GCC_GP1_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00064008)
#define HWIO_GCC_GP1_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006400c)
#define HWIO_GCC_GP1_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006400c)
#define HWIO_GCC_GP1_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006400c)
#define HWIO_GCC_GP1_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00064010)
#define HWIO_GCC_GP1_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00064010)
#define HWIO_GCC_GP1_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00064010)
#define HWIO_GCC_GP1_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00064014)
#define HWIO_GCC_GP1_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00064014)
#define HWIO_GCC_GP1_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00064014)
#define HWIO_GCC_GP2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00065000)
#define HWIO_GCC_GP2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00065000)
#define HWIO_GCC_GP2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00065000)
#define HWIO_GCC_GP2_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00065004)
#define HWIO_GCC_GP2_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00065004)
#define HWIO_GCC_GP2_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00065004)
#define HWIO_GCC_GP2_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00065008)
#define HWIO_GCC_GP2_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00065008)
#define HWIO_GCC_GP2_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00065008)
#define HWIO_GCC_GP2_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006500c)
#define HWIO_GCC_GP2_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006500c)
#define HWIO_GCC_GP2_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006500c)
#define HWIO_GCC_GP2_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00065010)
#define HWIO_GCC_GP2_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00065010)
#define HWIO_GCC_GP2_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00065010)
#define HWIO_GCC_GP2_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00065014)
#define HWIO_GCC_GP2_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00065014)
#define HWIO_GCC_GP2_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00065014)
#define HWIO_GCC_GP3_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00066000)
#define HWIO_GCC_GP3_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00066000)
#define HWIO_GCC_GP3_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00066000)
#define HWIO_GCC_GP3_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00066004)
#define HWIO_GCC_GP3_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00066004)
#define HWIO_GCC_GP3_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00066004)
#define HWIO_GCC_GP3_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00066008)
#define HWIO_GCC_GP3_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00066008)
#define HWIO_GCC_GP3_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00066008)
#define HWIO_GCC_GP3_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006600c)
#define HWIO_GCC_GP3_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006600c)
#define HWIO_GCC_GP3_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006600c)
#define HWIO_GCC_GP3_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00066010)
#define HWIO_GCC_GP3_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00066010)
#define HWIO_GCC_GP3_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00066010)
#define HWIO_GCC_GP3_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00066014)
#define HWIO_GCC_GP3_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00066014)
#define HWIO_GCC_GP3_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00066014)
#define HWIO_GCC_PCIE_0_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006b000)
#define HWIO_GCC_PCIE_0_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0006b000)
#define HWIO_GCC_PCIE_0_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0006b000)
#define HWIO_GCC_PCIE_0_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006b004)
#define HWIO_GCC_PCIE_0_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0006b004)
#define HWIO_GCC_PCIE_0_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0006b004)
#define HWIO_GCC_PCIE_0_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0006b008)
#define HWIO_GCC_PCIE_0_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0006b008)
#define HWIO_GCC_PCIE_0_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0006b008)
#define HWIO_GCC_PCIE_0_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0006b00c)
#define HWIO_GCC_PCIE_0_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0006b00c)
#define HWIO_GCC_PCIE_0_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0006b00c)
#define HWIO_GCC_PCIE_0_SLV_Q2A_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0006b010)
#define HWIO_GCC_PCIE_0_SLV_Q2A_AXI_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006b010)
#define HWIO_GCC_PCIE_0_SLV_Q2A_AXI_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006b010)
#define HWIO_GCC_PCIE_0_SLV_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0006b014)
#define HWIO_GCC_PCIE_0_SLV_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0006b014)
#define HWIO_GCC_PCIE_0_SLV_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0006b014)
#define HWIO_GCC_PCIE_0_MSTR_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0006b018)
#define HWIO_GCC_PCIE_0_MSTR_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0006b018)
#define HWIO_GCC_PCIE_0_MSTR_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0006b018)
#define HWIO_GCC_PCIE_0_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0006b01c)
#define HWIO_GCC_PCIE_0_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0006b01c)
#define HWIO_GCC_PCIE_0_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0006b01c)
#define HWIO_GCC_PCIE_0_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0006b020)
#define HWIO_GCC_PCIE_0_AUX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0006b020)
#define HWIO_GCC_PCIE_0_AUX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0006b020)
#define HWIO_GCC_PCIE_0_PIPE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0006b024)
#define HWIO_GCC_PCIE_0_PIPE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0006b024)
#define HWIO_GCC_PCIE_0_PIPE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0006b024)
#define HWIO_GCC_PCIE_0_AUX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0006b02c)
#define HWIO_GCC_PCIE_0_AUX_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0006b02c)
#define HWIO_GCC_PCIE_0_AUX_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0006b02c)
#define HWIO_GCC_PCIE_0_AUX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0006b030)
#define HWIO_GCC_PCIE_0_AUX_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0006b030)
#define HWIO_GCC_PCIE_0_AUX_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0006b030)
#define HWIO_GCC_PCIE_0_AUX_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006b034)
#define HWIO_GCC_PCIE_0_AUX_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0006b034)
#define HWIO_GCC_PCIE_0_AUX_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0006b034)
#define HWIO_GCC_PCIE_0_AUX_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006b038)
#define HWIO_GCC_PCIE_0_AUX_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0006b038)
#define HWIO_GCC_PCIE_0_AUX_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0006b038)
#define HWIO_GCC_PCIE_0_AUX_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006b03c)
#define HWIO_GCC_PCIE_0_AUX_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0006b03c)
#define HWIO_GCC_PCIE_0_AUX_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0006b03c)
#define HWIO_GCC_PCIE_1_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008d000)
#define HWIO_GCC_PCIE_1_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0008d000)
#define HWIO_GCC_PCIE_1_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0008d000)
#define HWIO_GCC_PCIE_1_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008d004)
#define HWIO_GCC_PCIE_1_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008d004)
#define HWIO_GCC_PCIE_1_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008d004)
#define HWIO_GCC_PCIE_1_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0008d008)
#define HWIO_GCC_PCIE_1_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0008d008)
#define HWIO_GCC_PCIE_1_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0008d008)
#define HWIO_GCC_PCIE_1_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0008d00c)
#define HWIO_GCC_PCIE_1_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0008d00c)
#define HWIO_GCC_PCIE_1_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0008d00c)
#define HWIO_GCC_PCIE_1_SLV_Q2A_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0008d010)
#define HWIO_GCC_PCIE_1_SLV_Q2A_AXI_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008d010)
#define HWIO_GCC_PCIE_1_SLV_Q2A_AXI_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008d010)
#define HWIO_GCC_PCIE_1_SLV_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008d014)
#define HWIO_GCC_PCIE_1_SLV_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008d014)
#define HWIO_GCC_PCIE_1_SLV_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008d014)
#define HWIO_GCC_PCIE_1_MSTR_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0008d018)
#define HWIO_GCC_PCIE_1_MSTR_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0008d018)
#define HWIO_GCC_PCIE_1_MSTR_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0008d018)
#define HWIO_GCC_PCIE_1_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008d01c)
#define HWIO_GCC_PCIE_1_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008d01c)
#define HWIO_GCC_PCIE_1_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008d01c)
#define HWIO_GCC_PCIE_1_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0008d020)
#define HWIO_GCC_PCIE_1_AUX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0008d020)
#define HWIO_GCC_PCIE_1_AUX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0008d020)
#define HWIO_GCC_PCIE_1_PIPE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0008d024)
#define HWIO_GCC_PCIE_1_PIPE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0008d024)
#define HWIO_GCC_PCIE_1_PIPE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0008d024)
#define HWIO_GCC_PCIE_1_AUX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008d02c)
#define HWIO_GCC_PCIE_1_AUX_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008d02c)
#define HWIO_GCC_PCIE_1_AUX_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008d02c)
#define HWIO_GCC_PCIE_1_AUX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008d030)
#define HWIO_GCC_PCIE_1_AUX_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008d030)
#define HWIO_GCC_PCIE_1_AUX_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008d030)
#define HWIO_GCC_PCIE_1_AUX_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008d034)
#define HWIO_GCC_PCIE_1_AUX_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008d034)
#define HWIO_GCC_PCIE_1_AUX_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008d034)
#define HWIO_GCC_PCIE_1_AUX_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008d038)
#define HWIO_GCC_PCIE_1_AUX_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008d038)
#define HWIO_GCC_PCIE_1_AUX_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008d038)
#define HWIO_GCC_PCIE_1_AUX_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008d03c)
#define HWIO_GCC_PCIE_1_AUX_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008d03c)
#define HWIO_GCC_PCIE_1_AUX_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008d03c)
#define HWIO_GCC_PCIE_PHY_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006f000)
#define HWIO_GCC_PCIE_PHY_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0006f000)
#define HWIO_GCC_PCIE_PHY_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0006f000)
#define HWIO_GCC_PCIE_PHY_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0006f004)
#define HWIO_GCC_PCIE_PHY_AUX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0006f004)
#define HWIO_GCC_PCIE_PHY_AUX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0006f004)
#define HWIO_GCC_PCIE_PHY_REFGEN_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0006f014)
#define HWIO_GCC_PCIE_PHY_REFGEN_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006f014)
#define HWIO_GCC_PCIE_PHY_REFGEN_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006f014)
#define HWIO_GCC_PCIE_PHY_REFGEN_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0006f018)
#define HWIO_GCC_PCIE_PHY_REFGEN_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006f018)
#define HWIO_GCC_PCIE_PHY_REFGEN_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006f018)
#define HWIO_GCC_PCIE0_PHY_REFGEN_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0006f02c)
#define HWIO_GCC_PCIE0_PHY_REFGEN_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0006f02c)
#define HWIO_GCC_PCIE0_PHY_REFGEN_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0006f02c)
#define HWIO_GCC_PCIE1_PHY_REFGEN_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0006f030)
#define HWIO_GCC_PCIE1_PHY_REFGEN_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0006f030)
#define HWIO_GCC_PCIE1_PHY_REFGEN_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0006f030)
#define HWIO_GCC_UFS_CARD_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00075000)
#define HWIO_GCC_UFS_CARD_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00075000)
#define HWIO_GCC_UFS_CARD_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00075000)
#define HWIO_GCC_UFS_CARD_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00075004)
#define HWIO_GCC_UFS_CARD_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00075004)
#define HWIO_GCC_UFS_CARD_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00075004)
#define HWIO_GCC_UFS_CARD_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00075008)
#define HWIO_GCC_UFS_CARD_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00075008)
#define HWIO_GCC_UFS_CARD_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00075008)
#define HWIO_GCC_UFS_CARD_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0007500c)
#define HWIO_GCC_UFS_CARD_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0007500c)
#define HWIO_GCC_UFS_CARD_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0007500c)
#define HWIO_GCC_UFS_CARD_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00075010)
#define HWIO_GCC_UFS_CARD_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00075010)
#define HWIO_GCC_UFS_CARD_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00075010)
#define HWIO_GCC_UFS_CARD_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00075014)
#define HWIO_GCC_UFS_CARD_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00075014)
#define HWIO_GCC_UFS_CARD_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00075014)
#define HWIO_GCC_UFS_CARD_TX_SYMBOL_0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00075018)
#define HWIO_GCC_UFS_CARD_TX_SYMBOL_0_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075018)
#define HWIO_GCC_UFS_CARD_TX_SYMBOL_0_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075018)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0007501c)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_0_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007501c)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_0_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007501c)
#define HWIO_GCC_UFS_CARD_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00075020)
#define HWIO_GCC_UFS_CARD_AXI_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00075020)
#define HWIO_GCC_UFS_CARD_AXI_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00075020)
#define HWIO_GCC_UFS_CARD_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00075024)
#define HWIO_GCC_UFS_CARD_AXI_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00075024)
#define HWIO_GCC_UFS_CARD_AXI_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00075024)
#define HWIO_GCC_UFS_CARD_AXI_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00075028)
#define HWIO_GCC_UFS_CARD_AXI_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00075028)
#define HWIO_GCC_UFS_CARD_AXI_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00075028)
#define HWIO_GCC_UFS_CARD_AXI_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0007502c)
#define HWIO_GCC_UFS_CARD_AXI_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0007502c)
#define HWIO_GCC_UFS_CARD_AXI_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0007502c)
#define HWIO_GCC_UFS_CARD_AXI_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00075030)
#define HWIO_GCC_UFS_CARD_AXI_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00075030)
#define HWIO_GCC_UFS_CARD_AXI_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00075030)
#define HWIO_GCC_GPLL0_UFS_CARD_TX_SYMBOL_0_DIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007503c)
#define HWIO_GCC_GPLL0_UFS_CARD_TX_SYMBOL_0_DIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007503c)
#define HWIO_GCC_GPLL0_UFS_CARD_TX_SYMBOL_0_DIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007503c)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_0_DIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007504c)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_0_DIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007504c)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_0_DIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007504c)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00075058)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075058)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075058)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0007505c)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007505c)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007505c)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00075060)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075060)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075060)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00075064)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075064)
#define HWIO_GCC_UFS_CARD_ICE_CORE_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075064)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00075078)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075078)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075078)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007507c)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007507c)
#define HWIO_GCC_UFS_CARD_UNIPRO_CORE_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007507c)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00075090)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00075090)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00075090)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00075094)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075094)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075094)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00075098)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075098)
#define HWIO_GCC_UFS_CARD_PHY_AUX_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075098)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x000750ac)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_1_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000750ac)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_1_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000750ac)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_1_DIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000750b4)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_1_DIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000750b4)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_1_DIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000750b4)
#define HWIO_GCC_UFS_PHY_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00077000)
#define HWIO_GCC_UFS_PHY_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00077000)
#define HWIO_GCC_UFS_PHY_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00077000)
#define HWIO_GCC_UFS_PHY_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00077004)
#define HWIO_GCC_UFS_PHY_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00077004)
#define HWIO_GCC_UFS_PHY_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00077004)
#define HWIO_GCC_UFS_PHY_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00077008)
#define HWIO_GCC_UFS_PHY_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00077008)
#define HWIO_GCC_UFS_PHY_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00077008)
#define HWIO_GCC_UFS_PHY_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0007700c)
#define HWIO_GCC_UFS_PHY_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0007700c)
#define HWIO_GCC_UFS_PHY_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0007700c)
#define HWIO_GCC_UFS_PHY_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00077010)
#define HWIO_GCC_UFS_PHY_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00077010)
#define HWIO_GCC_UFS_PHY_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00077010)
#define HWIO_GCC_UFS_PHY_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00077014)
#define HWIO_GCC_UFS_PHY_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00077014)
#define HWIO_GCC_UFS_PHY_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00077014)
#define HWIO_GCC_UFS_PHY_TX_SYMBOL_0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00077018)
#define HWIO_GCC_UFS_PHY_TX_SYMBOL_0_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077018)
#define HWIO_GCC_UFS_PHY_TX_SYMBOL_0_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077018)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0007701c)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_0_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007701c)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_0_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007701c)
#define HWIO_GCC_UFS_PHY_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00077020)
#define HWIO_GCC_UFS_PHY_AXI_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00077020)
#define HWIO_GCC_UFS_PHY_AXI_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00077020)
#define HWIO_GCC_UFS_PHY_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00077024)
#define HWIO_GCC_UFS_PHY_AXI_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00077024)
#define HWIO_GCC_UFS_PHY_AXI_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00077024)
#define HWIO_GCC_UFS_PHY_AXI_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00077028)
#define HWIO_GCC_UFS_PHY_AXI_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00077028)
#define HWIO_GCC_UFS_PHY_AXI_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00077028)
#define HWIO_GCC_UFS_PHY_AXI_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007702c)
#define HWIO_GCC_UFS_PHY_AXI_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0007702c)
#define HWIO_GCC_UFS_PHY_AXI_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0007702c)
#define HWIO_GCC_UFS_PHY_AXI_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00077030)
#define HWIO_GCC_UFS_PHY_AXI_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00077030)
#define HWIO_GCC_UFS_PHY_AXI_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00077030)
#define HWIO_GCC_GPLL0_UFS_PHY_TX_SYMBOL_0_DIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007703c)
#define HWIO_GCC_GPLL0_UFS_PHY_TX_SYMBOL_0_DIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007703c)
#define HWIO_GCC_GPLL0_UFS_PHY_TX_SYMBOL_0_DIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007703c)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_0_DIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007704c)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_0_DIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007704c)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_0_DIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007704c)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00077058)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077058)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077058)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0007705c)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0007705c)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0007705c)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00077060)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077060)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077060)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00077064)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077064)
#define HWIO_GCC_UFS_PHY_ICE_CORE_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077064)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00077078)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077078)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077078)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007707c)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007707c)
#define HWIO_GCC_UFS_PHY_UNIPRO_CORE_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007707c)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00077090)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00077090)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00077090)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00077094)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077094)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077094)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00077098)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077098)
#define HWIO_GCC_UFS_PHY_PHY_AUX_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077098)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000770ac)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_1_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000770ac)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_1_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000770ac)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_1_DIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000770b4)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_1_DIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000770b4)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_1_DIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000770b4)
#define HWIO_GCC_SSC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00063000)
#define HWIO_GCC_SSC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00063000)
#define HWIO_GCC_SSC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00063000)
#define HWIO_GCC_SSC_AGGRE_NOC_AHBM_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00063004)
#define HWIO_GCC_SSC_AGGRE_NOC_AHBM_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00063004)
#define HWIO_GCC_SSC_AGGRE_NOC_AHBM_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00063004)
#define HWIO_GCC_AGGRE_NOC_SSC_Q6_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00063008)
#define HWIO_GCC_AGGRE_NOC_SSC_Q6_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00063008)
#define HWIO_GCC_AGGRE_NOC_SSC_Q6_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00063008)
#define HWIO_GCC_SSC_CNOC_AHBS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0006300c)
#define HWIO_GCC_SSC_CNOC_AHBS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0006300c)
#define HWIO_GCC_SSC_CNOC_AHBS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0006300c)
#define HWIO_GCC_SSC_CNOC_MPU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00063010)
#define HWIO_GCC_SSC_CNOC_MPU_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00063010)
#define HWIO_GCC_SSC_CNOC_MPU_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00063010)
#define HWIO_GCC_SSC_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00063014)
#define HWIO_GCC_SSC_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00063014)
#define HWIO_GCC_SSC_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00063014)
#define HWIO_GCC_VS_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a000)
#define HWIO_GCC_VS_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007a000)
#define HWIO_GCC_VS_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007a000)
#define HWIO_GCC_VDDCX_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a004)
#define HWIO_GCC_VDDCX_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0007a004)
#define HWIO_GCC_VDDCX_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0007a004)
#define HWIO_GCC_VDDMX_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a008)
#define HWIO_GCC_VDDMX_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0007a008)
#define HWIO_GCC_VDDMX_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0007a008)
#define HWIO_GCC_VDDA_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a00c)
#define HWIO_GCC_VDDA_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0007a00c)
#define HWIO_GCC_VDDA_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0007a00c)
#define HWIO_GCC_VS_CTRL_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a010)
#define HWIO_GCC_VS_CTRL_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0007a010)
#define HWIO_GCC_VS_CTRL_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0007a010)
#define HWIO_GCC_VS_CTRL_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0007a014)
#define HWIO_GCC_VS_CTRL_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0007a014)
#define HWIO_GCC_VS_CTRL_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0007a014)
#define HWIO_GCC_VSENSOR_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0007a018)
#define HWIO_GCC_VSENSOR_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0007a018)
#define HWIO_GCC_VSENSOR_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0007a018)
#define HWIO_GCC_VSENSOR_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0007a01c)
#define HWIO_GCC_VSENSOR_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0007a01c)
#define HWIO_GCC_VSENSOR_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0007a01c)
#define HWIO_GCC_VS_CTRL_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0007a030)
#define HWIO_GCC_VS_CTRL_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0007a030)
#define HWIO_GCC_VS_CTRL_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0007a030)
#define HWIO_GCC_VS_CTRL_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0007a034)
#define HWIO_GCC_VS_CTRL_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0007a034)
#define HWIO_GCC_VS_CTRL_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0007a034)
#define HWIO_GCC_MSS_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a048)
#define HWIO_GCC_MSS_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0007a048)
#define HWIO_GCC_MSS_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0007a048)
#define HWIO_GCC_GPU_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a04c)
#define HWIO_GCC_GPU_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0007a04c)
#define HWIO_GCC_GPU_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0007a04c)
#define HWIO_GCC_APC_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a050)
#define HWIO_GCC_APC_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0007a050)
#define HWIO_GCC_APC_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0007a050)
#define HWIO_GCC_VDDMMCX_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0007a054)
#define HWIO_GCC_VDDMMCX_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0007a054)
#define HWIO_GCC_VDDMMCX_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0007a054)
#define HWIO_GCC_WCSS_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007a058)
#define HWIO_GCC_WCSS_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0007a058)
#define HWIO_GCC_WCSS_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0007a058)
#define HWIO_GCC_VDDMMMX_VS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0007a05c)
#define HWIO_GCC_VDDMMMX_VS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0007a05c)
#define HWIO_GCC_VDDMMMX_VS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0007a05c)
#define HWIO_GCC_AGGRE_NOC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00082000)
#define HWIO_GCC_AGGRE_NOC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00082000)
#define HWIO_GCC_AGGRE_NOC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00082000)
#define HWIO_GCC_AGGRE_NOC_SOUTH_AHB_CFG_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082004)
#define HWIO_GCC_AGGRE_NOC_SOUTH_AHB_CFG_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082004)
#define HWIO_GCC_AGGRE_NOC_SOUTH_AHB_CFG_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082004)
#define HWIO_GCC_AGGRE_NOC_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00082008)
#define HWIO_GCC_AGGRE_NOC_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00082008)
#define HWIO_GCC_AGGRE_NOC_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00082008)
#define HWIO_GCC_AGGRE_NOC_COMPUTE_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0008200c)
#define HWIO_GCC_AGGRE_NOC_COMPUTE_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008200c)
#define HWIO_GCC_AGGRE_NOC_COMPUTE_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008200c)
#define HWIO_GCC_AGGRE_CNOC_PERIPH_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00082010)
#define HWIO_GCC_AGGRE_CNOC_PERIPH_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082010)
#define HWIO_GCC_AGGRE_CNOC_PERIPH_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082010)
#define HWIO_GCC_AGGRE_NOC_SF_WEST_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00082014)
#define HWIO_GCC_AGGRE_NOC_SF_WEST_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082014)
#define HWIO_GCC_AGGRE_NOC_SF_WEST_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082014)
#define HWIO_GCC_AGGRE_NOC_SF_NORTH_AXI_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082018)
#define HWIO_GCC_AGGRE_NOC_SF_NORTH_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082018)
#define HWIO_GCC_AGGRE_NOC_SF_NORTH_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082018)
#define HWIO_GCC_AGGRE_NOC_SF_CENTER_AXI_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008201c)
#define HWIO_GCC_AGGRE_NOC_SF_CENTER_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008201c)
#define HWIO_GCC_AGGRE_NOC_SF_CENTER_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008201c)
#define HWIO_GCC_AGGRE_NOC_QOSGEN_EXTREF_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082020)
#define HWIO_GCC_AGGRE_NOC_QOSGEN_EXTREF_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082020)
#define HWIO_GCC_AGGRE_NOC_QOSGEN_EXTREF_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082020)
#define HWIO_GCC_AGGRE_NOC_CENTER_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00082024)
#define HWIO_GCC_AGGRE_NOC_CENTER_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082024)
#define HWIO_GCC_AGGRE_NOC_CENTER_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082024)
#define HWIO_GCC_AGGRE_NOC_WEST_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00082028)
#define HWIO_GCC_AGGRE_NOC_WEST_AXI_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082028)
#define HWIO_GCC_AGGRE_NOC_WEST_AXI_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082028)
#define HWIO_GCC_AGGRE_NOC_SOUTH_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0008202c)
#define HWIO_GCC_AGGRE_NOC_SOUTH_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008202c)
#define HWIO_GCC_AGGRE_NOC_SOUTH_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008202c)
#define HWIO_GCC_AGGRE_NOC_EAST_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00082030)
#define HWIO_GCC_AGGRE_NOC_EAST_AXI_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082030)
#define HWIO_GCC_AGGRE_NOC_EAST_AXI_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082030)
#define HWIO_GCC_AGGRE_NOC_NORTH_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00082034)
#define HWIO_GCC_AGGRE_NOC_NORTH_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082034)
#define HWIO_GCC_AGGRE_NOC_NORTH_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082034)
#define HWIO_GCC_AGGRE_NOC_MONAQ_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00082038)
#define HWIO_GCC_AGGRE_NOC_MONAQ_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082038)
#define HWIO_GCC_AGGRE_NOC_MONAQ_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082038)
#define HWIO_GCC_AGGRE_USB3_PRIM_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0000f07c)
#define HWIO_GCC_AGGRE_USB3_PRIM_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f07c)
#define HWIO_GCC_AGGRE_USB3_PRIM_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f07c)
#define HWIO_GCC_AGGRE_USB3_SEC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001007c)
#define HWIO_GCC_AGGRE_USB3_SEC_AXI_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001007c)
#define HWIO_GCC_AGGRE_USB3_SEC_AXI_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001007c)
#define HWIO_GCC_AGGRE_UFS_PHY_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x000770c0)
#define HWIO_GCC_AGGRE_UFS_PHY_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000770c0)
#define HWIO_GCC_AGGRE_UFS_PHY_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000770c0)
#define HWIO_GCC_AGGRE_UFS_CARD_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x000750c0)
#define HWIO_GCC_AGGRE_UFS_CARD_AXI_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000750c0)
#define HWIO_GCC_AGGRE_UFS_CARD_AXI_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000750c0)
#define HWIO_GCC_AGGRE_NOC_IPA_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00089158)
#define HWIO_GCC_AGGRE_NOC_IPA_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00089158)
#define HWIO_GCC_AGGRE_NOC_IPA_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00089158)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_Q6_AXI_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004515c)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_Q6_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004515c)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_Q6_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004515c)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_AXI_CBCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00045160)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00045160)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00045160)
#define HWIO_GCC_AGGRE_NOC_NPU_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0004d148)
#define HWIO_GCC_AGGRE_NOC_NPU_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d148)
#define HWIO_GCC_AGGRE_NOC_NPU_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d148)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082058)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082058)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082058)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008205c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008205c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008205c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082060)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082060)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082060)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082064)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082064)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082064)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082068)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082068)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082068)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008206c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008206c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008206c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082070)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082070)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082070)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082074)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082074)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082074)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082078)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082078)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082078)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008207c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008207c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008207c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082080)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082080)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082080)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082084)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082084)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082084)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082088)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082088)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082088)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008208c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008208c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008208c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082090)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082090)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082090)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082094)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082094)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082094)
#define HWIO_GCC_AGGRE_NOC_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0008203c)
#define HWIO_GCC_AGGRE_NOC_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0008203c)
#define HWIO_GCC_AGGRE_NOC_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0008203c)
#define HWIO_GCC_AGGRE_NOC_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00082040)
#define HWIO_GCC_AGGRE_NOC_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00082040)
#define HWIO_GCC_AGGRE_NOC_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00082040)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082184)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082184)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082184)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082188)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082188)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082188)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008218c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008218c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008218c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082190)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082190)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082190)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082194)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082194)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082194)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082198)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082198)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082198)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008219c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008219c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008219c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821a0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821a0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821a0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821a4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821a4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821a4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821a8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821a8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821a8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821ac)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821ac)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821ac)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821b0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821b0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821b0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821b4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821b4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821b4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821b8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821b8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821b8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821bc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821bc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821bc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000821c0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000821c0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_WEST_SF_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000821c0)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00082168)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082168)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082168)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0008216c)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008216c)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008216c)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822b0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822b0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822b0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822b4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822b4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822b4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822b8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822b8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822b8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822bc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822bc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822bc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822c0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822c0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822c0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822c4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822c4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822c4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822c8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822c8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822c8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822cc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822cc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822cc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822d0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822d0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822d0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822d4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822d4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822d4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822d8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822d8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822d8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822dc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822dc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822dc)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822e0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822e0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822e0)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822e4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822e4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822e4)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822e8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822e8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822e8)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000822ec)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000822ec)
#define HWIO_GCC_RPMH_SYS_NOC_AGGRE_NOC_NORTH_SF_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000822ec)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082294)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082294)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082294)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082298)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082298)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082298)
#define HWIO_GCC_AGGRE_NOC_WEST_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823c0)
#define HWIO_GCC_AGGRE_NOC_WEST_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823c0)
#define HWIO_GCC_AGGRE_NOC_WEST_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823c0)
#define HWIO_GCC_AGGRE_NOC_EAST_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823c4)
#define HWIO_GCC_AGGRE_NOC_EAST_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823c4)
#define HWIO_GCC_AGGRE_NOC_EAST_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823c4)
#define HWIO_GCC_AGGRE_NOC_NORTH_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823c8)
#define HWIO_GCC_AGGRE_NOC_NORTH_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823c8)
#define HWIO_GCC_AGGRE_NOC_NORTH_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823c8)
#define HWIO_GCC_AGGRE_NOC_SOUTH_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823cc)
#define HWIO_GCC_AGGRE_NOC_SOUTH_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823cc)
#define HWIO_GCC_AGGRE_NOC_SOUTH_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823cc)
#define HWIO_GCC_AGGRE_NOC_MONAQ_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823d0)
#define HWIO_GCC_AGGRE_NOC_MONAQ_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823d0)
#define HWIO_GCC_AGGRE_NOC_MONAQ_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823d0)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_DCD_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x000823d4)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_DCD_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823d4)
#define HWIO_GCC_AGGRE_NOC_WEST_SF_DCD_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823d4)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_DCD_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823d8)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_DCD_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823d8)
#define HWIO_GCC_AGGRE_NOC_NORTH_SF_DCD_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823d8)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823f8)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823f8)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823f8)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823fc)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823fc)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823fc)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082400)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082400)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082400)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082404)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082404)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082404)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082408)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082408)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082408)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008240c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008240c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008240c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082410)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082410)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082410)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082414)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082414)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082414)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082418)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082418)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082418)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008241c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008241c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008241c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082420)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082420)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082420)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082424)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082424)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082424)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082428)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082428)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082428)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008242c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008242c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008242c)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082430)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082430)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082430)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082434)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082434)
#define HWIO_GCC_RPMH_CDSP_NOC_AGGRE_NOC_CDSP_NOC_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082434)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823dc)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823dc)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823dc)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000823e0)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000823e0)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000823e0)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082508)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082508)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082508)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CDIV_CDIVR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008250c)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CDIV_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008250c)
#define HWIO_GCC_AGGRE_NOC_CDSP_NOC_CDIV_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008250c)
#define HWIO_GCC_DCC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00084000)
#define HWIO_GCC_DCC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00084000)
#define HWIO_GCC_DCC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00084000)
#define HWIO_GCC_DCC_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00084004)
#define HWIO_GCC_DCC_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00084004)
#define HWIO_GCC_DCC_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00084004)
#define HWIO_GCC_IPA_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089000)
#define HWIO_GCC_IPA_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089000)
#define HWIO_GCC_IPA_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089000)
#define HWIO_GCC_IPA_BCR_RMSK 0x1
#define HWIO_GCC_IPA_BCR_ATTR 0x3
#define HWIO_GCC_IPA_BCR_IN in_dword_masked(HWIO_GCC_IPA_BCR_ADDR, \
					    HWIO_GCC_IPA_BCR_RMSK)
#define HWIO_GCC_IPA_BCR_INM(m) in_dword_masked(HWIO_GCC_IPA_BCR_ADDR, m)
#define HWIO_GCC_IPA_BCR_OUT(v) out_dword(HWIO_GCC_IPA_BCR_ADDR, v)
#define HWIO_GCC_IPA_BCR_OUTM(m, v) out_dword_masked_ns( \
		HWIO_GCC_IPA_BCR_ADDR, \
		m, \
		v, \
		HWIO_GCC_IPA_BCR_IN)
#define HWIO_GCC_IPA_BCR_BLK_ARES_BMSK 0x1
#define HWIO_GCC_IPA_BCR_BLK_ARES_SHFT 0x0
#define HWIO_GCC_IPA_BCR_BLK_ARES_DISABLE_FVAL 0x0
#define HWIO_GCC_IPA_BCR_BLK_ARES_ENABLE_FVAL 0x1
#define HWIO_GCC_IPA_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089004)
#define HWIO_GCC_IPA_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00089004)
#define HWIO_GCC_IPA_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00089004)
#define HWIO_GCC_IPA_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089008)
#define HWIO_GCC_IPA_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00089008)
#define HWIO_GCC_IPA_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00089008)
#define HWIO_GCC_IPA_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0008900c)
#define HWIO_GCC_IPA_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0008900c)
#define HWIO_GCC_IPA_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0008900c)
#define HWIO_GCC_IPA_2X_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089010)
#define HWIO_GCC_IPA_2X_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00089010)
#define HWIO_GCC_IPA_2X_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00089010)
#define HWIO_GCC_IPA_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089014)
#define HWIO_GCC_IPA_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089014)
#define HWIO_GCC_IPA_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089014)
#define HWIO_GCC_IPA_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089018)
#define HWIO_GCC_IPA_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00089018)
#define HWIO_GCC_IPA_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00089018)
#define HWIO_GCC_IPA_SLEEP_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0008901c)
#define HWIO_GCC_IPA_SLEEP_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0008901c)
#define HWIO_GCC_IPA_SLEEP_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0008901c)
#define HWIO_GCC_IPA_APB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089020)
#define HWIO_GCC_IPA_APB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00089020)
#define HWIO_GCC_IPA_APB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00089020)
#define HWIO_GCC_RPMH_IPA_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00089038)
#define HWIO_GCC_RPMH_IPA_CMD_DFSR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00089038)
#define HWIO_GCC_RPMH_IPA_CMD_DFSR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00089038)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF0_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089040)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089040)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089040)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF1_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089044)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089044)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089044)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF2_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089048)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089048)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089048)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF3_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0008904c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008904c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008904c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF4_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089050)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089050)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089050)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF5_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089054)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089054)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089054)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF6_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089058)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089058)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089058)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF7_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0008905c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008905c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008905c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF8_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089060)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089060)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089060)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF9_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00089064)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089064)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089064)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00089068)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089068)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089068)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008906c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008906c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008906c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00089070)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089070)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089070)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00089074)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089074)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089074)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00089078)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00089078)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00089078)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008907c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008907c)
#define HWIO_GCC_RPMH_IPA_IPA_2X_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008907c)
#define HWIO_GCC_IPA_2X_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00089024)
#define HWIO_GCC_IPA_2X_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00089024)
#define HWIO_GCC_IPA_2X_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00089024)
#define HWIO_GCC_IPA_2X_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00089028)
#define HWIO_GCC_IPA_2X_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00089028)
#define HWIO_GCC_IPA_2X_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00089028)
#define HWIO_GCC_IPA_2X_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00089150)
#define HWIO_GCC_IPA_2X_DCD_CDIV_DCDR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00089150)
#define HWIO_GCC_IPA_2X_DCD_CDIV_DCDR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00089150)
#define HWIO_GCC_IPA_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00089154)
#define HWIO_GCC_IPA_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00089154)
#define HWIO_GCC_IPA_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00089154)
#define HWIO_GCC_MSS_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0008a000)
#define HWIO_GCC_MSS_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0008a000)
#define HWIO_GCC_MSS_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0008a000)
#define HWIO_GCC_MSS_MFAB_AXIS_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0008a004)
#define HWIO_GCC_MSS_MFAB_AXIS_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0008a004)
#define HWIO_GCC_MSS_MFAB_AXIS_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0008a004)
#define HWIO_GCC_MSS_AXIS2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0008a008)
#define HWIO_GCC_MSS_AXIS2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0008a008)
#define HWIO_GCC_MSS_AXIS2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0008a008)
#define HWIO_GCC_MSS_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008a00c)
#define HWIO_GCC_MSS_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0008a00c)
#define HWIO_GCC_MSS_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0008a00c)
#define HWIO_GCC_MSS_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008a010)
#define HWIO_GCC_MSS_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0008a010)
#define HWIO_GCC_MSS_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0008a010)
#define HWIO_GCC_MSS_PLL0_MAIN_DIV_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0008a014)
#define HWIO_GCC_MSS_PLL0_MAIN_DIV_CDIVR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a014)
#define HWIO_GCC_MSS_PLL0_MAIN_DIV_CDIVR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a014)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a034)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a034)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a034)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a038)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a038)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a038)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a03c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a03c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a03c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a040)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a040)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a040)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a044)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a044)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a044)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a048)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a048)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a048)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a04c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a04c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a04c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a050)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a050)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a050)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a054)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a054)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a054)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a058)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a058)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a058)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF10_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a05c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF10_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a05c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF10_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a05c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF11_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a060)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF11_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a060)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF11_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a060)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF12_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a064)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF12_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a064)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF12_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a064)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF13_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a068)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF13_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a068)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF13_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a068)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF14_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a06c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF14_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a06c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF14_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a06c)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF15_DFSR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a070)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF15_DFSR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a070)
#define HWIO_GCC_RPMH_SHUB_MSS_Q6_MEMNOC_AXI_PERF15_DFSR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a070)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0008a018)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a018)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a018)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0008a01c)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a01c)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a01c)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_DCD_CDIV_DCDR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008a144)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_DCD_CDIV_DCDR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a144)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_DCD_CDIV_DCDR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a144)
#define HWIO_GCC_MSS_SNOC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0008a14c)
#define HWIO_GCC_MSS_SNOC_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0008a14c)
#define HWIO_GCC_MSS_SNOC_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0008a14c)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0008a150)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a150)
#define HWIO_GCC_MSS_Q6_MEMNOC_AXI_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a150)
#define HWIO_GCC_GLM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008b000)
#define HWIO_GCC_GLM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008b000)
#define HWIO_GCC_GLM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008b000)
#define HWIO_GCC_GLM_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008b004)
#define HWIO_GCC_GLM_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008b004)
#define HWIO_GCC_GLM_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008b004)
#define HWIO_GCC_GLM_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008b008)
#define HWIO_GCC_GLM_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008b008)
#define HWIO_GCC_GLM_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008b008)
#define HWIO_GCC_GLM_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008b00c)
#define HWIO_GCC_GLM_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0008b00c)
#define HWIO_GCC_GLM_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0008b00c)
#define HWIO_GCC_GLM_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008b010)
#define HWIO_GCC_GLM_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008b010)
#define HWIO_GCC_GLM_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008b010)
#define HWIO_GCC_GLM_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008b014)
#define HWIO_GCC_GLM_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008b014)
#define HWIO_GCC_GLM_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008b014)
#define HWIO_GCC_QREFS_VBG_CAL_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00088000)
#define HWIO_GCC_QREFS_VBG_CAL_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00088000)
#define HWIO_GCC_QREFS_VBG_CAL_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00088000)
#define HWIO_GCC_QREFS_VBG_CAL_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00088004)
#define HWIO_GCC_QREFS_VBG_CAL_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00088004)
#define HWIO_GCC_QREFS_VBG_CAL_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00088004)
#define HWIO_GCC_WCSS_AHB_S0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00011000)
#define HWIO_GCC_WCSS_AHB_S0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00011000)
#define HWIO_GCC_WCSS_AHB_S0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00011000)
#define HWIO_GCC_WCSS_AXI_M_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00011004)
#define HWIO_GCC_WCSS_AXI_M_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00011004)
#define HWIO_GCC_WCSS_AXI_M_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00011004)
#define HWIO_GCC_WCSS_ECAHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00011008)
#define HWIO_GCC_WCSS_ECAHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00011008)
#define HWIO_GCC_WCSS_ECAHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00011008)
#define HWIO_GCC_WCSS_SHDREG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0001100c)
#define HWIO_GCC_WCSS_SHDREG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0001100c)
#define HWIO_GCC_WCSS_SHDREG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0001100c)
#define HWIO_GCC_WCSS_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00011010)
#define HWIO_GCC_WCSS_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00011010)
#define HWIO_GCC_WCSS_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00011010)
#define HWIO_GCC_WCSS_APB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00011014)
#define HWIO_GCC_WCSS_APB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00011014)
#define HWIO_GCC_WCSS_APB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00011014)
#define HWIO_GCC_GPU_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00071000)
#define HWIO_GCC_GPU_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071000)
#define HWIO_GCC_GPU_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071000)
#define HWIO_GCC_GPU_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00071004)
#define HWIO_GCC_GPU_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00071004)
#define HWIO_GCC_GPU_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00071004)
#define HWIO_GCC_GPU_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00071008)
#define HWIO_GCC_GPU_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x00071008)
#define HWIO_GCC_GPU_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x00071008)
#define HWIO_GCC_GPU_MEMNOC_GFX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0007100c)
#define HWIO_GCC_GPU_MEMNOC_GFX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0007100c)
#define HWIO_GCC_GPU_MEMNOC_GFX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0007100c)
#define HWIO_GCC_GPU_MEMNOC_GFX_SREGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00071010)
#define HWIO_GCC_GPU_MEMNOC_GFX_SREGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00071010)
#define HWIO_GCC_GPU_MEMNOC_GFX_SREGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00071010)
#define HWIO_GCC_GPU_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00071014)
#define HWIO_GCC_GPU_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00071014)
#define HWIO_GCC_GPU_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00071014)
#define HWIO_GCC_GPU_SNOC_DVM_GFX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00071018)
#define HWIO_GCC_GPU_SNOC_DVM_GFX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00071018)
#define HWIO_GCC_GPU_SNOC_DVM_GFX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00071018)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071038)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071038)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071038)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007103c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007103c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007103c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071040)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071040)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071040)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071044)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071044)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071044)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071048)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071048)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071048)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007104c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007104c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007104c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071050)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071050)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071050)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071054)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071054)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071054)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071058)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071058)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071058)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007105c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007105c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007105c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071060)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071060)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071060)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071064)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071064)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071064)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071068)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071068)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071068)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007106c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007106c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007106c)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071070)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071070)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071070)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071074)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071074)
#define HWIO_GCC_RPMH_SHUB_GPU_MEMNOC_GFX_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071074)
#define HWIO_GCC_GPU_MEMNOC_GFX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0007101c)
#define HWIO_GCC_GPU_MEMNOC_GFX_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007101c)
#define HWIO_GCC_GPU_MEMNOC_GFX_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007101c)
#define HWIO_GCC_GPU_MEMNOC_GFX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00071020)
#define HWIO_GCC_GPU_MEMNOC_GFX_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071020)
#define HWIO_GCC_GPU_MEMNOC_GFX_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071020)
#define HWIO_GCC_GPU_MEMNOC_GFX_DCD_CDIV_DCDR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00071148)
#define HWIO_GCC_GPU_MEMNOC_GFX_DCD_CDIV_DCDR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071148)
#define HWIO_GCC_GPU_MEMNOC_GFX_DCD_CDIV_DCDR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071148)
#define HWIO_GCC_GPU_PLL0_MAIN_DIV_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0007114c)
#define HWIO_GCC_GPU_PLL0_MAIN_DIV_CDIVR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007114c)
#define HWIO_GCC_GPU_PLL0_MAIN_DIV_CDIVR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007114c)
#define HWIO_GCC_GPU_TRIG_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00071150)
#define HWIO_GCC_GPU_TRIG_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00071150)
#define HWIO_GCC_GPU_TRIG_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00071150)
#define HWIO_GCC_SP_SNOC_ANOC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00072000)
#define HWIO_GCC_SP_SNOC_ANOC_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00072000)
#define HWIO_GCC_SP_SNOC_ANOC_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00072000)
#define HWIO_GCC_SP_SCR_NIU_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00072004)
#define HWIO_GCC_SP_SCR_NIU_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00072004)
#define HWIO_GCC_SP_SCR_NIU_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00072004)
#define HWIO_GCC_SP_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00072008)
#define HWIO_GCC_SP_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00072008)
#define HWIO_GCC_SP_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00072008)
#define HWIO_GCC_SP_SCSR_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007200c)
#define HWIO_GCC_SP_SCSR_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0007200c)
#define HWIO_GCC_SP_SCSR_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0007200c)
#define HWIO_GCC_SP_SEC_CTRL_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00072010)
#define HWIO_GCC_SP_SEC_CTRL_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00072010)
#define HWIO_GCC_SP_SEC_CTRL_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00072010)
#define HWIO_GCC_SP_GPKT_XO_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00072014)
#define HWIO_GCC_SP_GPKT_XO_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00072014)
#define HWIO_GCC_SP_GPKT_XO_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00072014)
#define HWIO_GCC_SP_RSSC_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00072018)
#define HWIO_GCC_SP_RSSC_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00072018)
#define HWIO_GCC_SP_RSSC_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00072018)
#define HWIO_GCC_SP_ARI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007201c)
#define HWIO_GCC_SP_ARI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0007201c)
#define HWIO_GCC_SP_ARI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0007201c)
#define HWIO_GCC_SP_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00072020)
#define HWIO_GCC_SP_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00072020)
#define HWIO_GCC_SP_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00072020)
#define HWIO_GCC_SP_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00072024)
#define HWIO_GCC_SP_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00072024)
#define HWIO_GCC_SP_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00072024)
#define HWIO_GCC_NAV_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00015000)
#define HWIO_GCC_NAV_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00015000)
#define HWIO_GCC_NAV_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00015000)
#define HWIO_GCC_NAV_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00015004)
#define HWIO_GCC_NAV_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00015004)
#define HWIO_GCC_NAV_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00015004)
#define HWIO_GCC_AHB2PHY_SOUTH_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00007000)
#define HWIO_GCC_AHB2PHY_SOUTH_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00007000)
#define HWIO_GCC_AHB2PHY_SOUTH_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00007000)
#define HWIO_GCC_AHB2PHY_NORTH_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00007004)
#define HWIO_GCC_AHB2PHY_NORTH_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00007004)
#define HWIO_GCC_AHB2PHY_NORTH_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00007004)
#define HWIO_GCC_CM_PHY_REFGEN1_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00022000)
#define HWIO_GCC_CM_PHY_REFGEN1_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00022000)
#define HWIO_GCC_CM_PHY_REFGEN1_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00022000)
#define HWIO_GCC_CM_PHY_REFGEN1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00022004)
#define HWIO_GCC_CM_PHY_REFGEN1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00022004)
#define HWIO_GCC_CM_PHY_REFGEN1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00022004)
#define HWIO_GCC_CM_PHY_REFGEN2_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00024000)
#define HWIO_GCC_CM_PHY_REFGEN2_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00024000)
#define HWIO_GCC_CM_PHY_REFGEN2_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00024000)
#define HWIO_GCC_CM_PHY_REFGEN2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00024004)
#define HWIO_GCC_CM_PHY_REFGEN2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00024004)
#define HWIO_GCC_CM_PHY_REFGEN2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00024004)
#define HWIO_GCC_QSPI_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00024008)
#define HWIO_GCC_QSPI_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00024008)
#define HWIO_GCC_QSPI_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00024008)
#define HWIO_GCC_QSPI_CNOC_PERIPH_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0004b000)
#define HWIO_GCC_QSPI_CNOC_PERIPH_AHB_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004b000)
#define HWIO_GCC_QSPI_CNOC_PERIPH_AHB_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004b000)
#define HWIO_GCC_QSPI_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0004b004)
#define HWIO_GCC_QSPI_CORE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0004b004)
#define HWIO_GCC_QSPI_CORE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0004b004)
#define HWIO_GCC_QSPI_CORE_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0004b008)
#define HWIO_GCC_QSPI_CORE_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0004b008)
#define HWIO_GCC_QSPI_CORE_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0004b008)
#define HWIO_GCC_QSPI_CORE_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0004b00c)
#define HWIO_GCC_QSPI_CORE_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0004b00c)
#define HWIO_GCC_QSPI_CORE_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0004b00c)
#define HWIO_GCC_NPU_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004d000)
#define HWIO_GCC_NPU_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d000)
#define HWIO_GCC_NPU_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d000)
#define HWIO_GCC_NPU_CFG_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0004d004)
#define HWIO_GCC_NPU_CFG_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0004d004)
#define HWIO_GCC_NPU_CFG_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0004d004)
#define HWIO_GCC_NPU_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004d008)
#define HWIO_GCC_NPU_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0004d008)
#define HWIO_GCC_NPU_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0004d008)
#define HWIO_GCC_NPU_TRIG_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004d00c)
#define HWIO_GCC_NPU_TRIG_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0004d00c)
#define HWIO_GCC_NPU_TRIG_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0004d00c)
#define HWIO_GCC_NPU_AT_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004d010)
#define HWIO_GCC_NPU_AT_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0004d010)
#define HWIO_GCC_NPU_AT_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0004d010)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d030)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d030)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d030)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d034)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d034)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d034)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d038)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d038)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d038)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d03c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d03c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d03c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d040)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d040)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d040)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d044)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d044)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d044)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d048)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d048)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d048)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d04c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d04c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d04c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d050)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d050)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d050)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d054)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d054)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d054)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d058)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d058)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d058)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d05c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d05c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d05c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d060)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d060)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d060)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d064)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d064)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d064)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d068)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d068)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d068)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0004d06c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d06c)
#define HWIO_GCC_RPMH_CDSP_NOC_NPU_AXI_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d06c)
#define HWIO_GCC_NPU_AXI_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0004d014)
#define HWIO_GCC_NPU_AXI_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0004d014)
#define HWIO_GCC_NPU_AXI_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0004d014)
#define HWIO_GCC_NPU_AXI_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0004d018)
#define HWIO_GCC_NPU_AXI_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0004d018)
#define HWIO_GCC_NPU_AXI_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0004d018)
#define HWIO_GCC_NPU_AXI_DCD_CDIV_DCDR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0004d140)
#define HWIO_GCC_NPU_AXI_DCD_CDIV_DCDR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0004d140)
#define HWIO_GCC_NPU_AXI_DCD_CDIV_DCDR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0004d140)
#define HWIO_GCC_PLL0_MAIN_DIV_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0004d144)
#define HWIO_GCC_PLL0_MAIN_DIV_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0004d144)
#define HWIO_GCC_PLL0_MAIN_DIV_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0004d144)
#define HWIO_GCC_QUPV3_WRAPPER_2_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001e000)
#define HWIO_GCC_QUPV3_WRAPPER_2_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001e000)
#define HWIO_GCC_QUPV3_WRAPPER_2_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001e000)
#define HWIO_GCC_QUPV3_WRAP_2_M_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e004)
#define HWIO_GCC_QUPV3_WRAP_2_M_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e004)
#define HWIO_GCC_QUPV3_WRAP_2_M_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e004)
#define HWIO_GCC_QUPV3_WRAP_2_S_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e008)
#define HWIO_GCC_QUPV3_WRAP_2_S_AHB_CBCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e008)
#define HWIO_GCC_QUPV3_WRAP_2_S_AHB_CBCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e008)
#define HWIO_GCC_QUPV3_WRAP2_CORE_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0001e00c)
#define HWIO_GCC_QUPV3_WRAP2_CORE_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0001e00c)
#define HWIO_GCC_QUPV3_WRAP2_CORE_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0001e00c)
#define HWIO_GCC_QUPV3_WRAP2_CORE_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0001e010)
#define HWIO_GCC_QUPV3_WRAP2_CORE_CDIVR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e010)
#define HWIO_GCC_QUPV3_WRAP2_CORE_CDIVR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e010)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001e014)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CBCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e014)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CBCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e014)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e03c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e03c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e03c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e044)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e048)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e04c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e04c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e04c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e050)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF8_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF8_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF8_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e054)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF9_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF9_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF9_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e058)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF10_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e05c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF10_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e05c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF10_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e05c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF11_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF11_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF11_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e060)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF12_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF12_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF12_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e064)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF13_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF13_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF13_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e068)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF14_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e06c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF14_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e06c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF14_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e06c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF15_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e070)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF15_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e070)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_QUPV3_WRAP2_CORE_2X_PERF15_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e070)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CMD_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e018)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CMD_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e018)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CMD_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e018)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CFG_RCGR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e01c)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CFG_RCGR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e01c)
#define HWIO_GCC_QUPV3_WRAP2_CORE_2X_CFG_RCGR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e01c)
#define HWIO_GCC_QUPV3_WRAP2_S0_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001e144)
#define HWIO_GCC_QUPV3_WRAP2_S0_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001e144)
#define HWIO_GCC_QUPV3_WRAP2_S0_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001e144)
#define HWIO_GCC_QUPV3_WRAP2_SE0_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001e15c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e15c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e15c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e164)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e164)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e164)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e168)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e168)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e168)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e16c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e16c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e16c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e170)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e170)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e170)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e174)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e174)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e174)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e178)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e178)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e178)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e17c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e17c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e17c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e180)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e180)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e180)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1a4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1a4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1a4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1a8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1a8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1a8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1ac)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1ac)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1ac)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1b0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1b0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1b0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1b4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1b4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1b4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1b8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1b8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1b8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1bc)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1bc)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1bc)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1c0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1c0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1c0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1e4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1e4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1e4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1e8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1e8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1e8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1ec)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1ec)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1ec)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1f0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1f0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1f0)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1f4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1f4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1f4)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1f8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1f8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1f8)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e1fc)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e1fc)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e1fc)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e200)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e200)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e200)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e224)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e224)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e224)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e228)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e228)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e228)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e22c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e22c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e22c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e230)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e230)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e230)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e234)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e234)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e234)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e238)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e238)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e238)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e23c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e23c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e23c)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e240)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e240)
#define HWIO_GCC_QUPV3_WRAP2_SE0_QUPV3_WRAP2_S0_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e240)
#define HWIO_GCC_QUPV3_WRAP2_S0_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e148)
#define HWIO_GCC_QUPV3_WRAP2_S0_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e148)
#define HWIO_GCC_QUPV3_WRAP2_S0_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e148)
#define HWIO_GCC_QUPV3_WRAP2_S0_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e14c)
#define HWIO_GCC_QUPV3_WRAP2_S0_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e14c)
#define HWIO_GCC_QUPV3_WRAP2_S0_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e14c)
#define HWIO_GCC_QUPV3_WRAP2_S0_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e150)
#define HWIO_GCC_QUPV3_WRAP2_S0_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e150)
#define HWIO_GCC_QUPV3_WRAP2_S0_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e150)
#define HWIO_GCC_QUPV3_WRAP2_S0_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e154)
#define HWIO_GCC_QUPV3_WRAP2_S0_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e154)
#define HWIO_GCC_QUPV3_WRAP2_S0_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e154)
#define HWIO_GCC_QUPV3_WRAP2_S0_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e158)
#define HWIO_GCC_QUPV3_WRAP2_S0_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e158)
#define HWIO_GCC_QUPV3_WRAP2_S0_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e158)
#define HWIO_GCC_QUPV3_WRAP2_S1_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001e274)
#define HWIO_GCC_QUPV3_WRAP2_S1_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001e274)
#define HWIO_GCC_QUPV3_WRAP2_S1_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001e274)
#define HWIO_GCC_QUPV3_WRAP2_SE1_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001e28c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e28c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e28c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e294)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e294)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e294)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e298)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e298)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e298)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e29c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e29c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e29c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2a0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2a0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2a0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2a4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2a4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2a4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2a8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2a8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2a8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2ac)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2ac)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2ac)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2b0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2b0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2b0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2d4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2d4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2d4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2d8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2d8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2d8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2dc)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2dc)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2dc)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2e0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2e0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2e0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2e4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2e4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2e4)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2e8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2e8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2e8)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2ec)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2ec)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2ec)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e2f0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e2f0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e2f0)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e314)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e314)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e314)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e318)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e318)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e318)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e31c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e31c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e31c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e320)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e320)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e320)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e324)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e324)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e324)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e328)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e328)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e328)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e32c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e32c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e32c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e330)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e330)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e330)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e354)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e354)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e354)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e358)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e358)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e358)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e35c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e35c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e35c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e360)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e360)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e360)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e364)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e364)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e364)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e368)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e368)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e368)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e36c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e36c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e36c)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e370)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e370)
#define HWIO_GCC_QUPV3_WRAP2_SE1_QUPV3_WRAP2_S1_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e370)
#define HWIO_GCC_QUPV3_WRAP2_S1_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e278)
#define HWIO_GCC_QUPV3_WRAP2_S1_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e278)
#define HWIO_GCC_QUPV3_WRAP2_S1_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e278)
#define HWIO_GCC_QUPV3_WRAP2_S1_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e27c)
#define HWIO_GCC_QUPV3_WRAP2_S1_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e27c)
#define HWIO_GCC_QUPV3_WRAP2_S1_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e27c)
#define HWIO_GCC_QUPV3_WRAP2_S1_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e280)
#define HWIO_GCC_QUPV3_WRAP2_S1_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e280)
#define HWIO_GCC_QUPV3_WRAP2_S1_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e280)
#define HWIO_GCC_QUPV3_WRAP2_S1_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e284)
#define HWIO_GCC_QUPV3_WRAP2_S1_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e284)
#define HWIO_GCC_QUPV3_WRAP2_S1_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e284)
#define HWIO_GCC_QUPV3_WRAP2_S1_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e288)
#define HWIO_GCC_QUPV3_WRAP2_S1_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e288)
#define HWIO_GCC_QUPV3_WRAP2_S1_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e288)
#define HWIO_GCC_QUPV3_WRAP2_S2_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001e3a4)
#define HWIO_GCC_QUPV3_WRAP2_S2_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001e3a4)
#define HWIO_GCC_QUPV3_WRAP2_S2_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001e3a4)
#define HWIO_GCC_QUPV3_WRAP2_SE2_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001e3bc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3bc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3bc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3c4)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3c4)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3c4)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3c8)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3c8)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3c8)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3cc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3cc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3cc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3d0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3d0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3d0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3d4)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3d4)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3d4)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3d8)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3d8)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3d8)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3dc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3dc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3dc)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e3e0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3e0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3e0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e404)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e404)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e404)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e408)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e408)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e408)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e40c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e40c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e40c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e410)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e410)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e410)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e414)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e414)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e414)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e418)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e418)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e418)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e41c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e41c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e41c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e420)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e420)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e420)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e444)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e444)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e444)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e448)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e448)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e448)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e44c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e44c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e44c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e450)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e450)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e450)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e454)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e454)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e454)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e458)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e458)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e458)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e45c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e45c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e45c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e460)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e460)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e460)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e484)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e484)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e484)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e488)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e488)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e488)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e48c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e48c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e48c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e490)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e490)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e490)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e494)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e494)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e494)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e498)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e498)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e498)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e49c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e49c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e49c)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e4a0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e4a0)
#define HWIO_GCC_QUPV3_WRAP2_SE2_QUPV3_WRAP2_S2_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e4a0)
#define HWIO_GCC_QUPV3_WRAP2_S2_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e3a8)
#define HWIO_GCC_QUPV3_WRAP2_S2_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3a8)
#define HWIO_GCC_QUPV3_WRAP2_S2_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3a8)
#define HWIO_GCC_QUPV3_WRAP2_S2_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e3ac)
#define HWIO_GCC_QUPV3_WRAP2_S2_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e3ac)
#define HWIO_GCC_QUPV3_WRAP2_S2_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e3ac)
#define HWIO_GCC_QUPV3_WRAP2_S2_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e3b0)
#define HWIO_GCC_QUPV3_WRAP2_S2_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e3b0)
#define HWIO_GCC_QUPV3_WRAP2_S2_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e3b0)
#define HWIO_GCC_QUPV3_WRAP2_S2_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e3b4)
#define HWIO_GCC_QUPV3_WRAP2_S2_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e3b4)
#define HWIO_GCC_QUPV3_WRAP2_S2_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e3b4)
#define HWIO_GCC_QUPV3_WRAP2_S2_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e3b8)
#define HWIO_GCC_QUPV3_WRAP2_S2_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e3b8)
#define HWIO_GCC_QUPV3_WRAP2_S2_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e3b8)
#define HWIO_GCC_QUPV3_WRAP2_S3_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001e4d4)
#define HWIO_GCC_QUPV3_WRAP2_S3_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001e4d4)
#define HWIO_GCC_QUPV3_WRAP2_S3_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001e4d4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001e4ec)
#define HWIO_GCC_QUPV3_WRAP2_SE3_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e4ec)
#define HWIO_GCC_QUPV3_WRAP2_SE3_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e4ec)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e4f4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e4f4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e4f4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e4f8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e4f8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e4f8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e4fc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e4fc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e4fc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e500)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e500)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e500)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e504)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e504)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e504)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e508)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e508)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e508)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e50c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e50c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e50c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e510)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e510)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e510)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e534)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e534)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e534)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e538)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e538)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e538)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e53c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e53c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e53c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e540)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e540)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e540)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e544)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e544)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e544)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e548)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e548)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e548)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e54c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e54c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e54c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e550)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e550)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e550)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e574)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e574)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e574)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e578)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e578)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e578)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e57c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e57c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e57c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e580)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e580)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e580)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e584)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e584)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e584)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e588)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e588)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e588)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e58c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e58c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e58c)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e590)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e590)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e590)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5b4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5b4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5b4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5b8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5b8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5b8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5bc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5bc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5bc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5c0)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5c0)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5c0)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5c4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5c4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5c4)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5c8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5c8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5c8)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5cc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5cc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5cc)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e5d0)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e5d0)
#define HWIO_GCC_QUPV3_WRAP2_SE3_QUPV3_WRAP2_S3_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e5d0)
#define HWIO_GCC_QUPV3_WRAP2_S3_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e4d8)
#define HWIO_GCC_QUPV3_WRAP2_S3_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e4d8)
#define HWIO_GCC_QUPV3_WRAP2_S3_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e4d8)
#define HWIO_GCC_QUPV3_WRAP2_S3_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e4dc)
#define HWIO_GCC_QUPV3_WRAP2_S3_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e4dc)
#define HWIO_GCC_QUPV3_WRAP2_S3_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e4dc)
#define HWIO_GCC_QUPV3_WRAP2_S3_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e4e0)
#define HWIO_GCC_QUPV3_WRAP2_S3_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e4e0)
#define HWIO_GCC_QUPV3_WRAP2_S3_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e4e0)
#define HWIO_GCC_QUPV3_WRAP2_S3_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e4e4)
#define HWIO_GCC_QUPV3_WRAP2_S3_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e4e4)
#define HWIO_GCC_QUPV3_WRAP2_S3_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e4e4)
#define HWIO_GCC_QUPV3_WRAP2_S3_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e4e8)
#define HWIO_GCC_QUPV3_WRAP2_S3_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e4e8)
#define HWIO_GCC_QUPV3_WRAP2_S3_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e4e8)
#define HWIO_GCC_QUPV3_WRAP2_S4_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001e604)
#define HWIO_GCC_QUPV3_WRAP2_S4_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001e604)
#define HWIO_GCC_QUPV3_WRAP2_S4_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001e604)
#define HWIO_GCC_QUPV3_WRAP2_SE4_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001e61c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e61c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e61c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e624)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e624)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e624)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e628)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e628)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e628)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e62c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e62c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e62c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e630)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e630)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e630)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e634)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e634)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e634)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e638)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e638)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e638)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e63c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e63c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e63c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e640)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e640)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e640)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e664)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e664)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e664)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e668)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e668)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e668)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e66c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e66c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e66c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e670)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e670)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e670)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e674)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e674)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e674)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e678)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e678)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e678)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e67c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e67c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e67c)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e680)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e680)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e680)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6a4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6a4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6a4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6a8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6a8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6a8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6ac)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6ac)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6ac)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6b0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6b0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6b0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6b4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6b4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6b4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6b8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6b8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6b8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6bc)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6bc)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6bc)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6c0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6c0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6c0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6e4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6e4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6e4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6e8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6e8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6e8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6ec)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6ec)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6ec)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6f0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6f0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6f0)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6f4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6f4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6f4)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6f8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6f8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6f8)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e6fc)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e6fc)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e6fc)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e700)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e700)
#define HWIO_GCC_QUPV3_WRAP2_SE4_QUPV3_WRAP2_S4_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e700)
#define HWIO_GCC_QUPV3_WRAP2_S4_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e608)
#define HWIO_GCC_QUPV3_WRAP2_S4_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e608)
#define HWIO_GCC_QUPV3_WRAP2_S4_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e608)
#define HWIO_GCC_QUPV3_WRAP2_S4_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e60c)
#define HWIO_GCC_QUPV3_WRAP2_S4_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e60c)
#define HWIO_GCC_QUPV3_WRAP2_S4_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e60c)
#define HWIO_GCC_QUPV3_WRAP2_S4_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e610)
#define HWIO_GCC_QUPV3_WRAP2_S4_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e610)
#define HWIO_GCC_QUPV3_WRAP2_S4_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e610)
#define HWIO_GCC_QUPV3_WRAP2_S4_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e614)
#define HWIO_GCC_QUPV3_WRAP2_S4_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e614)
#define HWIO_GCC_QUPV3_WRAP2_S4_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e614)
#define HWIO_GCC_QUPV3_WRAP2_S4_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e618)
#define HWIO_GCC_QUPV3_WRAP2_S4_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e618)
#define HWIO_GCC_QUPV3_WRAP2_S4_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e618)
#define HWIO_GCC_QUPV3_WRAP2_S5_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0001e734)
#define HWIO_GCC_QUPV3_WRAP2_S5_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0001e734)
#define HWIO_GCC_QUPV3_WRAP2_S5_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0001e734)
#define HWIO_GCC_QUPV3_WRAP2_SE5_CMD_DFSR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0001e74c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_CMD_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e74c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_CMD_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e74c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e754)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e754)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e754)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e758)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e758)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e758)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e75c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e75c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e75c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e760)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e760)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e760)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e764)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e764)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e764)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e768)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e768)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e768)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e76c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e76c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e76c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e770)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e770)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e770)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e794)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e794)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e794)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e798)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e798)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e798)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e79c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e79c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e79c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7a0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7a0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7a0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7a4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7a4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7a4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7a8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7a8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7a8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7ac)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7ac)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7ac)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_M_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7b0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_M_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7b0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_M_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7b0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7d4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7d4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7d4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7d8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7d8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7d8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7dc)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7dc)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7dc)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7e0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7e0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7e0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7e4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7e4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7e4)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7e8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7e8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7e8)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7ec)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7ec)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7ec)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_N_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e7f0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_N_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e7f0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_N_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e7f0)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e814)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e814)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF0_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e814)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e818)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e818)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF1_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e818)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e81c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e81c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF2_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e81c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e820)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e820)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF3_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e820)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e824)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e824)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF4_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e824)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e828)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e828)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF5_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e828)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e82c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e82c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF6_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e82c)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_D_DFSR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001e830)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_D_DFSR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e830)
#define HWIO_GCC_QUPV3_WRAP2_SE5_QUPV3_WRAP2_S5_PERF7_D_DFSR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e830)
#define HWIO_GCC_QUPV3_WRAP2_S5_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e738)
#define HWIO_GCC_QUPV3_WRAP2_S5_CMD_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e738)
#define HWIO_GCC_QUPV3_WRAP2_S5_CMD_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e738)
#define HWIO_GCC_QUPV3_WRAP2_S5_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0001e73c)
#define HWIO_GCC_QUPV3_WRAP2_S5_CFG_RCGR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001e73c)
#define HWIO_GCC_QUPV3_WRAP2_S5_CFG_RCGR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001e73c)
#define HWIO_GCC_QUPV3_WRAP2_S5_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e740)
#define HWIO_GCC_QUPV3_WRAP2_S5_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e740)
#define HWIO_GCC_QUPV3_WRAP2_S5_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e740)
#define HWIO_GCC_QUPV3_WRAP2_S5_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e744)
#define HWIO_GCC_QUPV3_WRAP2_S5_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e744)
#define HWIO_GCC_QUPV3_WRAP2_S5_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e744)
#define HWIO_GCC_QUPV3_WRAP2_S5_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0001e748)
#define HWIO_GCC_QUPV3_WRAP2_S5_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0001e748)
#define HWIO_GCC_QUPV3_WRAP2_S5_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0001e748)
#define HWIO_GCC_RBCPR_MMCX_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0000d000)
#define HWIO_GCC_RBCPR_MMCX_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0000d000)
#define HWIO_GCC_RBCPR_MMCX_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0000d000)
#define HWIO_GCC_RBCPR_MMCX_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0000d004)
#define HWIO_GCC_RBCPR_MMCX_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0000d004)
#define HWIO_GCC_RBCPR_MMCX_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0000d004)
#define HWIO_GCC_RBCPR_MMCX_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000d008)
#define HWIO_GCC_RBCPR_MMCX_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000d008)
#define HWIO_GCC_RBCPR_MMCX_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000d008)
#define HWIO_GCC_RBCPR_MMCX_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000d00c)
#define HWIO_GCC_RBCPR_MMCX_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000d00c)
#define HWIO_GCC_RBCPR_MMCX_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000d00c)
#define HWIO_GCC_RBCPR_MMCX_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000d010)
#define HWIO_GCC_RBCPR_MMCX_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000d010)
#define HWIO_GCC_RBCPR_MMCX_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000d010)
#define HWIO_GCC_EMAC_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006000)
#define HWIO_GCC_EMAC_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00006000)
#define HWIO_GCC_EMAC_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00006000)
#define HWIO_GCC_EMAC_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006004)
#define HWIO_GCC_EMAC_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00006004)
#define HWIO_GCC_EMAC_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00006004)
#define HWIO_GCC_EMAC_CFG_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00006008)
#define HWIO_GCC_EMAC_CFG_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00006008)
#define HWIO_GCC_EMAC_CFG_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00006008)
#define HWIO_GCC_EMAC_CFG2_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0000600c)
#define HWIO_GCC_EMAC_CFG2_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0000600c)
#define HWIO_GCC_EMAC_CFG2_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0000600c)
#define HWIO_GCC_EMAC_AXI_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006010)
#define HWIO_GCC_EMAC_AXI_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00006010)
#define HWIO_GCC_EMAC_AXI_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00006010)
#define HWIO_GCC_EMAC_SLV_AHB_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00006014)
#define HWIO_GCC_EMAC_SLV_AHB_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00006014)
#define HWIO_GCC_EMAC_SLV_AHB_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00006014)
#define HWIO_GCC_EMAC_RGMII_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00006018)
#define HWIO_GCC_EMAC_RGMII_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00006018)
#define HWIO_GCC_EMAC_RGMII_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00006018)
#define HWIO_GCC_EMAC_RGMII_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0000601c)
#define HWIO_GCC_EMAC_RGMII_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0000601c)
#define HWIO_GCC_EMAC_RGMII_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0000601c)
#define HWIO_GCC_EMAC_RGMII_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00006020)
#define HWIO_GCC_EMAC_RGMII_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00006020)
#define HWIO_GCC_EMAC_RGMII_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00006020)
#define HWIO_GCC_EMAC_RGMII_M_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006024)
#define HWIO_GCC_EMAC_RGMII_M_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00006024)
#define HWIO_GCC_EMAC_RGMII_M_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00006024)
#define HWIO_GCC_EMAC_RGMII_N_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006028)
#define HWIO_GCC_EMAC_RGMII_N_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00006028)
#define HWIO_GCC_EMAC_RGMII_N_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00006028)
#define HWIO_GCC_EMAC_RGMII_D_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0000602c)
#define HWIO_GCC_EMAC_RGMII_D_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0000602c)
#define HWIO_GCC_EMAC_RGMII_D_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0000602c)
#define HWIO_GCC_EMAC_PTP_CBCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006034)
#define HWIO_GCC_EMAC_PTP_CBCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00006034)
#define HWIO_GCC_EMAC_PTP_CBCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00006034)
#define HWIO_GCC_EMAC_PTP_CMD_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00006038)
#define HWIO_GCC_EMAC_PTP_CMD_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00006038)
#define HWIO_GCC_EMAC_PTP_CMD_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00006038)
#define HWIO_GCC_EMAC_PTP_CFG_RCGR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000603c)
#define HWIO_GCC_EMAC_PTP_CFG_RCGR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000603c)
#define HWIO_GCC_EMAC_PTP_CFG_RCGR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000603c)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP1_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000ff8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP1_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000ff8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP1_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000ff8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP2_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000ff4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP2_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000ff4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP2_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000ff4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP3_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000ff0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP3_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000ff0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP3_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000ff0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP4_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fec)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP4_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fec)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP4_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fec)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP5_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fe8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP5_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fe8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP5_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fe8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP6_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fe4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP6_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fe4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP6_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fe4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP7_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fe0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP7_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fe0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP7_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fe0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP8_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fdc)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP8_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fdc)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP8_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fdc)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP9_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fd8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP9_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fd8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP9_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fd8)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP10_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fd4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP10_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fd4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP10_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fd4)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP11_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fd0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP11_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fd0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP11_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fd0)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP12_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fcc)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP12_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fcc)
#define HWIO_GCC_GPLL0_OUT_MAIN_PWRGRP12_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fcc)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP13_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fc8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP13_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fc8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP13_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fc8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP14_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fc4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP14_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fc4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP14_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fc4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP15_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fc0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP15_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fc0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP15_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fc0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP16_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fbc)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP16_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fbc)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP16_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fbc)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP17_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fb8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP17_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fb8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP17_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fb8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP18_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fb4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP18_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fb4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP18_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fb4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP19_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fb0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP19_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fb0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP19_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fb0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP20_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fac)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP20_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fac)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP20_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fac)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP21_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fa8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP21_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fa8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP21_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fa8)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP22_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fa4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP22_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fa4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP22_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fa4)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP23_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000fa0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP23_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000fa0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP23_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000fa0)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP24_CLKGEN_ACGC_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000f9c)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP24_CLKGEN_ACGC_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000f9c)
#define HWIO_GCC_GPLL0_OUT_EVEN_PWRGRP24_CLKGEN_ACGC_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000f9c)
#define HWIO_GCC_TZ_IPA_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003b000)
#define HWIO_GCC_TZ_IPA_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0003b000)
#define HWIO_GCC_TZ_IPA_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0003b000)
#define HWIO_GCC_TZ_UFS_CARD_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003b004)
#define HWIO_GCC_TZ_UFS_CARD_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003b004)
#define HWIO_GCC_TZ_UFS_CARD_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003b004)
#define HWIO_GCC_TZ_EMAC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0003b008)
#define HWIO_GCC_TZ_EMAC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0003b008)
#define HWIO_GCC_TZ_EMAC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0003b008)
#define HWIO_GCC_TZ_USB30_PRIM_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0003b00c)
#define HWIO_GCC_TZ_USB30_PRIM_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0003b00c)
#define HWIO_GCC_TZ_USB30_PRIM_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0003b00c)
#define HWIO_GCC_TZ_UFS_PHY_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003b010)
#define HWIO_GCC_TZ_UFS_PHY_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003b010)
#define HWIO_GCC_TZ_UFS_PHY_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003b010)
#define HWIO_GCC_TZ_ANOC_TBU_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003b014)
#define HWIO_GCC_TZ_ANOC_TBU_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003b014)
#define HWIO_GCC_TZ_ANOC_TBU_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003b014)
#define HWIO_GCC_TZ_PCIE_0_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0003b018)
#define HWIO_GCC_TZ_PCIE_0_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0003b018)
#define HWIO_GCC_TZ_PCIE_0_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0003b018)
#define HWIO_GCC_TZ_PCIE_1_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0003b01c)
#define HWIO_GCC_TZ_PCIE_1_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0003b01c)
#define HWIO_GCC_TZ_PCIE_1_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0003b01c)
#define HWIO_GCC_TZ_USB30_SEC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0003b020)
#define HWIO_GCC_TZ_USB30_SEC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0003b020)
#define HWIO_GCC_TZ_USB30_SEC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0003b020)
#define HWIO_GCC_TZ_MMNOC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0003b024)
#define HWIO_GCC_TZ_MMNOC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0003b024)
#define HWIO_GCC_TZ_MMNOC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0003b024)
#define HWIO_GCC_MSS_IPA_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0003e000)
#define HWIO_GCC_MSS_IPA_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0003e000)
#define HWIO_GCC_MSS_IPA_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0003e000)
#define HWIO_GCC_MSS_UFS_CARD_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0003e004)
#define HWIO_GCC_MSS_UFS_CARD_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0003e004)
#define HWIO_GCC_MSS_UFS_CARD_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0003e004)
#define HWIO_GCC_MSS_EMAC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0003e008)
#define HWIO_GCC_MSS_EMAC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0003e008)
#define HWIO_GCC_MSS_EMAC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0003e008)
#define HWIO_GCC_MSS_USB30_PRIM_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0003e00c)
#define HWIO_GCC_MSS_USB30_PRIM_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0003e00c)
#define HWIO_GCC_MSS_USB30_PRIM_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0003e00c)
#define HWIO_GCC_MSS_UFS_PHY_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003e010)
#define HWIO_GCC_MSS_UFS_PHY_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003e010)
#define HWIO_GCC_MSS_UFS_PHY_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003e010)
#define HWIO_GCC_MSS_ANOC_TBU_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0003e014)
#define HWIO_GCC_MSS_ANOC_TBU_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0003e014)
#define HWIO_GCC_MSS_ANOC_TBU_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0003e014)
#define HWIO_GCC_MSS_PCIE_0_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003e018)
#define HWIO_GCC_MSS_PCIE_0_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003e018)
#define HWIO_GCC_MSS_PCIE_0_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003e018)
#define HWIO_GCC_MSS_PCIE_1_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003e01c)
#define HWIO_GCC_MSS_PCIE_1_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003e01c)
#define HWIO_GCC_MSS_PCIE_1_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003e01c)
#define HWIO_GCC_MSS_USB30_SEC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0003e020)
#define HWIO_GCC_MSS_USB30_SEC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0003e020)
#define HWIO_GCC_MSS_USB30_SEC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0003e020)
#define HWIO_GCC_MSS_MMNOC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0003e024)
#define HWIO_GCC_MSS_MMNOC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0003e024)
#define HWIO_GCC_MSS_MMNOC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0003e024)
#define HWIO_GCC_SP_IPA_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003f000)
#define HWIO_GCC_SP_IPA_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0003f000)
#define HWIO_GCC_SP_IPA_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0003f000)
#define HWIO_GCC_SP_UFS_CARD_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003f004)
#define HWIO_GCC_SP_UFS_CARD_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003f004)
#define HWIO_GCC_SP_UFS_CARD_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003f004)
#define HWIO_GCC_SP_EMAC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0003f008)
#define HWIO_GCC_SP_EMAC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0003f008)
#define HWIO_GCC_SP_EMAC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0003f008)
#define HWIO_GCC_SP_USB30_PRIM_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0003f00c)
#define HWIO_GCC_SP_USB30_PRIM_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0003f00c)
#define HWIO_GCC_SP_USB30_PRIM_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0003f00c)
#define HWIO_GCC_SP_UFS_PHY_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0003f010)
#define HWIO_GCC_SP_UFS_PHY_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0003f010)
#define HWIO_GCC_SP_UFS_PHY_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0003f010)
#define HWIO_GCC_SP_ANOC_TBU_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0003f014)
#define HWIO_GCC_SP_ANOC_TBU_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0003f014)
#define HWIO_GCC_SP_ANOC_TBU_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0003f014)
#define HWIO_GCC_SP_PCIE_0_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0003f018)
#define HWIO_GCC_SP_PCIE_0_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0003f018)
#define HWIO_GCC_SP_PCIE_0_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0003f018)
#define HWIO_GCC_SP_PCIE_1_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0003f01c)
#define HWIO_GCC_SP_PCIE_1_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0003f01c)
#define HWIO_GCC_SP_PCIE_1_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0003f01c)
#define HWIO_GCC_SP_USB30_SEC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0003f020)
#define HWIO_GCC_SP_USB30_SEC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0003f020)
#define HWIO_GCC_SP_USB30_SEC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0003f020)
#define HWIO_GCC_SP_MMNOC_SGDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0003f024)
#define HWIO_GCC_SP_MMNOC_SGDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0003f024)
#define HWIO_GCC_SP_MMNOC_SGDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0003f024)
#define HWIO_GCC_GPLL0_UFS_CARD_TX_SYMBOL_0_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00075038)
#define HWIO_GCC_GPLL0_UFS_CARD_TX_SYMBOL_0_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075038)
#define HWIO_GCC_GPLL0_UFS_CARD_TX_SYMBOL_0_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075038)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_0_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00075048)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_0_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075048)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_0_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075048)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_1_ACGCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000750b0)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_1_ACGCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000750b0)
#define HWIO_GCC_GPLL0_UFS_CARD_RX_SYMBOL_1_ACGCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000750b0)
#define HWIO_GCC_GPLL0_UFS_PHY_TX_SYMBOL_0_ACGCR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00077038)
#define HWIO_GCC_GPLL0_UFS_PHY_TX_SYMBOL_0_ACGCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077038)
#define HWIO_GCC_GPLL0_UFS_PHY_TX_SYMBOL_0_ACGCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077038)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_0_ACGCR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00077048)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_0_ACGCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077048)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_0_ACGCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077048)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_1_ACGCR_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x000770b0)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_1_ACGCR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000770b0)
#define HWIO_GCC_GPLL0_UFS_PHY_RX_SYMBOL_1_ACGCR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000770b0)
#define HWIO_GCC_USB3_PRIM_PHY_PIPE_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0000f05c)
#define HWIO_GCC_USB3_PRIM_PHY_PIPE_MUXR_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000f05c)
#define HWIO_GCC_USB3_PRIM_PHY_PIPE_MUXR_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000f05c)
#define HWIO_GCC_USB3_SEC_PHY_PIPE_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0001005c)
#define HWIO_GCC_USB3_SEC_PHY_PIPE_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001005c)
#define HWIO_GCC_USB3_SEC_PHY_PIPE_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001005c)
#define HWIO_GCC_PCIE_0_PIPE_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0006b028)
#define HWIO_GCC_PCIE_0_PIPE_MUXR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0006b028)
#define HWIO_GCC_PCIE_0_PIPE_MUXR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0006b028)
#define HWIO_GCC_PCIE_1_PIPE_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0008d028)
#define HWIO_GCC_PCIE_1_PIPE_MUXR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0008d028)
#define HWIO_GCC_PCIE_1_PIPE_MUXR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0008d028)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_TX_SYMBOL_0_MUX_MUXR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00075040)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_TX_SYMBOL_0_MUX_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075040)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_TX_SYMBOL_0_MUX_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075040)
#define HWIO_GCC_UFS_CARD_TX_SYMBOL_0_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00075044)
#define HWIO_GCC_UFS_CARD_TX_SYMBOL_0_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075044)
#define HWIO_GCC_UFS_CARD_TX_SYMBOL_0_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075044)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_RX_SYMBOL_0_MUX_MUXR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00075050)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_RX_SYMBOL_0_MUX_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075050)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_RX_SYMBOL_0_MUX_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075050)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_0_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00075054)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_0_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00075054)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_0_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00075054)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_RX_SYMBOL_1_MUX_MUXR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000750b8)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_RX_SYMBOL_1_MUX_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000750b8)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_CARD_RX_SYMBOL_1_MUX_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000750b8)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_1_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x000750bc)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_1_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000750bc)
#define HWIO_GCC_UFS_CARD_RX_SYMBOL_1_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000750bc)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_TX_SYMBOL_0_MUX_MUXR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00077040)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_TX_SYMBOL_0_MUX_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077040)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_TX_SYMBOL_0_MUX_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077040)
#define HWIO_GCC_UFS_PHY_TX_SYMBOL_0_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00077044)
#define HWIO_GCC_UFS_PHY_TX_SYMBOL_0_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077044)
#define HWIO_GCC_UFS_PHY_TX_SYMBOL_0_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077044)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_RX_SYMBOL_0_MUX_MUXR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00077050)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_RX_SYMBOL_0_MUX_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077050)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_RX_SYMBOL_0_MUX_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077050)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_0_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00077054)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_0_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00077054)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_0_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00077054)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_RX_SYMBOL_1_MUX_MUXR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x000770b8)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_RX_SYMBOL_1_MUX_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000770b8)
#define HWIO_GCC_GPLL0_AND_PLL_TEST_SE_UFS_PHY_RX_SYMBOL_1_MUX_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000770b8)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_1_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x000770bc)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_1_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x000770bc)
#define HWIO_GCC_UFS_PHY_RX_SYMBOL_1_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x000770bc)
#define HWIO_GCC_MSS_Q6SS_BOOT_GPLL0_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0008a148)
#define HWIO_GCC_MSS_Q6SS_BOOT_GPLL0_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a148)
#define HWIO_GCC_MSS_Q6SS_BOOT_GPLL0_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a148)
#define HWIO_GCC_ACC_MISC_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0003e030)
#define HWIO_GCC_ACC_MISC_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0003e030)
#define HWIO_GCC_ACC_MISC_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0003e030)
#define HWIO_GCC_CPUSS_AHB_MISC_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00048024)
#define HWIO_GCC_CPUSS_AHB_MISC_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00048024)
#define HWIO_GCC_CPUSS_AHB_MISC_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00048024)
#define HWIO_GCC_SSC_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00054000)
#define HWIO_GCC_SSC_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00054000)
#define HWIO_GCC_SSC_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00054000)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00054004)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00054004)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00054004)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00054008)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00054008)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00054008)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005400c)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005400c)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005400c)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_1_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00054010)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00054010)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00054010)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00054014)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00054014)
#define HWIO_GCC_SSC_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00054014)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_2_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00054018)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00054018)
#define HWIO_GCC_SSC_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00054018)
#define HWIO_GCC_RPM_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00051000)
#define HWIO_GCC_RPM_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00051000)
#define HWIO_GCC_RPM_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00051000)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00051004)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00051004)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00051004)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00051008)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00051008)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00051008)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005100c)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005100c)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005100c)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_1_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00051010)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00051010)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00051010)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00051014)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00051014)
#define HWIO_GCC_RPM_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00051014)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_2_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00051018)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00051018)
#define HWIO_GCC_RPM_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00051018)
#define HWIO_GCC_APCS_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00052000)
#define HWIO_GCC_APCS_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00052000)
#define HWIO_GCC_APCS_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00052000)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00052004)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00052004)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00052004)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00052008)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00052008)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00052008)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005200c)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005200c)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005200c)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00052010)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00052010)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00052010)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00052014)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00052014)
#define HWIO_GCC_APCS_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00052014)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00052018)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00052018)
#define HWIO_GCC_APCS_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00052018)
#define HWIO_GCC_APCS_TZ_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00053000)
#define HWIO_GCC_APCS_TZ_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00053000)
#define HWIO_GCC_APCS_TZ_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00053000)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00053004)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00053004)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00053004)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00053008)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00053008)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00053008)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_1_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0005300c)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_1_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005300c)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_1_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005300c)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00053010)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00053010)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00053010)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_2_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00053014)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_2_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00053014)
#define HWIO_GCC_APCS_TZ_CLOCK_BRANCH_ENA_VOTE_2_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00053014)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00053018)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00053018)
#define HWIO_GCC_APCS_TZ_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00053018)
#define HWIO_GCC_LPASS_DSP_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00055000)
#define HWIO_GCC_LPASS_DSP_GPLL_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00055000)
#define HWIO_GCC_LPASS_DSP_GPLL_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00055000)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00055004)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00055004)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00055004)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00055008)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00055008)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00055008)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005500c)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005500c)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005500c)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00055010)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00055010)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00055010)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00055014)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00055014)
#define HWIO_GCC_LPASS_DSP_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00055014)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00055018)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00055018)
#define HWIO_GCC_LPASS_DSP_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00055018)
#define HWIO_GCC_HYP_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00056000)
#define HWIO_GCC_HYP_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00056000)
#define HWIO_GCC_HYP_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00056000)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00056004)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00056004)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00056004)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00056008)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00056008)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00056008)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005600c)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005600c)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005600c)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_1_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00056010)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00056010)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00056010)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00056014)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00056014)
#define HWIO_GCC_HYP_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00056014)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_2_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00056018)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00056018)
#define HWIO_GCC_HYP_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00056018)
#define HWIO_GCC_SPARE_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00057000)
#define HWIO_GCC_SPARE_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00057000)
#define HWIO_GCC_SPARE_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00057000)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00057004)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00057004)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00057004)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00057008)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00057008)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00057008)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005700c)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005700c)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005700c)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00057010)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00057010)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00057010)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00057014)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00057014)
#define HWIO_GCC_SPARE_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00057014)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00057018)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00057018)
#define HWIO_GCC_SPARE_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00057018)
#define HWIO_GCC_SPARE1_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0005a000)
#define HWIO_GCC_SPARE1_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0005a000)
#define HWIO_GCC_SPARE1_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0005a000)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005a004)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005a004)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005a004)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005a008)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005a008)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005a008)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005a00c)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005a00c)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005a00c)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005a010)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005a010)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005a010)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005a014)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005a014)
#define HWIO_GCC_SPARE1_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005a014)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005a018)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005a018)
#define HWIO_GCC_SPARE1_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005a018)
#define HWIO_GCC_TURING_DSP_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0005b000)
#define HWIO_GCC_TURING_DSP_GPLL_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005b000)
#define HWIO_GCC_TURING_DSP_GPLL_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005b000)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005b004)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005b004)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005b004)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0005b008)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005b008)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005b008)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005b00c)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005b00c)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005b00c)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005b010)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005b010)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005b010)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005b014)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005b014)
#define HWIO_GCC_TURING_DSP_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005b014)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0005b018)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005b018)
#define HWIO_GCC_TURING_DSP_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005b018)
#define HWIO_GCC_SPARE2_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00069000)
#define HWIO_GCC_SPARE2_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00069000)
#define HWIO_GCC_SPARE2_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00069000)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00069004)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00069004)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00069004)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00069008)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00069008)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00069008)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0006900c)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006900c)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006900c)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00069010)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00069010)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00069010)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00069014)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00069014)
#define HWIO_GCC_SPARE2_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00069014)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00069018)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00069018)
#define HWIO_GCC_SPARE2_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00069018)
#define HWIO_GCC_MSS_Q6_GPLL_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00035000)
#define HWIO_GCC_MSS_Q6_GPLL_ENA_VOTE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00035000)
#define HWIO_GCC_MSS_Q6_GPLL_ENA_VOTE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00035000)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00035004)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00035004)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00035004)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00035008)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00035008)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00035008)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0003500c)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0003500c)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0003500c)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_1_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00035010)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_1_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00035010)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_1_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00035010)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00035014)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00035014)
#define HWIO_GCC_MSS_Q6_CLOCK_BRANCH_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00035014)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_2_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00035018)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_2_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00035018)
#define HWIO_GCC_MSS_Q6_CLOCK_SLEEP_ENA_VOTE_2_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00035018)
#define HWIO_GCC_PCIE_0_LINK_DOWN_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0006c014)
#define HWIO_GCC_PCIE_0_LINK_DOWN_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0006c014)
#define HWIO_GCC_PCIE_0_LINK_DOWN_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0006c014)
#define HWIO_GCC_PCIE_0_MISC_RESET_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0006c018)
#define HWIO_GCC_PCIE_0_MISC_RESET_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0006c018)
#define HWIO_GCC_PCIE_0_MISC_RESET_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0006c018)
#define HWIO_GCC_PCIE_0_PHY_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0006c01c)
#define HWIO_GCC_PCIE_0_PHY_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0006c01c)
#define HWIO_GCC_PCIE_0_PHY_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0006c01c)
#define HWIO_GCC_PCIE_0_NOCSR_COM_PHY_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0006c020)
#define HWIO_GCC_PCIE_0_NOCSR_COM_PHY_BCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006c020)
#define HWIO_GCC_PCIE_0_NOCSR_COM_PHY_BCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006c020)
#define HWIO_GCC_PCIE_0_PHY_NOCSR_COM_PHY_BCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0006c028)
#define HWIO_GCC_PCIE_0_PHY_NOCSR_COM_PHY_BCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006c028)
#define HWIO_GCC_PCIE_0_PHY_NOCSR_COM_PHY_BCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006c028)
#define HWIO_GCC_PCIE_PHY_CFG_AHB_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0006f00c)
#define HWIO_GCC_PCIE_PHY_CFG_AHB_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0006f00c)
#define HWIO_GCC_PCIE_PHY_CFG_AHB_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0006f00c)
#define HWIO_GCC_PCIE_PHY_COM_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0006f010)
#define HWIO_GCC_PCIE_PHY_COM_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0006f010)
#define HWIO_GCC_PCIE_PHY_COM_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0006f010)
#define HWIO_GCC_PCIE_1_LINK_DOWN_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0008e014)
#define HWIO_GCC_PCIE_1_LINK_DOWN_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0008e014)
#define HWIO_GCC_PCIE_1_LINK_DOWN_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0008e014)
#define HWIO_GCC_PCIE_1_MISC_RESET_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0008e018)
#define HWIO_GCC_PCIE_1_MISC_RESET_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0008e018)
#define HWIO_GCC_PCIE_1_MISC_RESET_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0008e018)
#define HWIO_GCC_PCIE_1_PHY_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x0008e01c)
#define HWIO_GCC_PCIE_1_PHY_BCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x0008e01c)
#define HWIO_GCC_PCIE_1_PHY_BCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x0008e01c)
#define HWIO_GCC_PCIE_1_NOCSR_COM_PHY_BCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0008e020)
#define HWIO_GCC_PCIE_1_NOCSR_COM_PHY_BCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008e020)
#define HWIO_GCC_PCIE_1_NOCSR_COM_PHY_BCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008e020)
#define HWIO_GCC_PCIE_1_PHY_NOCSR_COM_PHY_BCR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008e000)
#define HWIO_GCC_PCIE_1_PHY_NOCSR_COM_PHY_BCR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008e000)
#define HWIO_GCC_PCIE_1_PHY_NOCSR_COM_PHY_BCR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008e000)
#define HWIO_GCC_SSC_RESET_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00063020)
#define HWIO_GCC_SSC_RESET_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00063020)
#define HWIO_GCC_SSC_RESET_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00063020)
#define HWIO_GCC_DEBUG_MUX_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00062000)
#define HWIO_GCC_DEBUG_MUX_MUXR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00062000)
#define HWIO_GCC_DEBUG_MUX_MUXR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00062000)
#define HWIO_GCC_PLL_TEST_MUX_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0006200c)
#define HWIO_GCC_PLL_TEST_MUX_MUXR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0006200c)
#define HWIO_GCC_PLL_TEST_MUX_MUXR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0006200c)
#define HWIO_GCC_PLL_RESET_N_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00062018)
#define HWIO_GCC_PLL_RESET_N_MUXR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00062018)
#define HWIO_GCC_PLL_RESET_N_MUXR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00062018)
#define HWIO_GCC_PLL_STATUS_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x0006201c)
#define HWIO_GCC_PLL_STATUS_MUXR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x0006201c)
#define HWIO_GCC_PLL_STATUS_MUXR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x0006201c)
#define HWIO_GCC_PLL_BYPASSNL_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00062020)
#define HWIO_GCC_PLL_BYPASSNL_MUXR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00062020)
#define HWIO_GCC_PLL_BYPASSNL_MUXR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00062020)
#define HWIO_GCC_DEBUG_OR_PLL_TEST_MUX_MUXR_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00062030)
#define HWIO_GCC_DEBUG_OR_PLL_TEST_MUX_MUXR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00062030)
#define HWIO_GCC_DEBUG_OR_PLL_TEST_MUX_MUXR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00062030)
#define HWIO_GCC_PLLTEST_PAD_CFG_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00062034)
#define HWIO_GCC_PLLTEST_PAD_CFG_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00062034)
#define HWIO_GCC_PLLTEST_PAD_CFG_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00062034)
#define HWIO_GCC_CLOCK_FRQ_MEASURE_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00062038)
#define HWIO_GCC_CLOCK_FRQ_MEASURE_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00062038)
#define HWIO_GCC_CLOCK_FRQ_MEASURE_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00062038)
#define HWIO_GCC_CLOCK_FRQ_MEASURE_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0006203c)
#define HWIO_GCC_CLOCK_FRQ_MEASURE_STATUS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0006203c)
#define HWIO_GCC_CLOCK_FRQ_MEASURE_STATUS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0006203c)
#define HWIO_GCC_GDS_HW_CTRL_SW_OVRD_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00078040)
#define HWIO_GCC_GDS_HW_CTRL_SW_OVRD_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00078040)
#define HWIO_GCC_GDS_HW_CTRL_SW_OVRD_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00078040)
#define HWIO_GCC_UFS_CARD_BOOT_CLOCK_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00067000)
#define HWIO_GCC_UFS_CARD_BOOT_CLOCK_CTL_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00067000)
#define HWIO_GCC_UFS_CARD_BOOT_CLOCK_CTL_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00067000)
#define HWIO_GCC_UFS_PHY_BOOT_CLOCK_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00067020)
#define HWIO_GCC_UFS_PHY_BOOT_CLOCK_CTL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00067020)
#define HWIO_GCC_UFS_PHY_BOOT_CLOCK_CTL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00067020)
#define HWIO_GCC_USB_BOOT_CLOCK_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x00068000)
#define HWIO_GCC_USB_BOOT_CLOCK_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x00068000)
#define HWIO_GCC_USB_BOOT_CLOCK_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x00068000)
#define HWIO_GCC_VTT_EN_TIMER_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0007300c)
#define HWIO_GCC_VTT_EN_TIMER_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0007300c)
#define HWIO_GCC_VTT_EN_TIMER_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0007300c)
#define HWIO_GCC_VREF_EN_TIMER_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00073010)
#define HWIO_GCC_VREF_EN_TIMER_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x00073010)
#define HWIO_GCC_VREF_EN_TIMER_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x00073010)
#define HWIO_GCC_PVC_DATA_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00073014)
#define HWIO_GCC_PVC_DATA_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00073014)
#define HWIO_GCC_PVC_DATA_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00073014)
#define HWIO_GCC_GDS_HW_CTRL_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x00078030)
#define HWIO_GCC_GDS_HW_CTRL_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x00078030)
#define HWIO_GCC_GDS_HW_CTRL_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x00078030)
#define HWIO_GCC_WCSS_PD_CLK_DIS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00011104)
#define HWIO_GCC_WCSS_PD_CLK_DIS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00011104)
#define HWIO_GCC_WCSS_PD_CLK_DIS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00011104)
#define HWIO_GCC_SPARE0_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006d000)
#define HWIO_GCC_SPARE0_REG_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0006d000)
#define HWIO_GCC_SPARE0_REG_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0006d000)
#define HWIO_GCC_SPARE1_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0006e000)
#define HWIO_GCC_SPARE1_REG_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x0006e000)
#define HWIO_GCC_SPARE1_REG_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x0006e000)
#define HWIO_GCC_SPARE2_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00081000)
#define HWIO_GCC_SPARE2_REG_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00081000)
#define HWIO_GCC_SPARE2_REG_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00081000)
#define HWIO_GCC_SPARE3_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00042000)
#define HWIO_GCC_SPARE3_REG_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00042000)
#define HWIO_GCC_SPARE3_REG_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00042000)
#define HWIO_GCC_SPARE4_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00039000)
#define HWIO_GCC_SPARE4_REG_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00039000)
#define HWIO_GCC_SPARE4_REG_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00039000)
#define HWIO_GCC_SPARE5_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00032000)
#define HWIO_GCC_SPARE5_REG_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00032000)
#define HWIO_GCC_SPARE5_REG_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00032000)
#define HWIO_GCC_RAW_SLEEP_CLK_CTRL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0007f000)
#define HWIO_GCC_RAW_SLEEP_CLK_CTRL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0007f000)
#define HWIO_GCC_RAW_SLEEP_CLK_CTRL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0007f000)
#define HWIO_GCC_TSIF_0_RESET_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00036024)
#define HWIO_GCC_TSIF_0_RESET_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00036024)
#define HWIO_GCC_TSIF_0_RESET_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00036024)
#define HWIO_GCC_TSIF_1_RESET_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00036028)
#define HWIO_GCC_TSIF_1_RESET_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00036028)
#define HWIO_GCC_TSIF_1_RESET_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00036028)
#define HWIO_GCC_NPU_MISC_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0004d110)
#define HWIO_GCC_NPU_MISC_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0004d110)
#define HWIO_GCC_NPU_MISC_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0004d110)
#define HWIO_GCC_GPU_MISC_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00071028)
#define HWIO_GCC_GPU_MISC_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00071028)
#define HWIO_GCC_GPU_MISC_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00071028)
#define HWIO_GCC_TZ_VOTE_GPU_SMMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0007b000)
#define HWIO_GCC_TZ_VOTE_GPU_SMMU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0007b000)
#define HWIO_GCC_TZ_VOTE_GPU_SMMU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0007b000)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b004)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b004)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b004)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b008)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b008)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b008)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU2_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b00c)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU2_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b00c)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU2_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b00c)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b010)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b010)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b010)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_SF_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b014)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_SF_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b014)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_SF_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b014)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b018)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b018)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b018)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b01c)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b01c)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b01c)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b020)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b020)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b020)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b024)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b024)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b024)
#define HWIO_GCC_TZ_VOTE_ALL_SMMU_MMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0007b028)
#define HWIO_GCC_TZ_VOTE_ALL_SMMU_MMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b028)
#define HWIO_GCC_TZ_VOTE_ALL_SMMU_MMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b028)
#define HWIO_GCC_TZ_VOTE_MMU_TCU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0007b02c)
#define HWIO_GCC_TZ_VOTE_MMU_TCU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0007b02c)
#define HWIO_GCC_TZ_VOTE_MMU_TCU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0007b02c)
#define HWIO_GCC_TZ_VOTE_GPU_SMMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0007b03c)
#define HWIO_GCC_TZ_VOTE_GPU_SMMU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0007b03c)
#define HWIO_GCC_TZ_VOTE_GPU_SMMU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0007b03c)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b040)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b040)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b040)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b044)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b044)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b044)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU2_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b048)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU2_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b048)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_TBU2_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b048)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b04c)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b04c)
#define HWIO_GCC_TZ_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b04c)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b050)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b050)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b050)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_SF_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b054)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_SF_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b054)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_SF_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b054)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b058)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b058)
#define HWIO_GCC_TZ_VOTE_MMNOC_MMU_TBU_HF1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b058)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b05c)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b05c)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b05c)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007b060)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b060)
#define HWIO_GCC_TZ_VOTE_TURING_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b060)
#define HWIO_GCC_TZ_VOTE_ALL_SMMU_MMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0007b064)
#define HWIO_GCC_TZ_VOTE_ALL_SMMU_MMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007b064)
#define HWIO_GCC_TZ_VOTE_ALL_SMMU_MMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007b064)
#define HWIO_GCC_TZ_VOTE_MMU_TCU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0007b068)
#define HWIO_GCC_TZ_VOTE_MMU_TCU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0007b068)
#define HWIO_GCC_TZ_VOTE_MMU_TCU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0007b068)
#define HWIO_GCC_HYP_VOTE_GPU_SMMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0007c000)
#define HWIO_GCC_HYP_VOTE_GPU_SMMU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0007c000)
#define HWIO_GCC_HYP_VOTE_GPU_SMMU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0007c000)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c004)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c004)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c004)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c008)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c008)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c008)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c00c)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c00c)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c00c)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c010)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c010)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c010)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_SF_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c014)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_SF_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c014)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_SF_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c014)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c018)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c018)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c018)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c01c)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c01c)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c01c)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c020)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c020)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c020)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c024)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c024)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c024)
#define HWIO_GCC_HYP_VOTE_ALL_SMMU_MMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0007c028)
#define HWIO_GCC_HYP_VOTE_ALL_SMMU_MMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c028)
#define HWIO_GCC_HYP_VOTE_ALL_SMMU_MMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c028)
#define HWIO_GCC_HYP_VOTE_MMU_TCU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0007c02c)
#define HWIO_GCC_HYP_VOTE_MMU_TCU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0007c02c)
#define HWIO_GCC_HYP_VOTE_MMU_TCU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0007c02c)
#define HWIO_GCC_HYP_VOTE_GPU_SMMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0007c03c)
#define HWIO_GCC_HYP_VOTE_GPU_SMMU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0007c03c)
#define HWIO_GCC_HYP_VOTE_GPU_SMMU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0007c03c)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c040)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c040)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c040)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c044)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c044)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c044)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c048)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c048)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c048)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c04c)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c04c)
#define HWIO_GCC_HYP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c04c)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c050)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c050)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c050)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_SF_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c054)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_SF_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c054)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_SF_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c054)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c058)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c058)
#define HWIO_GCC_HYP_VOTE_MMNOC_MMU_TBU_HF1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c058)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c05c)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c05c)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c05c)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007c060)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c060)
#define HWIO_GCC_HYP_VOTE_TURING_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c060)
#define HWIO_GCC_HYP_VOTE_ALL_SMMU_MMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0007c064)
#define HWIO_GCC_HYP_VOTE_ALL_SMMU_MMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007c064)
#define HWIO_GCC_HYP_VOTE_ALL_SMMU_MMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007c064)
#define HWIO_GCC_HYP_VOTE_MMU_TCU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0007c068)
#define HWIO_GCC_HYP_VOTE_MMU_TCU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0007c068)
#define HWIO_GCC_HYP_VOTE_MMU_TCU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0007c068)
#define HWIO_GCC_HLOS1_VOTE_GPU_SMMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0007d000)
#define HWIO_GCC_HLOS1_VOTE_GPU_SMMU_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d000)
#define HWIO_GCC_HLOS1_VOTE_GPU_SMMU_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d000)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d004)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d004)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d004)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d008)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d008)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d008)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU2_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d00c)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU2_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d00c)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU2_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d00c)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d010)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d010)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d010)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_SF_CLK_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d014)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_SF_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d014)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_SF_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d014)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d018)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d018)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d018)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d01c)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d01c)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d01c)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d020)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d020)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d020)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d024)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d024)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d024)
#define HWIO_GCC_HLOS1_VOTE_ALL_SMMU_MMU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d028)
#define HWIO_GCC_HLOS1_VOTE_ALL_SMMU_MMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d028)
#define HWIO_GCC_HLOS1_VOTE_ALL_SMMU_MMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d028)
#define HWIO_GCC_HLOS1_VOTE_MMU_TCU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0007d02c)
#define HWIO_GCC_HLOS1_VOTE_MMU_TCU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d02c)
#define HWIO_GCC_HLOS1_VOTE_MMU_TCU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d02c)
#define HWIO_GCC_HLOS1_VOTE_GPU_SMMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0007d03c)
#define HWIO_GCC_HLOS1_VOTE_GPU_SMMU_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d03c)
#define HWIO_GCC_HLOS1_VOTE_GPU_SMMU_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d03c)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d040)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d040)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d040)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d044)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d044)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d044)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU2_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d048)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU2_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d048)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_TBU2_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d048)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d04c)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d04c)
#define HWIO_GCC_HLOS1_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d04c)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d050)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d050)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d050)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_SF_GDS_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d054)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_SF_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d054)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_SF_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d054)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d058)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d058)
#define HWIO_GCC_HLOS1_VOTE_MMNOC_MMU_TBU_HF1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d058)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d05c)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d05c)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d05c)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d060)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d060)
#define HWIO_GCC_HLOS1_VOTE_TURING_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d060)
#define HWIO_GCC_HLOS1_VOTE_ALL_SMMU_MMU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007d064)
#define HWIO_GCC_HLOS1_VOTE_ALL_SMMU_MMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d064)
#define HWIO_GCC_HLOS1_VOTE_ALL_SMMU_MMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d064)
#define HWIO_GCC_HLOS1_VOTE_MMU_TCU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0007d068)
#define HWIO_GCC_HLOS1_VOTE_MMU_TCU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007d068)
#define HWIO_GCC_HLOS1_VOTE_MMU_TCU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007d068)
#define HWIO_GCC_HLOS2_VOTE_GPU_SMMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0007e000)
#define HWIO_GCC_HLOS2_VOTE_GPU_SMMU_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e000)
#define HWIO_GCC_HLOS2_VOTE_GPU_SMMU_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e000)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e004)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e004)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e004)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e008)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e008)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e008)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU2_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e00c)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU2_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e00c)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU2_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e00c)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e010)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e010)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e010)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_SF_CLK_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e014)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_SF_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e014)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_SF_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e014)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e018)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e018)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e018)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e01c)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e01c)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e01c)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e020)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e020)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e020)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e024)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e024)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e024)
#define HWIO_GCC_HLOS2_VOTE_ALL_SMMU_MMU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e028)
#define HWIO_GCC_HLOS2_VOTE_ALL_SMMU_MMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e028)
#define HWIO_GCC_HLOS2_VOTE_ALL_SMMU_MMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e028)
#define HWIO_GCC_HLOS2_VOTE_MMU_TCU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0007e02c)
#define HWIO_GCC_HLOS2_VOTE_MMU_TCU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e02c)
#define HWIO_GCC_HLOS2_VOTE_MMU_TCU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e02c)
#define HWIO_GCC_HLOS2_VOTE_GPU_SMMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0007e03c)
#define HWIO_GCC_HLOS2_VOTE_GPU_SMMU_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e03c)
#define HWIO_GCC_HLOS2_VOTE_GPU_SMMU_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e03c)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e040)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e040)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e040)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e044)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e044)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e044)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU2_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e048)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU2_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e048)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_TBU2_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e048)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e04c)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e04c)
#define HWIO_GCC_HLOS2_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e04c)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e050)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e050)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e050)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_SF_GDS_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e054)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_SF_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e054)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_SF_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e054)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e058)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e058)
#define HWIO_GCC_HLOS2_VOTE_MMNOC_MMU_TBU_HF1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e058)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e05c)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e05c)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e05c)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e060)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e060)
#define HWIO_GCC_HLOS2_VOTE_TURING_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e060)
#define HWIO_GCC_HLOS2_VOTE_ALL_SMMU_MMU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0007e064)
#define HWIO_GCC_HLOS2_VOTE_ALL_SMMU_MMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e064)
#define HWIO_GCC_HLOS2_VOTE_ALL_SMMU_MMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e064)
#define HWIO_GCC_HLOS2_VOTE_MMU_TCU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0007e068)
#define HWIO_GCC_HLOS2_VOTE_MMU_TCU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0007e068)
#define HWIO_GCC_HLOS2_VOTE_MMU_TCU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0007e068)
#define HWIO_GCC_UFS_MEM_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0008c000)
#define HWIO_GCC_UFS_MEM_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0008c000)
#define HWIO_GCC_UFS_MEM_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0008c000)
#define HWIO_GCC_UFS_CARD_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0008c004)
#define HWIO_GCC_UFS_CARD_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0008c004)
#define HWIO_GCC_UFS_CARD_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0008c004)
#define HWIO_GCC_USB3_PRIM_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008c008)
#define HWIO_GCC_USB3_PRIM_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008c008)
#define HWIO_GCC_USB3_PRIM_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008c008)
#define HWIO_GCC_USB3_SEC_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0008c028)
#define HWIO_GCC_USB3_SEC_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0008c028)
#define HWIO_GCC_USB3_SEC_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0008c028)
#define HWIO_GCC_PCIE_0_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0008c00c)
#define HWIO_GCC_PCIE_0_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0008c00c)
#define HWIO_GCC_PCIE_0_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0008c00c)
#define HWIO_GCC_PCIE_1_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0008c02c)
#define HWIO_GCC_PCIE_1_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0008c02c)
#define HWIO_GCC_PCIE_1_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0008c02c)
#define HWIO_GCC_GPU_IREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008c010)
#define HWIO_GCC_GPU_IREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				   0x0008c010)
#define HWIO_GCC_GPU_IREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				   0x0008c010)
#define HWIO_GCC_RX1_USB2_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					  0x0008c014)
#define HWIO_GCC_RX1_USB2_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					  0x0008c014)
#define HWIO_GCC_RX1_USB2_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					  0x0008c014)
#define HWIO_GCC_RX2_QLINK_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008c018)
#define HWIO_GCC_RX2_QLINK_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008c018)
#define HWIO_GCC_RX2_QLINK_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008c018)
#define HWIO_GCC_RX3_CLKREF_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008c01c)
#define HWIO_GCC_RX3_CLKREF_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				     0x0008c01c)
#define HWIO_GCC_RX3_CLKREF_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				     0x0008c01c)
#define HWIO_GCC_CXO2_TX1_CLKREF_EN1_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008c020)
#define HWIO_GCC_CXO2_TX1_CLKREF_EN1_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008c020)
#define HWIO_GCC_CXO2_TX1_CLKREF_EN1_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008c020)
#define HWIO_GCC_CLKREF_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008c024)
#define HWIO_GCC_CLKREF_SPARE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x0008c024)
#define HWIO_GCC_CLKREF_SPARE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x0008c024)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					 0x0000915c)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					 0x0000915c)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					 0x0000915c)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00009160)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_STATUS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009160)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_STATUS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009160)
#define HWIO_GCC_MMNOC_HALT_REQ_GDS_HW_CTRL_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00009464)
#define HWIO_GCC_MMNOC_HALT_REQ_GDS_HW_CTRL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009464)
#define HWIO_GCC_MMNOC_HALT_REQ_GDS_HW_CTRL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009464)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_STATUS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009468)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_STATUS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009468)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_STATUS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009468)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_MASK_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0000946c)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_MASK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000946c)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_MASK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000946c)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_CLEAR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00009470)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_CLEAR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009470)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_IRQ_CLEAR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009470)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00009474)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_SPARE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00009474)
#define HWIO_GCC_MMNOC_GDS_HW_CTRL_SPARE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00009474)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00082678)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00082678)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00082678)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_STATUS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008267c)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_STATUS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008267c)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_STATUS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008267c)
#define HWIO_GCC_ANOC_HALT_REQ_GDS_HW_CTRL_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00082680)
#define HWIO_GCC_ANOC_HALT_REQ_GDS_HW_CTRL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082680)
#define HWIO_GCC_ANOC_HALT_REQ_GDS_HW_CTRL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082680)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_STATUS_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00082684)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_STATUS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082684)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_STATUS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082684)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_MASK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00082688)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_MASK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082688)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_MASK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082688)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_CLEAR_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008268c)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_CLEAR_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008268c)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_IRQ_CLEAR_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008268c)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_SPARE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00082690)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_SPARE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00082690)
#define HWIO_GCC_ANOC_TBU_GDS_HW_CTRL_SPARE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00082690)
#define HWIO_GCC_MSS_MISC_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008a024)
#define HWIO_GCC_MSS_MISC_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008a024)
#define HWIO_GCC_MSS_MISC_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008a024)
#define HWIO_GCC_SP_VOTE_GPU_SMMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00086000)
#define HWIO_GCC_SP_VOTE_GPU_SMMU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00086000)
#define HWIO_GCC_SP_VOTE_GPU_SMMU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00086000)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086004)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086004)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086004)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086008)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086008)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086008)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008600c)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008600c)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008600c)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086010)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086010)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086010)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_SF_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086014)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_SF_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086014)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_SF_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086014)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086018)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086018)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086018)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008601c)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008601c)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008601c)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086020)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086020)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086020)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086024)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086024)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086024)
#define HWIO_GCC_SP_VOTE_ALL_SMMU_MMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00086028)
#define HWIO_GCC_SP_VOTE_ALL_SMMU_MMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086028)
#define HWIO_GCC_SP_VOTE_ALL_SMMU_MMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086028)
#define HWIO_GCC_SP_VOTE_MMU_TCU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x0008602c)
#define HWIO_GCC_SP_VOTE_MMU_TCU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x0008602c)
#define HWIO_GCC_SP_VOTE_MMU_TCU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x0008602c)
#define HWIO_GCC_SP_VOTE_GPU_SMMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0008603c)
#define HWIO_GCC_SP_VOTE_GPU_SMMU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0008603c)
#define HWIO_GCC_SP_VOTE_GPU_SMMU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0008603c)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086040)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086040)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086040)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086044)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086044)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086044)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086048)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086048)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086048)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008604c)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008604c)
#define HWIO_GCC_SP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008604c)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086050)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086050)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086050)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_SF_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086054)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_SF_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086054)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_SF_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086054)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086058)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086058)
#define HWIO_GCC_SP_VOTE_MMNOC_MMU_TBU_HF1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086058)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008605c)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008605c)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008605c)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00086060)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086060)
#define HWIO_GCC_SP_VOTE_TURING_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086060)
#define HWIO_GCC_SP_VOTE_ALL_SMMU_MMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00086064)
#define HWIO_GCC_SP_VOTE_ALL_SMMU_MMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00086064)
#define HWIO_GCC_SP_VOTE_ALL_SMMU_MMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00086064)
#define HWIO_GCC_SP_VOTE_MMU_TCU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					   0x00086068)
#define HWIO_GCC_SP_VOTE_MMU_TCU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
					   0x00086068)
#define HWIO_GCC_SP_VOTE_MMU_TCU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
					   0x00086068)
#define HWIO_GCC_MSS_VOTE_GPU_SMMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00087000)
#define HWIO_GCC_MSS_VOTE_GPU_SMMU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00087000)
#define HWIO_GCC_MSS_VOTE_GPU_SMMU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00087000)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087004)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087004)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087004)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU1_CLK_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00087008)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU1_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087008)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU1_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087008)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU2_CLK_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0008700c)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU2_CLK_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008700c)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU2_CLK_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008700c)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087010)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087010)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087010)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_SF_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087014)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_SF_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087014)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_SF_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087014)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087018)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087018)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087018)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008701c)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008701c)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008701c)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087020)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087020)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087020)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087024)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087024)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087024)
#define HWIO_GCC_MSS_VOTE_ALL_SMMU_MMU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00087028)
#define HWIO_GCC_MSS_VOTE_ALL_SMMU_MMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087028)
#define HWIO_GCC_MSS_VOTE_ALL_SMMU_MMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087028)
#define HWIO_GCC_MSS_VOTE_MMU_TCU_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x0008702c)
#define HWIO_GCC_MSS_VOTE_MMU_TCU_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x0008702c)
#define HWIO_GCC_MSS_VOTE_MMU_TCU_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x0008702c)
#define HWIO_GCC_MSS_VOTE_GPU_SMMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x0008703c)
#define HWIO_GCC_MSS_VOTE_GPU_SMMU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x0008703c)
#define HWIO_GCC_MSS_VOTE_GPU_SMMU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x0008703c)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087040)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087040)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087040)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU1_GDS_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00087044)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU1_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087044)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU1_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087044)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU2_GDS_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00087048)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU2_GDS_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087048)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_TBU2_GDS_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087048)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008704c)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008704c)
#define HWIO_GCC_MSS_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008704c)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087050)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087050)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087050)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_SF_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087054)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_SF_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087054)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_SF_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087054)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087058)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087058)
#define HWIO_GCC_MSS_VOTE_MMNOC_MMU_TBU_HF1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087058)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0008705c)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0008705c)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0008705c)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00087060)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087060)
#define HWIO_GCC_MSS_VOTE_TURING_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087060)
#define HWIO_GCC_MSS_VOTE_ALL_SMMU_MMU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00087064)
#define HWIO_GCC_MSS_VOTE_ALL_SMMU_MMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00087064)
#define HWIO_GCC_MSS_VOTE_ALL_SMMU_MMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00087064)
#define HWIO_GCC_MSS_VOTE_MMU_TCU_GDS_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					    0x00087068)
#define HWIO_GCC_MSS_VOTE_MMU_TCU_GDS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					    + 0x00087068)
#define HWIO_GCC_MSS_VOTE_MMU_TCU_GDS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					    + 0x00087068)
#define HWIO_GCC_TURING_DSP_VOTE_GPU_SMMU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019000)
#define HWIO_GCC_TURING_DSP_VOTE_GPU_SMMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019000)
#define HWIO_GCC_TURING_DSP_VOTE_GPU_SMMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019000)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019004)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019004)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019004)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019008)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019008)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019008)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001900c)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001900c)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU2_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001900c)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019010)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019010)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019010)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_SF_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019014)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_SF_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019014)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_SF_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019014)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019018)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019018)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019018)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001901c)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001901c)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001901c)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU0_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019020)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU0_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019020)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU0_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019020)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU1_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019024)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU1_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019024)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU1_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019024)
#define HWIO_GCC_TURING_DSP_VOTE_ALL_SMMU_MMU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019028)
#define HWIO_GCC_TURING_DSP_VOTE_ALL_SMMU_MMU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019028)
#define HWIO_GCC_TURING_DSP_VOTE_ALL_SMMU_MMU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019028)
#define HWIO_GCC_TURING_DSP_VOTE_MMU_TCU_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001902c)
#define HWIO_GCC_TURING_DSP_VOTE_MMU_TCU_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001902c)
#define HWIO_GCC_TURING_DSP_VOTE_MMU_TCU_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001902c)
#define HWIO_GCC_TURING_DSP_VOTE_GPU_SMMU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001903c)
#define HWIO_GCC_TURING_DSP_VOTE_GPU_SMMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001903c)
#define HWIO_GCC_TURING_DSP_VOTE_GPU_SMMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001903c)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019040)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019040)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_AUDIO_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019040)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019044)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019044)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019044)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019048)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019048)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_TBU2_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019048)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001904c)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001904c)
#define HWIO_GCC_TURING_DSP_VOTE_AGGRE_NOC_MMU_PCIE_TBU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001904c)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019050)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019050)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019050)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_SF_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019054)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_SF_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019054)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_SF_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019054)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019058)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019058)
#define HWIO_GCC_TURING_DSP_VOTE_MMNOC_MMU_TBU_HF1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019058)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU0_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0001905c)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU0_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0001905c)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU0_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0001905c)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU1_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019060)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU1_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019060)
#define HWIO_GCC_TURING_DSP_VOTE_TURING_MMU_TBU1_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019060)
#define HWIO_GCC_TURING_DSP_VOTE_ALL_SMMU_MMU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019064)
#define HWIO_GCC_TURING_DSP_VOTE_ALL_SMMU_MMU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019064)
#define HWIO_GCC_TURING_DSP_VOTE_ALL_SMMU_MMU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019064)
#define HWIO_GCC_TURING_DSP_VOTE_MMU_TCU_GDS_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00019068)
#define HWIO_GCC_TURING_DSP_VOTE_MMU_TCU_GDS_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00019068)
#define HWIO_GCC_TURING_DSP_VOTE_MMU_TCU_GDS_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00019068)
#define HWIO_GCC_RPM_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00051024)
#define HWIO_GCC_RPM_VOTE_QDSS_APB_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00051024)
#define HWIO_GCC_RPM_VOTE_QDSS_APB_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00051024)
#define HWIO_GCC_MSS_Q6_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00035024)
#define HWIO_GCC_MSS_Q6_VOTE_QDSS_APB_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00035024)
#define HWIO_GCC_MSS_Q6_VOTE_QDSS_APB_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00035024)
#define HWIO_GCC_APCS_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00052024)
#define HWIO_GCC_APCS_VOTE_QDSS_APB_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00052024)
#define HWIO_GCC_APCS_VOTE_QDSS_APB_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00052024)
#define HWIO_GCC_APCS_TZ_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00053024)
#define HWIO_GCC_APCS_TZ_VOTE_QDSS_APB_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00053024)
#define HWIO_GCC_APCS_TZ_VOTE_QDSS_APB_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00053024)
#define HWIO_GCC_SSC_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00054024)
#define HWIO_GCC_SSC_VOTE_QDSS_APB_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00054024)
#define HWIO_GCC_SSC_VOTE_QDSS_APB_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00054024)
#define HWIO_GCC_LPASS_DSP_VOTE_QDSS_APB_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00055024)
#define HWIO_GCC_LPASS_DSP_VOTE_QDSS_APB_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00055024)
#define HWIO_GCC_LPASS_DSP_VOTE_QDSS_APB_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00055024)
#define HWIO_GCC_HYP_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE +	\
					     0x00056024)
#define HWIO_GCC_HYP_VOTE_QDSS_APB_CLK_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS \
					     + 0x00056024)
#define HWIO_GCC_HYP_VOTE_QDSS_APB_CLK_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS \
					     + 0x00056024)
#define HWIO_GCC_TURING_DSP_VOTE_QDSS_APB_CLK_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00057024)
#define HWIO_GCC_TURING_DSP_VOTE_QDSS_APB_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00057024)
#define HWIO_GCC_TURING_DSP_VOTE_QDSS_APB_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00057024)
#define HWIO_GCC_SPARE1_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0005a024)
#define HWIO_GCC_SPARE1_VOTE_QDSS_APB_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0005a024)
#define HWIO_GCC_SPARE1_VOTE_QDSS_APB_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0005a024)
#define HWIO_GCC_SPARE2_VOTE_QDSS_APB_CLK_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00069024)
#define HWIO_GCC_SPARE2_VOTE_QDSS_APB_CLK_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00069024)
#define HWIO_GCC_SPARE2_VOTE_QDSS_APB_CLK_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00069024)
#define HWIO_GCC_JBIST_MODE_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00080000)
#define HWIO_GCC_JBIST_MODE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00080000)
#define HWIO_GCC_JBIST_MODE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00080000)
#define HWIO_GCC_JBIST_CONFIG_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x00080004)
#define HWIO_GCC_JBIST_CONFIG_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x00080004)
#define HWIO_GCC_JBIST_CONFIG_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x00080004)
#define HWIO_GCC_JBIST_USER_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00080008)
#define HWIO_GCC_JBIST_USER_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00080008)
#define HWIO_GCC_JBIST_USER_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00080008)
#define HWIO_GCC_JBIST_USER_CTL_U_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					0x0008000c)
#define HWIO_GCC_JBIST_USER_CTL_U_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS +	\
					0x0008000c)
#define HWIO_GCC_JBIST_USER_CTL_U_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS +	\
					0x0008000c)
#define HWIO_GCC_JBIST_TEST_CTL_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				      0x00080010)
#define HWIO_GCC_JBIST_TEST_CTL_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				      0x00080010)
#define HWIO_GCC_JBIST_TEST_CTL_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				      0x00080010)
#define HWIO_GCC_JBIST_STATUS_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00080014)
#define HWIO_GCC_JBIST_STATUS_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00080014)
#define HWIO_GCC_JBIST_STATUS_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00080014)
#define HWIO_GCC_JBIST_MEAS_DONE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
				       0x00080018)
#define HWIO_GCC_JBIST_MEAS_DONE_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				       0x00080018)
#define HWIO_GCC_JBIST_MEAS_DONE_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				       0x00080018)
#define HWIO_GCC_GLOBAL_EN_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x0008f000)
#define HWIO_GCC_GLOBAL_EN_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x0008f000)
#define HWIO_GCC_GLOBAL_EN_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x0008f000)
#define HWIO_GCC_CAM_CC_GDSCR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006100)
#define HWIO_GCC_CAM_CC_GDSCR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				    0x00006100)
#define HWIO_GCC_CAM_CC_GDSCR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				    0x00006100)
#define HWIO_GCC_WCSS_MISC_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00011100)
#define HWIO_GCC_WCSS_MISC_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00011100)
#define HWIO_GCC_WCSS_MISC_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00011100)
#define HWIO_GCC_GPLL0_CONFIG_CTL_FUSE_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00000100)
#define HWIO_GCC_GPLL0_CONFIG_CTL_FUSE_REG_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000100)
#define HWIO_GCC_GPLL0_CONFIG_CTL_FUSE_REG_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000100)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U_FUSE_REG_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00000104)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U_FUSE_REG_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000104)
#define HWIO_GCC_GPLL0_CONFIG_CTL_U_FUSE_REG_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000104)
#define HWIO_GCC_GPLL0_TEST_CTL_FUSE_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00000108)
#define HWIO_GCC_GPLL0_TEST_CTL_FUSE_REG_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00000108)
#define HWIO_GCC_GPLL0_TEST_CTL_FUSE_REG_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00000108)
#define HWIO_GCC_GPLL0_TEST_CTL_U_FUSE_REG_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0000010c)
#define HWIO_GCC_GPLL0_TEST_CTL_U_FUSE_REG_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0000010c)
#define HWIO_GCC_GPLL0_TEST_CTL_U_FUSE_REG_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0000010c)
#define HWIO_GCC_PLL0_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00000114)
#define HWIO_GCC_PLL0_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00000114)
#define HWIO_GCC_PLL0_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00000114)
#define HWIO_GCC_PLL1_CDIVR_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00001114)
#define HWIO_GCC_PLL1_CDIVR_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				  0x00001114)
#define HWIO_GCC_PLL1_CDIVR_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				  0x00001114)
#define HWIO_GCC_RPMH_SYS_NOC_PERF0_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00094000)
#define HWIO_GCC_RPMH_SYS_NOC_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094000)
#define HWIO_GCC_RPMH_SYS_NOC_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094000)
#define HWIO_GCC_RPMH_SYS_NOC_PERF1_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091004)
#define HWIO_GCC_RPMH_SYS_NOC_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091004)
#define HWIO_GCC_RPMH_SYS_NOC_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091004)
#define HWIO_GCC_RPMH_SYS_NOC_PERF2_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091008)
#define HWIO_GCC_RPMH_SYS_NOC_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091008)
#define HWIO_GCC_RPMH_SYS_NOC_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091008)
#define HWIO_GCC_RPMH_SYS_NOC_PERF3_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009100c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009100c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009100c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF4_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091010)
#define HWIO_GCC_RPMH_SYS_NOC_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091010)
#define HWIO_GCC_RPMH_SYS_NOC_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091010)
#define HWIO_GCC_RPMH_SYS_NOC_PERF5_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091014)
#define HWIO_GCC_RPMH_SYS_NOC_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091014)
#define HWIO_GCC_RPMH_SYS_NOC_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091014)
#define HWIO_GCC_RPMH_SYS_NOC_PERF6_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091018)
#define HWIO_GCC_RPMH_SYS_NOC_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091018)
#define HWIO_GCC_RPMH_SYS_NOC_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091018)
#define HWIO_GCC_RPMH_SYS_NOC_PERF7_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009101c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009101c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009101c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF8_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091020)
#define HWIO_GCC_RPMH_SYS_NOC_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091020)
#define HWIO_GCC_RPMH_SYS_NOC_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091020)
#define HWIO_GCC_RPMH_SYS_NOC_PERF9_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091024)
#define HWIO_GCC_RPMH_SYS_NOC_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091024)
#define HWIO_GCC_RPMH_SYS_NOC_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091024)
#define HWIO_GCC_RPMH_SYS_NOC_PERF10_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091028)
#define HWIO_GCC_RPMH_SYS_NOC_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091028)
#define HWIO_GCC_RPMH_SYS_NOC_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091028)
#define HWIO_GCC_RPMH_SYS_NOC_PERF11_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009102c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009102c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009102c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF12_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091030)
#define HWIO_GCC_RPMH_SYS_NOC_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091030)
#define HWIO_GCC_RPMH_SYS_NOC_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091030)
#define HWIO_GCC_RPMH_SYS_NOC_PERF13_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091034)
#define HWIO_GCC_RPMH_SYS_NOC_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091034)
#define HWIO_GCC_RPMH_SYS_NOC_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091034)
#define HWIO_GCC_RPMH_SYS_NOC_PERF14_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00091038)
#define HWIO_GCC_RPMH_SYS_NOC_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00091038)
#define HWIO_GCC_RPMH_SYS_NOC_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00091038)
#define HWIO_GCC_RPMH_SYS_NOC_PERF15_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009103c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009103c)
#define HWIO_GCC_RPMH_SYS_NOC_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009103c)
#define HWIO_GCC_RPMH_CNOC_PERF0_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092004)
#define HWIO_GCC_RPMH_CNOC_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092004)
#define HWIO_GCC_RPMH_CNOC_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092004)
#define HWIO_GCC_RPMH_CNOC_PERF1_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092008)
#define HWIO_GCC_RPMH_CNOC_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092008)
#define HWIO_GCC_RPMH_CNOC_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092008)
#define HWIO_GCC_RPMH_CNOC_PERF2_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009200c)
#define HWIO_GCC_RPMH_CNOC_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009200c)
#define HWIO_GCC_RPMH_CNOC_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009200c)
#define HWIO_GCC_RPMH_CNOC_PERF3_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092010)
#define HWIO_GCC_RPMH_CNOC_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092010)
#define HWIO_GCC_RPMH_CNOC_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092010)
#define HWIO_GCC_RPMH_CNOC_PERF4_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092014)
#define HWIO_GCC_RPMH_CNOC_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092014)
#define HWIO_GCC_RPMH_CNOC_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092014)
#define HWIO_GCC_RPMH_CNOC_PERF5_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092018)
#define HWIO_GCC_RPMH_CNOC_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092018)
#define HWIO_GCC_RPMH_CNOC_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092018)
#define HWIO_GCC_RPMH_CNOC_PERF6_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009201c)
#define HWIO_GCC_RPMH_CNOC_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009201c)
#define HWIO_GCC_RPMH_CNOC_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009201c)
#define HWIO_GCC_RPMH_CNOC_PERF7_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092020)
#define HWIO_GCC_RPMH_CNOC_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092020)
#define HWIO_GCC_RPMH_CNOC_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092020)
#define HWIO_GCC_RPMH_CNOC_PERF8_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092024)
#define HWIO_GCC_RPMH_CNOC_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092024)
#define HWIO_GCC_RPMH_CNOC_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092024)
#define HWIO_GCC_RPMH_CNOC_PERF9_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00092028)
#define HWIO_GCC_RPMH_CNOC_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092028)
#define HWIO_GCC_RPMH_CNOC_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092028)
#define HWIO_GCC_RPMH_CNOC_PERF10_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009202c)
#define HWIO_GCC_RPMH_CNOC_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009202c)
#define HWIO_GCC_RPMH_CNOC_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009202c)
#define HWIO_GCC_RPMH_CNOC_PERF11_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00092030)
#define HWIO_GCC_RPMH_CNOC_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092030)
#define HWIO_GCC_RPMH_CNOC_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092030)
#define HWIO_GCC_RPMH_CNOC_PERF12_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00092034)
#define HWIO_GCC_RPMH_CNOC_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092034)
#define HWIO_GCC_RPMH_CNOC_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092034)
#define HWIO_GCC_RPMH_CNOC_PERF13_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00092038)
#define HWIO_GCC_RPMH_CNOC_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092038)
#define HWIO_GCC_RPMH_CNOC_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092038)
#define HWIO_GCC_RPMH_CNOC_PERF14_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009203c)
#define HWIO_GCC_RPMH_CNOC_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009203c)
#define HWIO_GCC_RPMH_CNOC_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009203c)
#define HWIO_GCC_RPMH_CNOC_PERF15_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00092040)
#define HWIO_GCC_RPMH_CNOC_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00092040)
#define HWIO_GCC_RPMH_CNOC_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00092040)
#define HWIO_GCC_RPMH_IPA_PERF0_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093004)
#define HWIO_GCC_RPMH_IPA_PERF0_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093004)
#define HWIO_GCC_RPMH_IPA_PERF0_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093004)
#define HWIO_GCC_RPMH_IPA_PERF1_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093008)
#define HWIO_GCC_RPMH_IPA_PERF1_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093008)
#define HWIO_GCC_RPMH_IPA_PERF1_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093008)
#define HWIO_GCC_RPMH_IPA_PERF2_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0009300c)
#define HWIO_GCC_RPMH_IPA_PERF2_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009300c)
#define HWIO_GCC_RPMH_IPA_PERF2_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009300c)
#define HWIO_GCC_RPMH_IPA_PERF3_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093010)
#define HWIO_GCC_RPMH_IPA_PERF3_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093010)
#define HWIO_GCC_RPMH_IPA_PERF3_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093010)
#define HWIO_GCC_RPMH_IPA_PERF4_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093014)
#define HWIO_GCC_RPMH_IPA_PERF4_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093014)
#define HWIO_GCC_RPMH_IPA_PERF4_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093014)
#define HWIO_GCC_RPMH_IPA_PERF5_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093018)
#define HWIO_GCC_RPMH_IPA_PERF5_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093018)
#define HWIO_GCC_RPMH_IPA_PERF5_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093018)
#define HWIO_GCC_RPMH_IPA_PERF6_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0009301c)
#define HWIO_GCC_RPMH_IPA_PERF6_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009301c)
#define HWIO_GCC_RPMH_IPA_PERF6_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009301c)
#define HWIO_GCC_RPMH_IPA_PERF7_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093020)
#define HWIO_GCC_RPMH_IPA_PERF7_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093020)
#define HWIO_GCC_RPMH_IPA_PERF7_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093020)
#define HWIO_GCC_RPMH_IPA_PERF8_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093024)
#define HWIO_GCC_RPMH_IPA_PERF8_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093024)
#define HWIO_GCC_RPMH_IPA_PERF8_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093024)
#define HWIO_GCC_RPMH_IPA_PERF9_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00093028)
#define HWIO_GCC_RPMH_IPA_PERF9_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093028)
#define HWIO_GCC_RPMH_IPA_PERF9_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093028)
#define HWIO_GCC_RPMH_IPA_PERF10_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009302c)
#define HWIO_GCC_RPMH_IPA_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009302c)
#define HWIO_GCC_RPMH_IPA_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009302c)
#define HWIO_GCC_RPMH_IPA_PERF11_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00093030)
#define HWIO_GCC_RPMH_IPA_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093030)
#define HWIO_GCC_RPMH_IPA_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093030)
#define HWIO_GCC_RPMH_IPA_PERF12_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00093034)
#define HWIO_GCC_RPMH_IPA_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093034)
#define HWIO_GCC_RPMH_IPA_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093034)
#define HWIO_GCC_RPMH_IPA_PERF13_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00093038)
#define HWIO_GCC_RPMH_IPA_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093038)
#define HWIO_GCC_RPMH_IPA_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093038)
#define HWIO_GCC_RPMH_IPA_PERF14_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009303c)
#define HWIO_GCC_RPMH_IPA_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009303c)
#define HWIO_GCC_RPMH_IPA_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009303c)
#define HWIO_GCC_RPMH_IPA_PERF15_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00093040)
#define HWIO_GCC_RPMH_IPA_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00093040)
#define HWIO_GCC_RPMH_IPA_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00093040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF0_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b004)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b004)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b004)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF1_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b008)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b008)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b008)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF2_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b00c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b00c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b00c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF3_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b010)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b010)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b010)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF4_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b014)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b014)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b014)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF5_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b018)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b018)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b018)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF6_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b01c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b01c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b01c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF7_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b020)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b020)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b020)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF8_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b024)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b024)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b024)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF9_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b028)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b028)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b028)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF10_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b02c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b02c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b02c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF11_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b030)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b030)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b030)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF12_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b034)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF13_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b038)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF14_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b03c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b03c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b03c)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF15_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009b040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009b040)
#define HWIO_GCC_RPMH_QUPV3_CORE_2X_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009b040)
#define HWIO_GCC_RPMH_CE_PERF0_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094004)
#define HWIO_GCC_RPMH_CE_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094004)
#define HWIO_GCC_RPMH_CE_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094004)
#define HWIO_GCC_RPMH_CE_PERF1_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094008)
#define HWIO_GCC_RPMH_CE_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094008)
#define HWIO_GCC_RPMH_CE_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094008)
#define HWIO_GCC_RPMH_CE_PERF2_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0009400c)
#define HWIO_GCC_RPMH_CE_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009400c)
#define HWIO_GCC_RPMH_CE_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009400c)
#define HWIO_GCC_RPMH_CE_PERF3_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094010)
#define HWIO_GCC_RPMH_CE_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094010)
#define HWIO_GCC_RPMH_CE_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094010)
#define HWIO_GCC_RPMH_CE_PERF4_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094014)
#define HWIO_GCC_RPMH_CE_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094014)
#define HWIO_GCC_RPMH_CE_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094014)
#define HWIO_GCC_RPMH_CE_PERF5_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094018)
#define HWIO_GCC_RPMH_CE_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094018)
#define HWIO_GCC_RPMH_CE_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094018)
#define HWIO_GCC_RPMH_CE_PERF6_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x0009401c)
#define HWIO_GCC_RPMH_CE_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009401c)
#define HWIO_GCC_RPMH_CE_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009401c)
#define HWIO_GCC_RPMH_CE_PERF7_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094020)
#define HWIO_GCC_RPMH_CE_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094020)
#define HWIO_GCC_RPMH_CE_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094020)
#define HWIO_GCC_RPMH_CE_PERF8_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094024)
#define HWIO_GCC_RPMH_CE_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094024)
#define HWIO_GCC_RPMH_CE_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094024)
#define HWIO_GCC_RPMH_CE_PERF9_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					      0x00094028)
#define HWIO_GCC_RPMH_CE_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094028)
#define HWIO_GCC_RPMH_CE_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094028)
#define HWIO_GCC_RPMH_CE_PERF10_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0009402c)
#define HWIO_GCC_RPMH_CE_PERF10_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009402c)
#define HWIO_GCC_RPMH_CE_PERF10_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009402c)
#define HWIO_GCC_RPMH_CE_PERF11_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00094030)
#define HWIO_GCC_RPMH_CE_PERF11_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094030)
#define HWIO_GCC_RPMH_CE_PERF11_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094030)
#define HWIO_GCC_RPMH_CE_PERF12_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00094034)
#define HWIO_GCC_RPMH_CE_PERF12_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094034)
#define HWIO_GCC_RPMH_CE_PERF12_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094034)
#define HWIO_GCC_RPMH_CE_PERF13_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00094038)
#define HWIO_GCC_RPMH_CE_PERF13_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094038)
#define HWIO_GCC_RPMH_CE_PERF13_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094038)
#define HWIO_GCC_RPMH_CE_PERF14_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x0009403c)
#define HWIO_GCC_RPMH_CE_PERF14_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009403c)
#define HWIO_GCC_RPMH_CE_PERF14_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009403c)
#define HWIO_GCC_RPMH_CE_PERF15_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
					       0x00094040)
#define HWIO_GCC_RPMH_CE_PERF15_ENA_VOTE_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00094040)
#define HWIO_GCC_RPMH_CE_PERF15_ENA_VOTE_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00094040)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF0_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c004)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c004)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c004)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF1_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c008)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c008)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c008)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF2_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c00c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c00c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c00c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF3_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c010)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c010)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c010)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF4_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c014)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c014)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c014)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF5_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c018)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c018)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c018)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF6_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c01c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c01c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c01c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF7_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c020)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c020)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c020)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF8_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c024)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c024)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c024)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF9_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c028)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c028)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c028)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF10_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c02c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c02c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c02c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF11_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c030)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c030)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c030)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF12_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c034)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c034)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c034)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF13_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c038)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c038)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c038)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF14_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c03c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c03c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c03c)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF15_ENA_VOTE_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009c040)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009c040)
#define HWIO_GCC_RPMH_CDSP_NOC_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009c040)
#define HWIO_GCC_RPMH_MMNOC_PERF0_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095004)
#define HWIO_GCC_RPMH_MMNOC_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095004)
#define HWIO_GCC_RPMH_MMNOC_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095004)
#define HWIO_GCC_RPMH_MMNOC_PERF1_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095008)
#define HWIO_GCC_RPMH_MMNOC_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095008)
#define HWIO_GCC_RPMH_MMNOC_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095008)
#define HWIO_GCC_RPMH_MMNOC_PERF2_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009500c)
#define HWIO_GCC_RPMH_MMNOC_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009500c)
#define HWIO_GCC_RPMH_MMNOC_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009500c)
#define HWIO_GCC_RPMH_MMNOC_PERF3_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095010)
#define HWIO_GCC_RPMH_MMNOC_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095010)
#define HWIO_GCC_RPMH_MMNOC_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095010)
#define HWIO_GCC_RPMH_MMNOC_PERF4_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095014)
#define HWIO_GCC_RPMH_MMNOC_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095014)
#define HWIO_GCC_RPMH_MMNOC_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095014)
#define HWIO_GCC_RPMH_MMNOC_PERF5_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095018)
#define HWIO_GCC_RPMH_MMNOC_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095018)
#define HWIO_GCC_RPMH_MMNOC_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095018)
#define HWIO_GCC_RPMH_MMNOC_PERF6_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009501c)
#define HWIO_GCC_RPMH_MMNOC_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009501c)
#define HWIO_GCC_RPMH_MMNOC_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009501c)
#define HWIO_GCC_RPMH_MMNOC_PERF7_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095020)
#define HWIO_GCC_RPMH_MMNOC_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095020)
#define HWIO_GCC_RPMH_MMNOC_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095020)
#define HWIO_GCC_RPMH_MMNOC_PERF8_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095024)
#define HWIO_GCC_RPMH_MMNOC_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095024)
#define HWIO_GCC_RPMH_MMNOC_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095024)
#define HWIO_GCC_RPMH_MMNOC_PERF9_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00095028)
#define HWIO_GCC_RPMH_MMNOC_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095028)
#define HWIO_GCC_RPMH_MMNOC_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095028)
#define HWIO_GCC_RPMH_MMNOC_PERF10_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009502c)
#define HWIO_GCC_RPMH_MMNOC_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009502c)
#define HWIO_GCC_RPMH_MMNOC_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009502c)
#define HWIO_GCC_RPMH_MMNOC_PERF11_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00095030)
#define HWIO_GCC_RPMH_MMNOC_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095030)
#define HWIO_GCC_RPMH_MMNOC_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095030)
#define HWIO_GCC_RPMH_MMNOC_PERF12_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00095034)
#define HWIO_GCC_RPMH_MMNOC_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095034)
#define HWIO_GCC_RPMH_MMNOC_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095034)
#define HWIO_GCC_RPMH_MMNOC_PERF13_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00095038)
#define HWIO_GCC_RPMH_MMNOC_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095038)
#define HWIO_GCC_RPMH_MMNOC_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095038)
#define HWIO_GCC_RPMH_MMNOC_PERF14_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009503c)
#define HWIO_GCC_RPMH_MMNOC_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009503c)
#define HWIO_GCC_RPMH_MMNOC_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009503c)
#define HWIO_GCC_RPMH_MMNOC_PERF15_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x00095040)
#define HWIO_GCC_RPMH_MMNOC_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00095040)
#define HWIO_GCC_RPMH_MMNOC_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00095040)
#define HWIO_GCC_RPMH_SHUB_PERF0_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096004)
#define HWIO_GCC_RPMH_SHUB_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096004)
#define HWIO_GCC_RPMH_SHUB_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096004)
#define HWIO_GCC_RPMH_SHUB_PERF1_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096008)
#define HWIO_GCC_RPMH_SHUB_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096008)
#define HWIO_GCC_RPMH_SHUB_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096008)
#define HWIO_GCC_RPMH_SHUB_PERF2_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009600c)
#define HWIO_GCC_RPMH_SHUB_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009600c)
#define HWIO_GCC_RPMH_SHUB_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009600c)
#define HWIO_GCC_RPMH_SHUB_PERF3_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096010)
#define HWIO_GCC_RPMH_SHUB_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096010)
#define HWIO_GCC_RPMH_SHUB_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096010)
#define HWIO_GCC_RPMH_SHUB_PERF4_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096014)
#define HWIO_GCC_RPMH_SHUB_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096014)
#define HWIO_GCC_RPMH_SHUB_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096014)
#define HWIO_GCC_RPMH_SHUB_PERF5_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096018)
#define HWIO_GCC_RPMH_SHUB_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096018)
#define HWIO_GCC_RPMH_SHUB_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096018)
#define HWIO_GCC_RPMH_SHUB_PERF6_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009601c)
#define HWIO_GCC_RPMH_SHUB_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009601c)
#define HWIO_GCC_RPMH_SHUB_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009601c)
#define HWIO_GCC_RPMH_SHUB_PERF7_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096020)
#define HWIO_GCC_RPMH_SHUB_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096020)
#define HWIO_GCC_RPMH_SHUB_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096020)
#define HWIO_GCC_RPMH_SHUB_PERF8_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096024)
#define HWIO_GCC_RPMH_SHUB_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096024)
#define HWIO_GCC_RPMH_SHUB_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096024)
#define HWIO_GCC_RPMH_SHUB_PERF9_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00096028)
#define HWIO_GCC_RPMH_SHUB_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096028)
#define HWIO_GCC_RPMH_SHUB_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096028)
#define HWIO_GCC_RPMH_SHUB_PERF10_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009602c)
#define HWIO_GCC_RPMH_SHUB_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009602c)
#define HWIO_GCC_RPMH_SHUB_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009602c)
#define HWIO_GCC_RPMH_SHUB_PERF11_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00096030)
#define HWIO_GCC_RPMH_SHUB_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096030)
#define HWIO_GCC_RPMH_SHUB_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096030)
#define HWIO_GCC_RPMH_SHUB_PERF12_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00096034)
#define HWIO_GCC_RPMH_SHUB_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096034)
#define HWIO_GCC_RPMH_SHUB_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096034)
#define HWIO_GCC_RPMH_SHUB_PERF13_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00096038)
#define HWIO_GCC_RPMH_SHUB_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096038)
#define HWIO_GCC_RPMH_SHUB_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096038)
#define HWIO_GCC_RPMH_SHUB_PERF14_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009603c)
#define HWIO_GCC_RPMH_SHUB_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009603c)
#define HWIO_GCC_RPMH_SHUB_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009603c)
#define HWIO_GCC_RPMH_SHUB_PERF15_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00096040)
#define HWIO_GCC_RPMH_SHUB_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00096040)
#define HWIO_GCC_RPMH_SHUB_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00096040)
#define HWIO_GCC_RPMH_SHRM_PERF0_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097004)
#define HWIO_GCC_RPMH_SHRM_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097004)
#define HWIO_GCC_RPMH_SHRM_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097004)
#define HWIO_GCC_RPMH_SHRM_PERF1_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097008)
#define HWIO_GCC_RPMH_SHRM_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097008)
#define HWIO_GCC_RPMH_SHRM_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097008)
#define HWIO_GCC_RPMH_SHRM_PERF2_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009700c)
#define HWIO_GCC_RPMH_SHRM_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009700c)
#define HWIO_GCC_RPMH_SHRM_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009700c)
#define HWIO_GCC_RPMH_SHRM_PERF3_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097010)
#define HWIO_GCC_RPMH_SHRM_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097010)
#define HWIO_GCC_RPMH_SHRM_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097010)
#define HWIO_GCC_RPMH_SHRM_PERF4_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097014)
#define HWIO_GCC_RPMH_SHRM_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097014)
#define HWIO_GCC_RPMH_SHRM_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097014)
#define HWIO_GCC_RPMH_SHRM_PERF5_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097018)
#define HWIO_GCC_RPMH_SHRM_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097018)
#define HWIO_GCC_RPMH_SHRM_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097018)
#define HWIO_GCC_RPMH_SHRM_PERF6_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x0009701c)
#define HWIO_GCC_RPMH_SHRM_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009701c)
#define HWIO_GCC_RPMH_SHRM_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009701c)
#define HWIO_GCC_RPMH_SHRM_PERF7_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097020)
#define HWIO_GCC_RPMH_SHRM_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097020)
#define HWIO_GCC_RPMH_SHRM_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097020)
#define HWIO_GCC_RPMH_SHRM_PERF8_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097024)
#define HWIO_GCC_RPMH_SHRM_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097024)
#define HWIO_GCC_RPMH_SHRM_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097024)
#define HWIO_GCC_RPMH_SHRM_PERF9_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE + \
						0x00097028)
#define HWIO_GCC_RPMH_SHRM_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097028)
#define HWIO_GCC_RPMH_SHRM_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097028)
#define HWIO_GCC_RPMH_SHRM_PERF10_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009702c)
#define HWIO_GCC_RPMH_SHRM_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009702c)
#define HWIO_GCC_RPMH_SHRM_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009702c)
#define HWIO_GCC_RPMH_SHRM_PERF11_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00097030)
#define HWIO_GCC_RPMH_SHRM_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097030)
#define HWIO_GCC_RPMH_SHRM_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097030)
#define HWIO_GCC_RPMH_SHRM_PERF12_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00097034)
#define HWIO_GCC_RPMH_SHRM_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097034)
#define HWIO_GCC_RPMH_SHRM_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097034)
#define HWIO_GCC_RPMH_SHRM_PERF13_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00097038)
#define HWIO_GCC_RPMH_SHRM_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097038)
#define HWIO_GCC_RPMH_SHRM_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097038)
#define HWIO_GCC_RPMH_SHRM_PERF14_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009703c)
#define HWIO_GCC_RPMH_SHRM_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009703c)
#define HWIO_GCC_RPMH_SHRM_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009703c)
#define HWIO_GCC_RPMH_SHRM_PERF15_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x00097040)
#define HWIO_GCC_RPMH_SHRM_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00097040)
#define HWIO_GCC_RPMH_SHRM_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00097040)
#define HWIO_GCC_RPMH_DDRMC_PERF0_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a004)
#define HWIO_GCC_RPMH_DDRMC_PERF0_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a004)
#define HWIO_GCC_RPMH_DDRMC_PERF0_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a004)
#define HWIO_GCC_RPMH_DDRMC_PERF1_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a008)
#define HWIO_GCC_RPMH_DDRMC_PERF1_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a008)
#define HWIO_GCC_RPMH_DDRMC_PERF1_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a008)
#define HWIO_GCC_RPMH_DDRMC_PERF2_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a00c)
#define HWIO_GCC_RPMH_DDRMC_PERF2_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a00c)
#define HWIO_GCC_RPMH_DDRMC_PERF2_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a00c)
#define HWIO_GCC_RPMH_DDRMC_PERF3_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a010)
#define HWIO_GCC_RPMH_DDRMC_PERF3_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a010)
#define HWIO_GCC_RPMH_DDRMC_PERF3_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a010)
#define HWIO_GCC_RPMH_DDRMC_PERF4_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a014)
#define HWIO_GCC_RPMH_DDRMC_PERF4_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a014)
#define HWIO_GCC_RPMH_DDRMC_PERF4_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a014)
#define HWIO_GCC_RPMH_DDRMC_PERF5_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a018)
#define HWIO_GCC_RPMH_DDRMC_PERF5_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a018)
#define HWIO_GCC_RPMH_DDRMC_PERF5_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a018)
#define HWIO_GCC_RPMH_DDRMC_PERF6_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a01c)
#define HWIO_GCC_RPMH_DDRMC_PERF6_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a01c)
#define HWIO_GCC_RPMH_DDRMC_PERF6_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a01c)
#define HWIO_GCC_RPMH_DDRMC_PERF7_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a020)
#define HWIO_GCC_RPMH_DDRMC_PERF7_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a020)
#define HWIO_GCC_RPMH_DDRMC_PERF7_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a020)
#define HWIO_GCC_RPMH_DDRMC_PERF8_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a024)
#define HWIO_GCC_RPMH_DDRMC_PERF8_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a024)
#define HWIO_GCC_RPMH_DDRMC_PERF8_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a024)
#define HWIO_GCC_RPMH_DDRMC_PERF9_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						 + 0x0009a028)
#define HWIO_GCC_RPMH_DDRMC_PERF9_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a028)
#define HWIO_GCC_RPMH_DDRMC_PERF9_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a028)
#define HWIO_GCC_RPMH_DDRMC_PERF10_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009a02c)
#define HWIO_GCC_RPMH_DDRMC_PERF10_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a02c)
#define HWIO_GCC_RPMH_DDRMC_PERF10_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a02c)
#define HWIO_GCC_RPMH_DDRMC_PERF11_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009a030)
#define HWIO_GCC_RPMH_DDRMC_PERF11_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a030)
#define HWIO_GCC_RPMH_DDRMC_PERF11_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a030)
#define HWIO_GCC_RPMH_DDRMC_PERF12_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009a034)
#define HWIO_GCC_RPMH_DDRMC_PERF12_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a034)
#define HWIO_GCC_RPMH_DDRMC_PERF12_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a034)
#define HWIO_GCC_RPMH_DDRMC_PERF13_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009a038)
#define HWIO_GCC_RPMH_DDRMC_PERF13_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a038)
#define HWIO_GCC_RPMH_DDRMC_PERF13_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a038)
#define HWIO_GCC_RPMH_DDRMC_PERF14_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009a03c)
#define HWIO_GCC_RPMH_DDRMC_PERF14_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a03c)
#define HWIO_GCC_RPMH_DDRMC_PERF14_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a03c)
#define HWIO_GCC_RPMH_DDRMC_PERF15_ENA_VOTE_ADDR (GCC_CLK_CTL_REG_REG_BASE \
						  + 0x0009a040)
#define HWIO_GCC_RPMH_DDRMC_PERF15_ENA_VOTE_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009a040)
#define HWIO_GCC_RPMH_DDRMC_PERF15_ENA_VOTE_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009a040)
#define HWIO_GCC_RPMH_DDRMC_PERF0_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098004)
#define HWIO_GCC_RPMH_DDRMC_PERF0_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098004)
#define HWIO_GCC_RPMH_DDRMC_PERF0_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098004)
#define HWIO_GCC_RPMH_DDRMC_PERF1_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098008)
#define HWIO_GCC_RPMH_DDRMC_PERF1_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098008)
#define HWIO_GCC_RPMH_DDRMC_PERF1_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098008)
#define HWIO_GCC_RPMH_DDRMC_PERF2_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009800c)
#define HWIO_GCC_RPMH_DDRMC_PERF2_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009800c)
#define HWIO_GCC_RPMH_DDRMC_PERF2_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009800c)
#define HWIO_GCC_RPMH_DDRMC_PERF3_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098010)
#define HWIO_GCC_RPMH_DDRMC_PERF3_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098010)
#define HWIO_GCC_RPMH_DDRMC_PERF3_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098010)
#define HWIO_GCC_RPMH_DDRMC_PERF4_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098014)
#define HWIO_GCC_RPMH_DDRMC_PERF4_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098014)
#define HWIO_GCC_RPMH_DDRMC_PERF4_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098014)
#define HWIO_GCC_RPMH_DDRMC_PERF5_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098018)
#define HWIO_GCC_RPMH_DDRMC_PERF5_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098018)
#define HWIO_GCC_RPMH_DDRMC_PERF5_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098018)
#define HWIO_GCC_RPMH_DDRMC_PERF6_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009801c)
#define HWIO_GCC_RPMH_DDRMC_PERF6_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009801c)
#define HWIO_GCC_RPMH_DDRMC_PERF6_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009801c)
#define HWIO_GCC_RPMH_DDRMC_PERF7_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098020)
#define HWIO_GCC_RPMH_DDRMC_PERF7_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098020)
#define HWIO_GCC_RPMH_DDRMC_PERF7_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098020)
#define HWIO_GCC_RPMH_DDRMC_PERF8_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098024)
#define HWIO_GCC_RPMH_DDRMC_PERF8_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098024)
#define HWIO_GCC_RPMH_DDRMC_PERF8_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098024)
#define HWIO_GCC_RPMH_DDRMC_PERF9_GPLL2_3_L_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00098028)
#define HWIO_GCC_RPMH_DDRMC_PERF9_GPLL2_3_L_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098028)
#define HWIO_GCC_RPMH_DDRMC_PERF9_GPLL2_3_L_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098028)
#define HWIO_GCC_RPMH_DDRMC_PERF10_GPLL2_3_L_VAL_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0009802c)
#define HWIO_GCC_RPMH_DDRMC_PERF10_GPLL2_3_L_VAL_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009802c)
#define HWIO_GCC_RPMH_DDRMC_PERF10_GPLL2_3_L_VAL_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009802c)
#define HWIO_GCC_RPMH_DDRMC_PERF11_GPLL2_3_L_VAL_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00098030)
#define HWIO_GCC_RPMH_DDRMC_PERF11_GPLL2_3_L_VAL_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098030)
#define HWIO_GCC_RPMH_DDRMC_PERF11_GPLL2_3_L_VAL_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098030)
#define HWIO_GCC_RPMH_DDRMC_PERF12_GPLL2_3_L_VAL_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00098034)
#define HWIO_GCC_RPMH_DDRMC_PERF12_GPLL2_3_L_VAL_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098034)
#define HWIO_GCC_RPMH_DDRMC_PERF12_GPLL2_3_L_VAL_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098034)
#define HWIO_GCC_RPMH_DDRMC_PERF13_GPLL2_3_L_VAL_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00098038)
#define HWIO_GCC_RPMH_DDRMC_PERF13_GPLL2_3_L_VAL_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098038)
#define HWIO_GCC_RPMH_DDRMC_PERF13_GPLL2_3_L_VAL_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098038)
#define HWIO_GCC_RPMH_DDRMC_PERF14_GPLL2_3_L_VAL_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x0009803c)
#define HWIO_GCC_RPMH_DDRMC_PERF14_GPLL2_3_L_VAL_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009803c)
#define HWIO_GCC_RPMH_DDRMC_PERF14_GPLL2_3_L_VAL_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009803c)
#define HWIO_GCC_RPMH_DDRMC_PERF15_GPLL2_3_L_VAL_ADDR (	\
		GCC_CLK_CTL_REG_REG_BASE + 0x00098040)
#define HWIO_GCC_RPMH_DDRMC_PERF15_GPLL2_3_L_VAL_PHYS (	\
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00098040)
#define HWIO_GCC_RPMH_DDRMC_PERF15_GPLL2_3_L_VAL_OFFS (	\
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00098040)
#define HWIO_GCC_RPMH_DDRMC_PERF0_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099004)
#define HWIO_GCC_RPMH_DDRMC_PERF0_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099004)
#define HWIO_GCC_RPMH_DDRMC_PERF0_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099004)
#define HWIO_GCC_RPMH_DDRMC_PERF1_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099008)
#define HWIO_GCC_RPMH_DDRMC_PERF1_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099008)
#define HWIO_GCC_RPMH_DDRMC_PERF1_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099008)
#define HWIO_GCC_RPMH_DDRMC_PERF2_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009900c)
#define HWIO_GCC_RPMH_DDRMC_PERF2_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009900c)
#define HWIO_GCC_RPMH_DDRMC_PERF2_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009900c)
#define HWIO_GCC_RPMH_DDRMC_PERF3_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099010)
#define HWIO_GCC_RPMH_DDRMC_PERF3_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099010)
#define HWIO_GCC_RPMH_DDRMC_PERF3_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099010)
#define HWIO_GCC_RPMH_DDRMC_PERF4_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099014)
#define HWIO_GCC_RPMH_DDRMC_PERF4_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099014)
#define HWIO_GCC_RPMH_DDRMC_PERF4_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099014)
#define HWIO_GCC_RPMH_DDRMC_PERF5_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099018)
#define HWIO_GCC_RPMH_DDRMC_PERF5_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099018)
#define HWIO_GCC_RPMH_DDRMC_PERF5_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099018)
#define HWIO_GCC_RPMH_DDRMC_PERF6_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009901c)
#define HWIO_GCC_RPMH_DDRMC_PERF6_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009901c)
#define HWIO_GCC_RPMH_DDRMC_PERF6_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009901c)
#define HWIO_GCC_RPMH_DDRMC_PERF7_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099020)
#define HWIO_GCC_RPMH_DDRMC_PERF7_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099020)
#define HWIO_GCC_RPMH_DDRMC_PERF7_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099020)
#define HWIO_GCC_RPMH_DDRMC_PERF8_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099024)
#define HWIO_GCC_RPMH_DDRMC_PERF8_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099024)
#define HWIO_GCC_RPMH_DDRMC_PERF8_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099024)
#define HWIO_GCC_RPMH_DDRMC_PERF9_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099028)
#define HWIO_GCC_RPMH_DDRMC_PERF9_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099028)
#define HWIO_GCC_RPMH_DDRMC_PERF9_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099028)
#define HWIO_GCC_RPMH_DDRMC_PERF10_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009902c)
#define HWIO_GCC_RPMH_DDRMC_PERF10_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009902c)
#define HWIO_GCC_RPMH_DDRMC_PERF10_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009902c)
#define HWIO_GCC_RPMH_DDRMC_PERF11_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099030)
#define HWIO_GCC_RPMH_DDRMC_PERF11_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099030)
#define HWIO_GCC_RPMH_DDRMC_PERF11_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099030)
#define HWIO_GCC_RPMH_DDRMC_PERF12_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099034)
#define HWIO_GCC_RPMH_DDRMC_PERF12_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099034)
#define HWIO_GCC_RPMH_DDRMC_PERF12_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099034)
#define HWIO_GCC_RPMH_DDRMC_PERF13_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099038)
#define HWIO_GCC_RPMH_DDRMC_PERF13_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099038)
#define HWIO_GCC_RPMH_DDRMC_PERF13_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099038)
#define HWIO_GCC_RPMH_DDRMC_PERF14_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x0009903c)
#define HWIO_GCC_RPMH_DDRMC_PERF14_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x0009903c)
#define HWIO_GCC_RPMH_DDRMC_PERF14_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x0009903c)
#define HWIO_GCC_RPMH_DDRMC_PERF15_GPLL2_3_FRAC_VAL_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099040)
#define HWIO_GCC_RPMH_DDRMC_PERF15_GPLL2_3_FRAC_VAL_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099040)
#define HWIO_GCC_RPMH_DDRMC_PERF15_GPLL2_3_FRAC_VAL_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099040)
#define HWIO_GCC_RPMH_DDRMC_FAKE_SWITCH_DEBUG_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00099080)
#define HWIO_GCC_RPMH_DDRMC_FAKE_SWITCH_DEBUG_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00099080)
#define HWIO_GCC_RPMH_DDRMC_FAKE_SWITCH_DEBUG_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00099080)
#define HWIO_GCC_RPMH_DDRMC_CLOCK_SWITCH_MISC_ADDR ( \
		GCC_CLK_CTL_REG_REG_BASE + 0x00044530)
#define HWIO_GCC_RPMH_DDRMC_CLOCK_SWITCH_MISC_PHYS ( \
		GCC_CLK_CTL_REG_REG_BASE_PHYS + 0x00044530)
#define HWIO_GCC_RPMH_DDRMC_CLOCK_SWITCH_MISC_OFFS ( \
		GCC_CLK_CTL_REG_REG_BASE_OFFS + 0x00044530)
#define HWIO_GCC_EMAC_MISC_ADDR (GCC_CLK_CTL_REG_REG_BASE + 0x00006040)
#define HWIO_GCC_EMAC_MISC_PHYS (GCC_CLK_CTL_REG_REG_BASE_PHYS + \
				 0x00006040)
#define HWIO_GCC_EMAC_MISC_OFFS (GCC_CLK_CTL_REG_REG_BASE_OFFS + \
				 0x00006040)
#endif
