/* Copyright (c) 2020, The Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#ifndef _CRYPTO_INLINE_CRYPTO_ENGINE_REGS_H_
#define _CRYPTO_INLINE_CRYPTO_ENGINE_REGS_H_

#include <linux/io.h>

/* Register bits for ICE version */
#if IS_ENABLED(CONFIG_MMC_QTI_NONCMDQ_ICE)
#define ICE_CORE_CURRENT_MAJOR_VERSION 0x02
#else
#define ICE_CORE_CURRENT_MAJOR_VERSION 0x03
#endif

#define ICE_CORE_STEP_REV_MASK		0xFFFF
#define ICE_CORE_STEP_REV		0 /* bit 15-0 */
#define ICE_CORE_MAJOR_REV_MASK		0xFF000000
#define ICE_CORE_MAJOR_REV		24 /* bit 31-24 */
#define ICE_CORE_MINOR_REV_MASK		0xFF0000
#define ICE_CORE_MINOR_REV		16 /* bit 23-16 */

#define ICE_BIST_STATUS_MASK		(0xF0000000)	/* bits 28-31 */

#define ICE_FUSE_SETTING_MASK			0x1
#define ICE_FORCE_HW_KEY0_SETTING_MASK		0x2
#define ICE_FORCE_HW_KEY1_SETTING_MASK		0x4

/* QTI ICE Registers from SWI */
#define ICE_REGS_CONTROL			0x0000
#define ICE_REGS_RESET				0x0004
#define ICE_REGS_VERSION			0x0008
#define ICE_REGS_FUSE_SETTING			0x0010
#define ICE_REGS_PARAMETERS_1			0x0014
#define ICE_REGS_PARAMETERS_2			0x0018
#define ICE_REGS_PARAMETERS_3			0x001C
#define ICE_REGS_PARAMETERS_4			0x0020
#define ICE_REGS_PARAMETERS_5			0x0024


/* QTI ICE v3.X only */
#define ICE_GENERAL_ERR_STTS			0x0040
#define ICE_INVALID_CCFG_ERR_STTS		0x0030
#define ICE_GENERAL_ERR_MASK			0x0044


/* QTI ICE v2.X only */
#define ICE_REGS_NON_SEC_IRQ_STTS		0x0040
#define ICE_REGS_NON_SEC_IRQ_MASK		0x0044


#define ICE_REGS_NON_SEC_IRQ_CLR		0x0048
#define ICE_REGS_STREAM1_ERROR_SYNDROME1	0x0050
#define ICE_REGS_STREAM1_ERROR_SYNDROME2	0x0054
#define ICE_REGS_STREAM2_ERROR_SYNDROME1	0x0058
#define ICE_REGS_STREAM2_ERROR_SYNDROME2	0x005C
#define ICE_REGS_STREAM1_BIST_ERROR_VEC		0x0060
#define ICE_REGS_STREAM2_BIST_ERROR_VEC		0x0064
#define ICE_REGS_STREAM1_BIST_FINISH_VEC	0x0068
#define ICE_REGS_STREAM2_BIST_FINISH_VEC	0x006C
#define ICE_REGS_BIST_STATUS			0x0070
#define ICE_REGS_BYPASS_STATUS			0x0074
#define ICE_REGS_ADVANCED_CONTROL		0x1000
#define ICE_REGS_ENDIAN_SWAP			0x1004
#define ICE_REGS_TEST_BUS_CONTROL		0x1010
#define ICE_REGS_TEST_BUS_REG			0x1014
#define ICE_REGS_STREAM1_COUNTERS1		0x1100
#define ICE_REGS_STREAM1_COUNTERS2		0x1104
#define ICE_REGS_STREAM1_COUNTERS3		0x1108
#define ICE_REGS_STREAM1_COUNTERS4		0x110C
#define ICE_REGS_STREAM1_COUNTERS5_MSB		0x1110
#define ICE_REGS_STREAM1_COUNTERS5_LSB		0x1114
#define ICE_REGS_STREAM1_COUNTERS6_MSB		0x1118
#define ICE_REGS_STREAM1_COUNTERS6_LSB		0x111C
#define ICE_REGS_STREAM1_COUNTERS7_MSB		0x1120
#define ICE_REGS_STREAM1_COUNTERS7_LSB		0x1124
#define ICE_REGS_STREAM1_COUNTERS8_MSB		0x1128
#define ICE_REGS_STREAM1_COUNTERS8_LSB		0x112C
#define ICE_REGS_STREAM1_COUNTERS9_MSB		0x1130
#define ICE_REGS_STREAM1_COUNTERS9_LSB		0x1134
#define ICE_REGS_STREAM2_COUNTERS1		0x1200
#define ICE_REGS_STREAM2_COUNTERS2		0x1204
#define ICE_REGS_STREAM2_COUNTERS3		0x1208
#define ICE_REGS_STREAM2_COUNTERS4		0x120C
#define ICE_REGS_STREAM2_COUNTERS5_MSB		0x1210
#define ICE_REGS_STREAM2_COUNTERS5_LSB		0x1214
#define ICE_REGS_STREAM2_COUNTERS6_MSB		0x1218
#define ICE_REGS_STREAM2_COUNTERS6_LSB		0x121C
#define ICE_REGS_STREAM2_COUNTERS7_MSB		0x1220
#define ICE_REGS_STREAM2_COUNTERS7_LSB		0x1224
#define ICE_REGS_STREAM2_COUNTERS8_MSB		0x1228
#define ICE_REGS_STREAM2_COUNTERS8_LSB		0x122C
#define ICE_REGS_STREAM2_COUNTERS9_MSB		0x1230
#define ICE_REGS_STREAM2_COUNTERS9_LSB		0x1234

#define ICE_STREAM1_PREMATURE_LBA_CHANGE	(1L << 0)
#define ICE_STREAM2_PREMATURE_LBA_CHANGE	(1L << 1)
#define ICE_STREAM1_NOT_EXPECTED_LBO		(1L << 2)
#define ICE_STREAM2_NOT_EXPECTED_LBO		(1L << 3)
#define ICE_STREAM1_NOT_EXPECTED_DUN		(1L << 4)
#define ICE_STREAM2_NOT_EXPECTED_DUN		(1L << 5)
#define ICE_STREAM1_NOT_EXPECTED_DUS		(1L << 6)
#define ICE_STREAM2_NOT_EXPECTED_DUS		(1L << 7)
#define ICE_STREAM1_NOT_EXPECTED_DBO		(1L << 8)
#define ICE_STREAM2_NOT_EXPECTED_DBO		(1L << 9)
#define ICE_STREAM1_NOT_EXPECTED_ENC_SEL	(1L << 10)
#define ICE_STREAM2_NOT_EXPECTED_ENC_SEL	(1L << 11)
#define ICE_STREAM1_NOT_EXPECTED_CONF_IDX	(1L << 12)
#define ICE_STREAM2_NOT_EXPECTED_CONF_IDX	(1L << 13)
#define ICE_STREAM1_NOT_EXPECTED_NEW_TRNS	(1L << 14)
#define ICE_STREAM2_NOT_EXPECTED_NEW_TRNS	(1L << 15)

#define ICE_NON_SEC_IRQ_MASK				\
			(ICE_STREAM1_PREMATURE_LBA_CHANGE |\
			 ICE_STREAM2_PREMATURE_LBA_CHANGE |\
			 ICE_STREAM1_NOT_EXPECTED_LBO |\
			 ICE_STREAM2_NOT_EXPECTED_LBO |\
			 ICE_STREAM1_NOT_EXPECTED_DUN |\
			 ICE_STREAM2_NOT_EXPECTED_DUN |\
			 ICE_STREAM2_NOT_EXPECTED_DUS |\
			 ICE_STREAM1_NOT_EXPECTED_DBO |\
			 ICE_STREAM2_NOT_EXPECTED_DBO |\
			 ICE_STREAM1_NOT_EXPECTED_ENC_SEL |\
			 ICE_STREAM2_NOT_EXPECTED_ENC_SEL |\
			 ICE_STREAM1_NOT_EXPECTED_CONF_IDX |\
			 ICE_STREAM1_NOT_EXPECTED_NEW_TRNS |\
			 ICE_STREAM2_NOT_EXPECTED_NEW_TRNS)

/* QTI ICE registers from secure side */
#define ICE_TEST_BUS_REG_SECURE_INTR            (1L << 28)
#define ICE_TEST_BUS_REG_NON_SECURE_INTR        (1L << 2)

#define ICE_LUT_KEYS_CRYPTOCFG_R_16		0x4040
#define ICE_LUT_KEYS_CRYPTOCFG_R_17		0x4044
#define ICE_LUT_KEYS_CRYPTOCFG_OFFSET		0x80


#define ICE_LUT_KEYS_ICE_SEC_IRQ_STTS		0x6200
#define ICE_LUT_KEYS_ICE_SEC_IRQ_MASK		0x6204
#define ICE_LUT_KEYS_ICE_SEC_IRQ_CLR		0x6208

#define ICE_STREAM1_PARTIALLY_SET_KEY_USED	(1L << 0)
#define ICE_STREAM2_PARTIALLY_SET_KEY_USED	(1L << 1)
#define ICE_QTIC_DBG_OPEN_EVENT			(1L << 30)
#define ICE_KEYS_RAM_RESET_COMPLETED		(1L << 31)

#define ICE_SEC_IRQ_MASK					  \
			(ICE_STREAM1_PARTIALLY_SET_KEY_USED |\
			 ICE_STREAM2_PARTIALLY_SET_KEY_USED |\
			 ICE_QTIC_DBG_OPEN_EVENT |	  \
			 ICE_KEYS_RAM_RESET_COMPLETED)

#define ice_writel(ice_entry, val, reg)	\
	writel_relaxed((val), (ice_entry)->icemmio_base + (reg))
#define ice_readl(ice_entry, reg)	\
	readl_relaxed((ice_entry)->icemmio_base + (reg))

#endif /* _CRYPTO_INLINE_CRYPTO_ENGINE_REGS_H_ */
