# API Samples

This Api samples includes variety of sample documents, applications
that illustrate the use of various TelSDK APIs, it includes samples of

  * [How to make an voice call](phone/make_call.md)
  * [How to make an emergency call E-112](phone/make_eCall.md)
  * [How to send SMS](sms/send_sms.md)
  * [How to listen for Incoming SMS](sms/listen_sms.md)
  * [How to get subscription details](subscription/get_subscription.md)
  * [How to use SAP APIs and SAP Listener](card_services/sap_api_and_listener.md)
  * [How to configure logger](logger_settings/logger_settings.md)
  * [How to get Location Reports](loc/location_services.md)
  * [How to start/stop cellular data call](data/start_or_stop_data_call.md)
  * [How to request data profile list](data/request_profile_list.md)
  * [How to get network selection details](network_selection/network_selection.md)
  * [How to serving system details](serving_system/serving_system.md)
  * [How to get C-V2X radio status](cv2x/cv2x_get_status_app.md)
  * [How to use C-V2X API for RX](cv2x/cv2x_rx_app.md)
  * [How to use C-V2X API for TX](cv2x/cv2x_tx_app.md)
  * [How to use C-V2X ThrottleManager API to set verification load](cv2x/cv2x_tm_load.md)
  * [How to use C-V2X ThrottleManager API to get filter rate adjustment notification](cv2x/cv2x_tm_filter.md)
  * [How to use Audio Manager API's](audio/audio_manager_api.md)
  * [How to start/stop audio in voice call](audio/audio_manager_voicecall_start_stop.md)
  * [How to do device switch in voice call](audio/audio_manager_voicecall_device_switch.md)
  * [How to do volume/mute control in voice call](audio/audio_manager_voicecall_volume_mute.md)
  * [How to play a DTMF tone in voice call](audio/audio_voicecall_dtmf_play.md)
  * [How to detect DTMF tones in voice call](audio/audio_voicecall_dtmf_detect.md)
  * [How to do audio playback](audio/audio_playback.md)
  * [How to do audio capture](audio/audio_capture.md)
  * [How to get TCU activity state updates](power/get_tcu_activity_state_notifications.md)
  * [How to set TCU activity state in ACTIVE mode](power/set_tcu_activity_state_active_mode.md)
  * [How to set TCU activity state in PASSIVE mode](power/set_tcu_activity_state_passive_mode.md)
  * [How to manage thermal shutdown mode](thermal/send_thermal_shutdown_mode_commands.md)
  * [How to get thermal auto-shutdown updates](thermal/get_thermal_autoshutdown_mode_updates.md)
  * [How to use Remote Sim Manager APIs](remote_sim/remote_sim_api.md)
  * [How to do audio loopback](audio/audio_manager_loopback.md)
  * [How to generate audio tone](audio/audio_manager_tonegenerator.md)
  * [How to play compressed audio format](audio/compressed_audio_format_playback.md)
  * [How to load and activate a config file](config/load_and_activate_modem_config_file.md)
  * [How to deactivate and delete a config file](config/deactivate_and_delete_modem_config_file.md)
  * [How to set and get auto config selection mode](config/get_and_set_auto_selection_mode.md)
  * [How to get and set data filter mode](data/get_and_set_data_filter_mode.md)
  * [How to remove data filter mode](data/remove_data_filters.md)
  * [How to add data filter](data/add_data_filter.md)
  * [How to perform transcoding from one audio format to another](audio/audio_transcoding_operation.md)
  * [How to create vlan and bind it to pdn](data/create_and_bind_vlan.md)
  * [How to create static nat entry](data/create_snat_entry.md)
  * [How to create firewall dmz](data/create_firewall_dmz.md)
  * [How to enable/disable firewall](data/enable_disable_firewall.md)
  * [How to add and enable a software bridge](data/add_enable_software_bridge.md)
  * [How to remove and disable a software bridge](data/remove_disable_software_bridge.md)
  * [How to add firewall entry](data/add_firewall_entry.md)
  * [How to play compressed format audio on voice paths](audio/compressed_audio_format_playback_on_voice_paths.md)
  * [How to enable/disable socks proxy](data/enable_disable_socks.md)
  * [How to use Location Configurator APIs](loc/location_services_configurator.md)
  * [How to use L2TP Configurator APIs](data/enable_and_add_tunnel_l2tp.md)
  * [How to acquire sensor data](sensor/sensor_data_acquisition.md)
  * [How to control sensor features](sensor/sensor_feature_control.md)
  * [How to use Logging APIs](common/public_logging.md)
  * [How to get dedicated radio bearer status](data/get_drb_status_and_indication.md)
  * [How to get data service status](data/get_service_status_and_indication.md)
  * [How to get data roaming status](data/get_roaming_status_and_indication.md)
  * [How to trigger sensor self test](sensor/sensor_self_test.md)
  * [How to receive EFS restore indications](platform/efs_restore_indications.md)
  * [How to perform an ECALL operation](platform/ecall_operation.md)
  * [How to perform an OTA operation](platform/ota_operation.md)
