/*
 *  Copyright (c) 2021, The Linux Foundation. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions are
 *  met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above
 *      copyright notice, this list of conditions and the following
 *      disclaimer in the documentation and/or other materials provided
 *      with the distribution.
 *    * Neither the name of The Linux Foundation nor the names of its
 *      contributors may be used to endorse or promote products derived
 *      from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT
 *  ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 *  BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *  OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
 *  IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @file       PlatformFactory.hpp
 *
 * @brief      PlatformFactory creates a set of managers which provide the corresponding
 *             platform services.
 */

#ifndef TELUX_PLATFORM_PLATFORMFACTORY_HPP
#define TELUX_PLATFORM_PLATFORMFACTORY_HPP

#include <memory>

#include <telux/common/CommonDefines.hpp>
#include <telux/platform/FsManager.hpp>

namespace telux {

namespace platform {
/** @addtogroup telematics_platform
 * @{ */

/**
 * @brief   PlatformFactory allows creation of Platform services related classes.
 */

class PlatformFactory {
 public:
    /**
     * Get instance of platform Factory
     */
    static PlatformFactory &getInstance();

    /**
     * Get instance of filesystem manager (IFsManager). The filesystem manager supports
     * notification of filesystem events like EFS restore indications.
     *
     * @param [in] callback      Optional callback to get the initialization status of
     *                           FsManager. @ref telux::common::InitResponseCb
     *
     * @returns pointer of @ref IFsManager object.
     */
    virtual std::shared_ptr<IFsManager> getFsManager(
        telux::common::InitResponseCb callback = nullptr) = 0;

 protected:
    PlatformFactory();
    virtual ~PlatformFactory();

 private:
    PlatformFactory(const PlatformFactory &) = delete;
    PlatformFactory &operator=(const PlatformFactory &) = delete;
};

/** @} */ /* end_addtogroup telematics_platform */
}  // end of namespace platform

}  // end of namespace telux

#endif  // TELUX_PLATFORM_PLATFORMFACTORY_HPP
